/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.function.Consumer;
import javax.measure.Quantity;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.operation.MathTransform;

public class ImageCombiner
implements Consumer<RenderedImage> {
    private final ImageProcessor processor;
    private final WritableRenderedImage destination;
    private final Layout layout;

    public ImageCombiner(WritableRenderedImage writableRenderedImage) {
        this(writableRenderedImage, new ImageProcessor());
    }

    public ImageCombiner(WritableRenderedImage writableRenderedImage, ImageProcessor imageProcessor) {
        ArgumentChecks.ensureNonNull("destination", writableRenderedImage);
        ArgumentChecks.ensureNonNull("processor", imageProcessor);
        this.destination = writableRenderedImage;
        this.processor = imageProcessor;
        this.layout = new Layout(writableRenderedImage.getSampleModel());
    }

    public Interpolation getInterpolation() {
        return this.processor.getInterpolation();
    }

    public void setInterpolation(Interpolation interpolation) {
        this.processor.setInterpolation(interpolation);
    }

    public Quantity<?>[] getPositionalAccuracyHints() {
        return this.processor.getPositionalAccuracyHints();
    }

    public void setPositionalAccuracyHints(Quantity<?> ... quantityArray) {
        this.processor.setPositionalAccuracyHints(quantityArray);
    }

    @Override
    public void accept(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull("source", renderedImage);
        final WritableRenderedImage writableRenderedImage = this.destination;
        Rectangle rectangle = ImageUtilities.getBounds(renderedImage);
        ImageUtilities.clipBounds(writableRenderedImage, rectangle);
        if (!rectangle.isEmpty()) {
            TileOpExecutor tileOpExecutor = new TileOpExecutor(renderedImage, rectangle){

                @Override
                protected void readFrom(Raster raster) {
                    writableRenderedImage.setData(raster);
                }
            };
            tileOpExecutor.readFrom(this.processor.prefetch(renderedImage, rectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resample(RenderedImage renderedImage, Rectangle rectangle, MathTransform mathTransform) {
        RenderedImage renderedImage2;
        ArgumentChecks.ensureNonNull("source", renderedImage);
        ArgumentChecks.ensureNonNull("toSource", mathTransform);
        if (rectangle == null) {
            rectangle = ImageUtilities.getBounds(this.destination);
        }
        int n = this.destination.getTileWidth();
        int n2 = this.destination.getTileHeight();
        long l = this.destination.getTileGridXOffset();
        long l2 = this.destination.getTileGridYOffset();
        int n3 = Math.toIntExact(Math.floorDiv((long)rectangle.x - l, (long)n));
        int n4 = Math.toIntExact(Math.floorDiv((long)rectangle.y - l2, (long)n2));
        int n5 = Math.toIntExact(JDK9.multiplyFull(n3, n) + l);
        int n6 = Math.toIntExact(JDK9.multiplyFull(n4, n2) + l2);
        long l3 = (long)rectangle.x + (long)rectangle.width - 1L;
        long l4 = (long)rectangle.y + (long)rectangle.height - 1L;
        l3 = Numerics.ceilDiv(l3 - l, (long)n) * (long)n + l;
        l4 = Numerics.ceilDiv(l4 - l2, (long)n) * (long)n2 + l2;
        rectangle = new Rectangle(n5, n6, Math.toIntExact(l3 - (long)n5 + 1L), Math.toIntExact(l4 - (long)n6 + 1L));
        ImageProcessor imageProcessor = this.processor;
        synchronized (imageProcessor) {
            Point point = this.layout.minTile;
            point.x = n3;
            point.y = n4;
            this.processor.setImageLayout(this.layout);
            renderedImage2 = this.processor.resample(renderedImage, rectangle, mathTransform);
        }
        if (renderedImage2 instanceof ComputedImage) {
            ((ComputedImage)renderedImage2).setDestination(this.destination);
            this.processor.prefetch(renderedImage2, ImageUtilities.getBounds(this.destination));
        } else {
            this.accept(renderedImage2);
        }
    }

    public RenderedImage result() {
        return this.destination;
    }

    private static final class Layout
    extends ImageLayout {
        private final SampleModel sampleModel;
        final Point minTile;

        Layout(SampleModel sampleModel) {
            super(null, false);
            ArgumentChecks.ensureNonNull("sampleModel", sampleModel);
            this.sampleModel = sampleModel;
            this.minTile = new Point();
        }

        @Override
        public SampleModel createCompatibleSampleModel(RenderedImage renderedImage, Rectangle rectangle) {
            return this.sampleModel;
        }

        @Override
        public Point getMinTile() {
            return this.minTile;
        }
    }
}

