/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.logs.EventBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.SdkReadWriteLogRecord;
import io.opentelemetry.sdk.logs.data.Body;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkLogRecordBuilder
implements EventBuilder {
    private final LoggerSharedState loggerSharedState;
    private final LogLimits logLimits;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private long epochNanos;
    @Nullable
    private Context context;
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    private Body body = Body.empty();
    @Nullable
    private AttributesMap attributes;

    SdkLogRecordBuilder(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.loggerSharedState = loggerSharedState;
        this.logLimits = loggerSharedState.getLogLimits();
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    public SdkLogRecordBuilder setEpoch(long timestamp, TimeUnit unit) {
        this.epochNanos = unit.toNanos(timestamp);
        return this;
    }

    public SdkLogRecordBuilder setEpoch(Instant instant) {
        this.epochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    public SdkLogRecordBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    public SdkLogRecordBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public SdkLogRecordBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    public SdkLogRecordBuilder setBody(String body) {
        this.body = Body.string(body);
        return this;
    }

    public <T> SdkLogRecordBuilder setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = AttributesMap.create((long)this.logLimits.getMaxNumberOfAttributes(), (int)this.logLimits.getMaxAttributeValueLength());
        }
        this.attributes.put(key, value);
        return this;
    }

    public void emit() {
        if (this.loggerSharedState.hasBeenShutdown()) {
            return;
        }
        Context context = this.context == null ? Context.current() : this.context;
        this.loggerSharedState.getLogRecordProcessor().onEmit(context, SdkReadWriteLogRecord.create(this.loggerSharedState.getLogLimits(), this.loggerSharedState.getResource(), this.instrumentationScopeInfo, this.epochNanos == 0L ? this.loggerSharedState.getClock().now() : this.epochNanos, Span.fromContext((Context)context).getSpanContext(), this.severity, this.severityText, this.body, this.attributes));
    }
}

