/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.CertificateKeyPair;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.factory.HandlerFactory;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificatePair;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HRRKeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.CertificateMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.CertificateMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.CertificateMessageSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.crypto.tls.Certificate;

public class CertificateMessageHandler
extends HandshakeMessageHandler<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateMessageHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public CertificateMessageParser getParser(byte[] message, int pointer) {
        return new CertificateMessageParser(pointer, message, this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getConfig());
    }

    public CertificateMessagePreparator getPreparator(CertificateMessage message) {
        return new CertificateMessagePreparator(this.tlsContext.getChooser(), message);
    }

    public CertificateMessageSerializer getSerializer(CertificateMessage message) {
        return new CertificateMessageSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    private CertificateType selectTypeInternally() {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            return this.tlsContext.getChooser().getSelectedServerCertificateType();
        }
        return this.tlsContext.getChooser().getSelectedClientCertificateType();
    }

    @Override
    public void adjustTLSContext(CertificateMessage message) {
        switch (this.selectTypeInternally()) {
            case OPEN_PGP: {
                throw new UnsupportedOperationException("We do not support OpenPGP keys");
            }
            case RAW_PUBLIC_KEY: {
                LOGGER.debug("Adjusting context for RAW PUBLIC KEY ceritifate message");
                try {
                    ASN1InputStream asn1Stream = new ASN1InputStream((byte[])message.getCertificatesListBytes().getValue());
                    DLSequence dlSeq = (DLSequence)asn1Stream.readObject();
                    DLSequence identifier = (DLSequence)dlSeq.getObjectAt(0);
                    NamedGroup group = null;
                    ASN1ObjectIdentifier keyType = (ASN1ObjectIdentifier)identifier.getObjectAt(0);
                    if (keyType.getId().equals("1.2.840.10045.2.1")) {
                        ASN1ObjectIdentifier curveType = (ASN1ObjectIdentifier)identifier.getObjectAt(1);
                        if (!curveType.getId().equals("1.2.840.10045.3.1.7")) {
                            throw new UnsupportedOperationException("We currently do only support secp256r1 public keys. Sorry...");
                        }
                        group = NamedGroup.SECP256R1;
                        DERBitString publicKey = (DERBitString)dlSeq.getObjectAt(1);
                        byte[] pointBytes = publicKey.getBytes();
                        Point publicKeyPoint = PointFormatter.formatFromByteArray(group, pointBytes);
                        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
                            this.tlsContext.setServerEcPublicKey(publicKeyPoint);
                        } else {
                            this.tlsContext.setClientEcPublicKey(publicKeyPoint);
                        }
                    } else {
                        throw new UnsupportedOperationException("We currently do only support EC raw public keys. Sorry...");
                    }
                    asn1Stream.close();
                }
                catch (Exception E) {
                    LOGGER.warn("Could read RAW PublicKey. Not adjusting context", (Throwable)E);
                }
                break;
            }
            case X509: {
                Certificate cert;
                LOGGER.debug("Adjusting context for x509 ceritifate message");
                if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    int certificatesLength = 0;
                    try {
                        for (CertificatePair pair : message.getCertificatesList()) {
                            stream.write(ArrayConverter.intToBytes((int)((Integer)pair.getCertificateLength().getValue()), (int)3));
                            stream.write((byte[])pair.getCertificate().getValue());
                            certificatesLength += (Integer)pair.getCertificateLength().getValue() + 3;
                        }
                    }
                    catch (IOException ex) {
                        throw new AdjustmentException("Could not concatenate certificates bytes", ex);
                    }
                    cert = this.parseCertificate(certificatesLength, stream.toByteArray());
                } else {
                    cert = this.parseCertificate((Integer)message.getCertificatesListLength().getValue(), (byte[])message.getCertificatesListBytes().getValue());
                }
                if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
                    LOGGER.debug("Setting ClientCertificate in Context");
                    this.tlsContext.setClientCertificate(cert);
                } else {
                    LOGGER.debug("Setting ServerCertificate in Context");
                    this.tlsContext.setServerCertificate(cert);
                }
                if (message.getCertificateKeyPair() != null) {
                    LOGGER.debug("Found a certificate key pair. Adjusting in context");
                    message.getCertificateKeyPair().adjustInContext(this.tlsContext, this.tlsContext.getTalkingConnectionEndType());
                } else if (cert != null) {
                    if (cert.isEmpty()) {
                        LOGGER.debug("Certificate is empty - no adjustments");
                    } else {
                        LOGGER.debug("No CertificatekeyPair found, creating new one");
                        CertificateKeyPair pair = new CertificateKeyPair(cert);
                        message.setCertificateKeyPair(pair);
                        message.getCertificateKeyPair().adjustInContext(this.tlsContext, this.tlsContext.getTalkingConnectionEndType());
                    }
                } else {
                    LOGGER.debug("Ceritificate not parseable - no adjustments");
                }
                if (!this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) break;
                this.adjustExtensions(message);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported CertificateType!");
            }
        }
    }

    private Certificate parseCertificate(int lengthBytes, byte[] bytesToParse) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)lengthBytes, (int)3), bytesToParse}));
            return Certificate.parse((InputStream)stream);
        }
        catch (Exception E) {
            LOGGER.warn("Could not parse Certificate bytes into Certificate object:" + ArrayConverter.bytesToHexString((byte[])bytesToParse, (boolean)false), (Throwable)E);
            LOGGER.debug((Object)E);
            return null;
        }
    }

    private void adjustExtensions(CertificateMessage message) {
        if (message.getCertificatesListAsEntry() != null) {
            for (CertificateEntry entry : message.getCertificatesListAsEntry()) {
                if (entry.getExtensions() == null) continue;
                for (ExtensionMessage extension : entry.getExtensions()) {
                    HandshakeMessageType handshakeMessageType = HandshakeMessageType.CERTIFICATE;
                    if (extension instanceof HRRKeyShareExtensionMessage) {
                        handshakeMessageType = HandshakeMessageType.HELLO_RETRY_REQUEST;
                    }
                    ExtensionHandler handler = HandlerFactory.getExtensionHandler(this.tlsContext, extension.getExtensionTypeConstant(), handshakeMessageType);
                    handler.adjustTLSContext(extension);
                }
            }
        }
    }
}

