/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParserFactory;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessageParser<T extends HandshakeMessage>
extends ProtocolMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HandshakeMessageType expectedType;
    private ProtocolVersion version;

    public HandshakeMessageParser(int pointer, byte[] array, HandshakeMessageType expectedType, ProtocolVersion version, Config config) {
        super(pointer, array, version, config);
        this.expectedType = expectedType;
        this.version = version;
    }

    private void parseType(HandshakeMessage message) {
        message.setType(this.parseByteField(1));
        if (((Byte)message.getType().getValue()).byteValue() != this.expectedType.getValue() && this.expectedType != HandshakeMessageType.UNKNOWN) {
            LOGGER.warn("Parsed wrong message type. Parsed:" + message.getType().getValue() + " but expected:" + this.expectedType.getValue());
        }
        LOGGER.debug("Type:" + message.getType().getValue());
    }

    private void parseLength(HandshakeMessage message) {
        message.setLength(this.parseIntField(3));
        LOGGER.debug("Length:" + message.getLength().getValue());
    }

    @Override
    protected T parseMessageContent() {
        T msg = this.createHandshakeMessage();
        this.parseType((HandshakeMessage)msg);
        this.parseLength((HandshakeMessage)msg);
        this.parseHandshakeMessageContent(msg);
        return msg;
    }

    protected abstract void parseHandshakeMessageContent(T var1);

    protected abstract T createHandshakeMessage();

    protected void parseExtensionLength(T message) {
        ((HandshakeMessage)message).setExtensionsLength(this.parseIntField(2));
        LOGGER.debug("ExtensionLength:" + ((HandshakeMessage)message).getExtensionsLength().getValue());
    }

    protected void parseExtensionBytes(T message) {
        byte[] extensionBytes = this.parseByteArrayField((Integer)((HandshakeMessage)message).getExtensionsLength().getValue());
        ((HandshakeMessage)message).setExtensionBytes(extensionBytes);
        LOGGER.debug("ExtensionBytes:" + ArrayConverter.bytesToHexString((byte[])extensionBytes, (boolean)false));
        LinkedList<ExtensionMessage> extensionMessages = new LinkedList<ExtensionMessage>();
        int pointer = 0;
        HandshakeMessageType type = message instanceof ServerHelloMessage && ((ServerHelloMessage)message).isTls13HelloRetryRequest() != false ? HandshakeMessageType.HELLO_RETRY_REQUEST : ((HandshakeMessage)message).getHandshakeMessageType();
        while (pointer < extensionBytes.length) {
            ExtensionParser parser = ExtensionParserFactory.getExtensionParser(extensionBytes, pointer, type, this.getConfig());
            extensionMessages.add((ExtensionMessage)parser.parse());
            if (pointer == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing Extensions");
            }
            pointer = parser.getPointer();
        }
        ((HandshakeMessage)message).setExtensions(extensionMessages);
    }

    protected boolean hasExtensionLengthField(T message) {
        return (Integer)((HandshakeMessage)message).getLength().getValue() + 1 + 3 > this.getPointer() - this.getStartPoint();
    }

    protected boolean hasExtensions(T message) {
        return (Integer)((HandshakeMessage)message).getExtensionsLength().getValue() > 0;
    }

    @Override
    protected ProtocolVersion getVersion() {
        return this.version;
    }

    protected void setVersion(ProtocolVersion version) {
        this.version = version;
    }
}

