/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.List;

public class ArrayConverter {
    public static byte[] longToUint64Bytes(long l) {
        byte[] result = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return result;
    }

    public static byte[] longToUint32Bytes(long l) {
        byte[] result = new byte[]{(byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return result;
    }

    public static byte[] intToBytes(int value, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The array must be at least of size 1");
        }
        byte[] result = new byte[size];
        int shift = 0;
        int finalPosition = size > 4 ? size - 4 : 0;
        for (int i = size - 1; i >= finalPosition; --i) {
            result[i] = (byte)(value >>> shift);
            shift += 8;
        }
        return result;
    }

    public static byte[] longToBytes(long value, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The array must be at least of size 1");
        }
        byte[] result = new byte[size];
        int shift = 0;
        int finalPosition = size > 8 ? size - 8 : 0;
        for (int i = size - 1; i >= finalPosition; --i) {
            result[i] = (byte)(value >>> shift);
            shift += 8;
        }
        return result;
    }

    public static int bytesToInt(byte[] value) {
        int result = 0;
        int shift = 0;
        for (int i = value.length - 1; i >= 0; --i) {
            result += (value[i] & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] value) {
        int result = 0;
        int shift = 0;
        for (int i = value.length - 1; i >= 0; --i) {
            result += (value[i] & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static String bytesToHexString(byte[] array) {
        if (array == null) {
            array = new byte[]{};
        }
        boolean usePrettyPrinting = array.length > 15;
        return ArrayConverter.bytesToHexString(array, usePrettyPrinting);
    }

    public static String bytesToHexString(byte[] array, boolean usePrettyPrinting) {
        if (array == null) {
            array = new byte[]{};
        }
        return ArrayConverter.bytesToHexString(array, usePrettyPrinting, true);
    }

    public static String bytesToHexString(byte[] array, boolean usePrettyPrinting, boolean initialNewLine) {
        StringBuilder result = new StringBuilder();
        if (initialNewLine && usePrettyPrinting) {
            result.append("\n");
        }
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                if (usePrettyPrinting && i % 16 == 0) {
                    result.append("\n");
                } else {
                    if (usePrettyPrinting && i % 8 == 0) {
                        result.append(" ");
                    }
                    result.append(" ");
                }
            }
            byte b = array[i];
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    public static String bytesToRawHexString(byte[] array) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            byte b = array[i];
            result.append(String.format("%02X", b));
        }
        return result.toString();
    }

    public static String bytesToHexString(ModifiableByteArray array) {
        return ArrayConverter.bytesToHexString((byte[])array.getValue());
    }

    public static String bytesToHexString(ModifiableByteArray array, boolean usePrettyPrinting) {
        return ArrayConverter.bytesToHexString((byte[])array.getValue(), usePrettyPrinting, true);
    }

    public static String bytesToHexString(ModifiableByteArray array, boolean usePrettyPrinting, boolean initialNewLine) {
        return ArrayConverter.bytesToHexString((byte[])array.getValue(), usePrettyPrinting, initialNewLine);
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new IllegalArgumentException("The minimal number of parameters for this function is one");
        }
        int length = 0;
        for (T[] a : arrays) {
            length += a.length;
        }
        Object[] result = (Object[])Array.newInstance(arrays[0].getClass().getComponentType(), length);
        int currentOffset = 0;
        for (T[] a : arrays) {
            System.arraycopy(a, 0, result, currentOffset, a.length);
            currentOffset += a.length;
        }
        return result;
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new IllegalArgumentException("The minimal number of parameters for this function is one");
        }
        int length = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            length += a.length;
        }
        byte[] result = new byte[length];
        int currentOffset = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            System.arraycopy(a, 0, result, currentOffset, a.length);
            currentOffset += a.length;
        }
        return result;
    }

    public static byte[] concatenate(byte[] array1, byte[] array2, int numberOfArray2Bytes) {
        int length = array1.length + numberOfArray2Bytes;
        byte[] result = new byte[length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, numberOfArray2Bytes);
        return result;
    }

    public static void makeArrayNonZero(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != 0) continue;
            array[i] = 1;
        }
    }

    public static byte[] bigIntegerToByteArray(BigInteger value, int blockSize, boolean removeSignByte) {
        byte[] tmp;
        if (blockSize == 0) {
            return new byte[0];
        }
        byte[] array = value.toByteArray();
        int remainder = array.length % blockSize;
        byte[] result = array;
        if (removeSignByte && result[0] == 0) {
            tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
            remainder = tmp.length % blockSize;
        }
        if (remainder > 0) {
            tmp = new byte[result.length + blockSize - remainder];
            System.arraycopy(result, 0, tmp, blockSize - remainder, result.length);
            result = tmp;
        }
        return result;
    }

    public static byte[] bigIntegerToByteArray(BigInteger value) {
        byte[] result = value.toByteArray();
        if (result[0] == 0) {
            byte[] tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
        }
        return result;
    }

    public static BigInteger[] convertListToArray(List<BigInteger> list) {
        BigInteger[] result = new BigInteger[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String input) {
        if (input == null || input.length() % 2 != 0) {
            throw new IllegalArgumentException("The input must not be null and shall have an even number of hexadecimal characters. Found: " + input);
        }
        byte[] output = new byte[input.length() / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)((Character.digit(input.charAt(i * 2), 16) << 4) + Character.digit(input.charAt(i * 2 + 1), 16));
        }
        return output;
    }

    public static byte[] bigIntegerToNullPaddedByteArray(BigInteger input, int outputSizeInBytes) {
        int i;
        int remainingBits;
        if (input == null) {
            throw new IllegalArgumentException("'input' must not be null.");
        }
        byte[] output = new byte[outputSizeInBytes];
        int numByteBlocks = input.bitLength() / 8;
        if (numByteBlocks < output.length) {
            remainingBits = input.bitLength() % 8;
        } else {
            remainingBits = 0;
            numByteBlocks = output.length;
        }
        for (i = 0; i < numByteBlocks; ++i) {
            output[output.length - 1 - i] = input.shiftRight(i * 8).byteValue();
        }
        if (remainingBits > 0) {
            output[output.length - 1 - i] = input.shiftRight(i * 8).byteValue();
        }
        return output;
    }

    public static byte[] longToUint48Bytes(long input) {
        byte[] output = new byte[]{(byte)(input >>> 40), (byte)(input >>> 32), (byte)(input >>> 24), (byte)(input >>> 16), (byte)(input >>> 8), (byte)input};
        return output;
    }

    public static byte[] reverseByteOrder(byte[] array) {
        int length = array.length;
        byte[] temp = new byte[length];
        int counter = length - 1;
        for (int i = 0; i < length; ++i) {
            temp[i] = array[counter--];
        }
        return temp;
    }
}

