/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.tlsattacker.attacks.actions.EarlyCcsAction;
import de.rub.nds.tlsattacker.attacks.config.EarlyCCSCommandConfig;
import de.rub.nds.tlsattacker.attacks.constants.EarlyCcsVulnerabilityType;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ActivateEncryptionAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EarlyCCSAttacker
extends Attacker<EarlyCCSCommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EarlyCCSAttacker(EarlyCCSCommandConfig config, Config baseConfig) {
        super(config, baseConfig);
    }

    @Override
    public void executeAttack() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Boolean isVulnerable() {
        EarlyCcsVulnerabilityType earlyCcsVulnerabilityType = this.getEarlyCcsVulnerabilityType();
        switch (earlyCcsVulnerabilityType) {
            case VULN_EXPLOITABLE: 
            case VULN_NOT_EXPLOITABLE: {
                return true;
            }
            case NOT_VULNERABLE: {
                return false;
            }
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }

    public boolean checkTargetVersion(TargetVersion targetVersion) {
        Config tlsConfig = this.getTlsConfig();
        tlsConfig.setFiltersKeepUserSettings(false);
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(tlsConfig);
        WorkflowTrace workflowTrace = factory.createTlsEntryWorkflowtrace(tlsConfig.getDefaultClientConnection());
        workflowTrace.addTlsAction(new SendAction(new ClientHelloMessage(tlsConfig)));
        LinkedList<ProtocolMessage> messageList = new LinkedList<ProtocolMessage>();
        messageList.add(new ServerHelloMessage(tlsConfig));
        messageList.add(new CertificateMessage(tlsConfig));
        messageList.add(new ServerHelloDoneMessage(tlsConfig));
        workflowTrace.addTlsAction(new ReceiveAction(messageList));
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(tlsConfig);
        workflowTrace.addTlsAction(new SendAction(changeCipherSpecMessage));
        byte[] emptyMasterSecret = new byte[]{};
        workflowTrace.addTlsAction(new ChangeMasterSecretAction(emptyMasterSecret));
        workflowTrace.addTlsAction(new ActivateEncryptionAction());
        workflowTrace.addTlsAction(new EarlyCcsAction(targetVersion == TargetVersion.OPENSSL_1_0_0));
        if (targetVersion != TargetVersion.OPENSSL_1_0_0) {
            workflowTrace.addTlsAction(new ChangeMasterSecretAction(emptyMasterSecret));
        }
        workflowTrace.addTlsAction(new SendAction(new FinishedMessage(tlsConfig)));
        messageList = new LinkedList();
        messageList.add(new ChangeCipherSpecMessage(tlsConfig));
        messageList.add(new FinishedMessage(tlsConfig));
        workflowTrace.addTlsAction(new ReceiveAction(messageList));
        State state = new State(tlsConfig, workflowTrace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
        workflowExecutor.executeWorkflow();
        if (WorkflowTraceUtil.didReceiveMessage(ProtocolMessageType.ALERT, workflowTrace)) {
            ConsoleLogger.CONSOLE.info("Not vulnerable (definitely), Alert message found");
            return false;
        }
        if (WorkflowTraceUtil.didReceiveMessage(HandshakeMessageType.FINISHED, workflowTrace)) {
            ConsoleLogger.CONSOLE.warn("Vulnerable (definitely), Finished message found");
            return true;
        }
        ConsoleLogger.CONSOLE.info("Not vulnerable (probably), No Finished message found, yet also no alert");
        return false;
    }

    public EarlyCcsVulnerabilityType getEarlyCcsVulnerabilityType() {
        if (this.checkTargetVersion(TargetVersion.OPENSSL_1_0_0)) {
            return EarlyCcsVulnerabilityType.VULN_NOT_EXPLOITABLE;
        }
        if (this.checkTargetVersion(TargetVersion.OPENSSL_1_0_1)) {
            return EarlyCcsVulnerabilityType.VULN_EXPLOITABLE;
        }
        return EarlyCcsVulnerabilityType.NOT_VULNERABLE;
    }

    public static enum TargetVersion {
        OPENSSL_1_0_0,
        OPENSSL_1_0_1;

    }
}

