/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.filter.Filter;
import net.fortuna.ical4j.filter.predicate.PeriodRule;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.component.VEvent;
import org.traccar.model.ExtendedModel;
import org.traccar.storage.QueryIgnore;
import org.traccar.storage.StorageName;

@StorageName(value="tc_calendars")
public class Calendar
extends ExtendedModel {
    private String name;
    private byte[] data;
    private net.fortuna.ical4j.model.Calendar calendar;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        this.calendar = builder.build(new ByteArrayInputStream(data));
        this.data = data;
    }

    @QueryIgnore
    @JsonIgnore
    public net.fortuna.ical4j.model.Calendar getCalendar() {
        return this.calendar;
    }

    private Collection<VEvent> findEvents(Date date) {
        if (this.calendar != null) {
            Filter filter = new Filter(new PeriodRule(new Period(new DateTime(date), Duration.ZERO)));
            return filter.filter(this.calendar.getComponents("VEVENT"));
        }
        return List.of();
    }

    public Collection<Period> findPeriods(Date date) {
        net.fortuna.ical4j.model.Date calendarDate = new net.fortuna.ical4j.model.Date(date);
        return this.findEvents(date).stream().flatMap(event -> event.getConsumedTime(calendarDate, calendarDate).stream()).collect(Collectors.toSet());
    }

    public boolean checkMoment(Date date) {
        return !this.findEvents(date).isEmpty();
    }
}

