/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdTypeMapBuilder {
    private boolean hadError;
    private final ErrorHandler eh;
    private final PatternFunction idTypeFunction = new IdTypeFunction();
    private final IdTypeMapImpl idTypeMap = new IdTypeMapImpl();
    private final Map elementProcessed = new HashMap();
    private final List possibleConflicts = new ArrayList();

    private void notePossibleConflict(NameClass nameClass, NameClass nameClass2, Locator locator) {
        this.possibleConflicts.add(new PossibleConflict(nameClass, nameClass2, locator));
    }

    private void error(String string, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), locator));
            }
            catch (SAXException sAXException) {
                throw new WrappedSAXException(sAXException);
            }
        }
    }

    private void error(String string, Name name, Name name2, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, NameFormatter.format(name), NameFormatter.format(name2)), locator));
            }
            catch (SAXException sAXException) {
                throw new WrappedSAXException(sAXException);
            }
        }
    }

    public IdTypeMapBuilder(ErrorHandler errorHandler, Pattern pattern) throws SAXException {
        this.eh = errorHandler;
        try {
            pattern.apply(new BuildFunction(null, null));
            block2: for (PossibleConflict possibleConflict : this.possibleConflicts) {
                if (possibleConflict.elementNameClass instanceof SimpleNameClass && possibleConflict.attributeNameClass instanceof SimpleNameClass) {
                    Object object;
                    Name name = ((SimpleNameClass)possibleConflict.elementNameClass).getName();
                    int n = this.idTypeMap.getIdType(name, (Name)(object = ((SimpleNameClass)possibleConflict.attributeNameClass).getName()));
                    if (n == 0) continue;
                    this.error("id_type_conflict", name, (Name)object, possibleConflict.locator);
                    continue;
                }
                for (Object object : this.idTypeMap.table.keySet()) {
                    if (!possibleConflict.elementNameClass.contains(((ScopedName)object).elementName) || !possibleConflict.attributeNameClass.contains(((ScopedName)object).attributeName)) continue;
                    this.error("id_type_conflict", ((ScopedName)object).elementName, ((ScopedName)object).attributeName, possibleConflict.locator);
                    continue block2;
                }
            }
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.cause;
        }
    }

    public IdTypeMap getIdTypeMap() {
        if (this.hadError) {
            return null;
        }
        return this.idTypeMap;
    }

    private static class IdTypeMapImpl
    implements IdTypeMap {
        private final Map table = new HashMap();

        private IdTypeMapImpl() {
        }

        @Override
        public int getIdType(Name name, Name name2) {
            Integer n = (Integer)this.table.get(new ScopedName(name, name2));
            if (n == null) {
                return 0;
            }
            return n;
        }

        private void add(Name name, Name name2, int n) {
            this.table.put(new ScopedName(name, name2), new Integer(n));
        }
    }

    private static class PossibleConflict {
        private final NameClass elementNameClass;
        private final NameClass attributeNameClass;
        private final Locator locator;

        private PossibleConflict(NameClass nameClass, NameClass nameClass2, Locator locator) {
            this.elementNameClass = nameClass;
            this.attributeNameClass = nameClass2;
            this.locator = locator;
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        private final SAXException cause;

        WrappedSAXException(SAXException sAXException) {
            this.cause = sAXException;
        }
    }

    private class IdTypeFunction
    extends AbstractPatternFunction {
        private IdTypeFunction() {
        }

        @Override
        public Object caseOther(Pattern pattern) {
            return new Integer(0);
        }

        @Override
        public Object caseData(DataPattern dataPattern) {
            return new Integer(dataPattern.getDatatype().getIdType());
        }

        @Override
        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            return new Integer(dataExceptPattern.getDatatype().getIdType());
        }

        @Override
        public Object caseValue(ValuePattern valuePattern) {
            return new Integer(valuePattern.getDatatype().getIdType());
        }
    }

    private class BuildFunction
    extends AbstractPatternFunction {
        private final NameClass elementNameClass;
        private final Locator locator;
        private final boolean attributeIsParent;

        BuildFunction(NameClass nameClass, Locator locator) {
            this.elementNameClass = nameClass;
            this.locator = locator;
            this.attributeIsParent = false;
        }

        BuildFunction(NameClass nameClass, Locator locator, boolean bl) {
            this.elementNameClass = nameClass;
            this.locator = locator;
            this.attributeIsParent = bl;
        }

        private BuildFunction down() {
            if (!this.attributeIsParent) {
                return this;
            }
            return new BuildFunction(this.elementNameClass, this.locator, false);
        }

        @Override
        public Object caseChoice(ChoicePattern choicePattern) {
            BuildFunction buildFunction = this.down();
            choicePattern.getOperand1().apply(buildFunction);
            choicePattern.getOperand2().apply(buildFunction);
            return null;
        }

        @Override
        public Object caseInterleave(InterleavePattern interleavePattern) {
            BuildFunction buildFunction = this.down();
            interleavePattern.getOperand1().apply(buildFunction);
            interleavePattern.getOperand2().apply(buildFunction);
            return null;
        }

        @Override
        public Object caseGroup(GroupPattern groupPattern) {
            BuildFunction buildFunction = this.down();
            groupPattern.getOperand1().apply(buildFunction);
            groupPattern.getOperand2().apply(buildFunction);
            return null;
        }

        @Override
        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getOperand().apply(this.down());
            return null;
        }

        @Override
        public Object caseElement(ElementPattern elementPattern) {
            if (IdTypeMapBuilder.this.elementProcessed.get(elementPattern) != null) {
                return null;
            }
            IdTypeMapBuilder.this.elementProcessed.put(elementPattern, elementPattern);
            elementPattern.getContent().apply(new BuildFunction(elementPattern.getNameClass(), elementPattern.getLocator()));
            return null;
        }

        @Override
        public Object caseAttribute(AttributePattern attributePattern) {
            int n = (Integer)attributePattern.getContent().apply(IdTypeMapBuilder.this.idTypeFunction);
            if (n != 0) {
                NameClass nameClass = attributePattern.getNameClass();
                if (!(nameClass instanceof SimpleNameClass)) {
                    IdTypeMapBuilder.this.error("id_attribute_name_class", attributePattern.getLocator());
                    return null;
                }
                this.elementNameClass.accept(new ElementNameClassVisitor(((SimpleNameClass)nameClass).getName(), this.locator, n));
            } else {
                IdTypeMapBuilder.this.notePossibleConflict(this.elementNameClass, attributePattern.getNameClass(), this.locator);
            }
            attributePattern.getContent().apply(new BuildFunction(null, attributePattern.getLocator(), true));
            return null;
        }

        private void datatype(Datatype datatype) {
            if (datatype.getIdType() != 0 && !this.attributeIsParent) {
                IdTypeMapBuilder.this.error("id_parent", this.locator);
            }
        }

        @Override
        public Object caseData(DataPattern dataPattern) {
            this.datatype(dataPattern.getDatatype());
            return null;
        }

        @Override
        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.datatype(dataExceptPattern.getDatatype());
            dataExceptPattern.getExcept().apply(this.down());
            return null;
        }

        @Override
        public Object caseValue(ValuePattern valuePattern) {
            this.datatype(valuePattern.getDatatype());
            return null;
        }

        @Override
        public Object caseList(ListPattern listPattern) {
            listPattern.getOperand().apply(this.down());
            return null;
        }

        @Override
        public Object caseOther(Pattern pattern) {
            return null;
        }
    }

    private static class ScopedName {
        private final Name elementName;
        private final Name attributeName;

        private ScopedName(Name name, Name name2) {
            this.elementName = name;
            this.attributeName = name2;
        }

        public int hashCode() {
            return this.elementName.hashCode() ^ this.attributeName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ScopedName)) {
                return false;
            }
            ScopedName scopedName = (ScopedName)object;
            return this.elementName.equals(scopedName.elementName) && this.attributeName.equals(scopedName.attributeName);
        }
    }

    private class ElementNameClassVisitor
    implements NameClassVisitor {
        private final Name attributeName;
        private final Locator locator;
        private final int idType;

        ElementNameClassVisitor(Name name, Locator locator, int n) {
            this.attributeName = name;
            this.locator = locator;
            this.idType = n;
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        @Override
        public void visitName(Name name) {
            int n = IdTypeMapBuilder.this.idTypeMap.getIdType(name, this.attributeName);
            if (n != 0 && n != this.idType) {
                IdTypeMapBuilder.this.error("id_type_conflict", name, this.attributeName, this.locator);
            }
            IdTypeMapBuilder.this.idTypeMap.add(name, this.attributeName, this.idType);
        }

        @Override
        public void visitNsName(String string) {
            this.visitOther();
        }

        @Override
        public void visitNsNameExcept(String string, NameClass nameClass) {
            this.visitOther();
        }

        @Override
        public void visitAnyName() {
            this.visitOther();
        }

        @Override
        public void visitAnyNameExcept(NameClass nameClass) {
            this.visitOther();
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }

        private void visitOther() {
            IdTypeMapBuilder.this.error("id_element_name_class", this.locator);
        }
    }
}

