/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class PermittedAddressesTableModel
extends AbstractMultipleOptionsTableModel<DomainMatcher> {
    private static final long serialVersionUID = -5411351965957264957L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("api.options.addr.table.header.enabled"), Constant.messages.getString("api.options.addr.table.header.regex"), Constant.messages.getString("api.options.addr.table.header.value")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<DomainMatcher> addresses = new ArrayList<DomainMatcher>(5);

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public int getRowCount() {
        return this.addresses.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((DomainMatcher)this.getElement(rowIndex)).isEnabled();
            }
            case 1: {
                return ((DomainMatcher)this.getElement(rowIndex)).isRegex();
            }
            case 2: {
                return ((DomainMatcher)this.getElement(rowIndex)).getValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Boolean) {
            this.addresses.get(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0 || c == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    public List<DomainMatcher> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<DomainMatcher> addrs) {
        this.addresses = new ArrayList<DomainMatcher>(addrs.size());
        for (DomainMatcher addr : addrs) {
            this.addresses.add(new DomainMatcher(addr));
        }
        this.fireTableDataChanged();
    }

    @Override
    public List<DomainMatcher> getElements() {
        return this.addresses;
    }
}

