/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ScanPolicy {
    private static final Logger logger = LogManager.getLogger(ScanPolicy.class);
    private String name;
    private PluginFactory pluginFactory = new PluginFactory();
    private Plugin.AlertThreshold defaultThreshold;
    private Plugin.AttackStrength defaultStrength;
    private ZapXmlConfiguration conf;

    public ScanPolicy() {
        this.conf = new ZapXmlConfiguration();
        this.name = this.conf.getString("policy", "");
        this.pluginFactory.loadAllPlugin(this.conf);
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy(ZapXmlConfiguration conf) throws ConfigurationException {
        this.conf = conf;
        this.name = conf.getString("policy", "");
        this.pluginFactory.loadAllPlugin(conf);
        this.setDefaultThreshold(this.getEnumFromConfig("scanner.level", Plugin.AlertThreshold.class, Plugin.AlertThreshold.MEDIUM));
        this.setDefaultStrength(this.getEnumFromConfig("scanner.strength", Plugin.AttackStrength.class, Plugin.AttackStrength.MEDIUM));
    }

    public ScanPolicy(FileConfiguration conf) throws ConfigurationException {
        this.pluginFactory.loadAllPlugin(conf);
        this.conf = new ZapXmlConfiguration();
        this.name = "";
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy clonePolicy() throws ConfigurationException {
        return new ScanPolicy((ZapXmlConfiguration)this.conf.clone());
    }

    public void cloneInto(ScanPolicy policy) {
        policy.pluginFactory.loadFrom(this.pluginFactory);
        policy.defaultStrength = this.getDefaultStrength();
        policy.defaultThreshold = this.getDefaultThreshold();
    }

    public String getName() {
        return this.name;
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public Plugin.AlertThreshold getDefaultThreshold() {
        return this.defaultThreshold;
    }

    public Plugin.AttackStrength getDefaultStrength() {
        return this.defaultStrength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultThreshold(Plugin.AlertThreshold defaultThreshold) {
        this.defaultThreshold = defaultThreshold;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAlertThreshold(defaultThreshold);
        }
    }

    public void setDefaultStrength(Plugin.AttackStrength defaultStrength) {
        this.defaultStrength = defaultStrength;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAttackStrength(defaultStrength);
        }
    }

    public void save() throws ConfigurationException {
        this.conf.save();
    }

    private <T extends Enum<T>> T getEnumFromConfig(String confKey, Class<T> enumType, T defaultValue) {
        String name = this.conf.getString(confKey, "");
        if (name.isEmpty()) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to convert " + name + " to enum of " + enumType + ", using default instead: " + defaultValue);
            return defaultValue;
        }
    }
}

