/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.ManageAddOnsDialog;

class AddOnDependencyChecker {
    private final AddOnCollection installedAddOns;
    private final AddOnCollection availableAddOns;

    public AddOnDependencyChecker(AddOnCollection installedAddOns, AddOnCollection availableAddOns) {
        this.installedAddOns = installedAddOns;
        this.availableAddOns = availableAddOns;
    }

    private static boolean contains(Collection<AddOn> addOns, AddOn addOn) {
        for (AddOn ao : addOns) {
            if (!addOn.isSameAddOn(ao)) continue;
            return true;
        }
        return false;
    }

    public AddOnChangesResult calculateInstallChanges(AddOn addOn) {
        HashSet<AddOn> addOns = new HashSet<AddOn>();
        addOns.add(addOn);
        return this.calculateInstallChanges(addOns);
    }

    public AddOnChangesResult calculateInstallChanges(Set<AddOn> selectedAddOns) {
        return this.calculateChanges(selectedAddOns, false);
    }

    public boolean confirmInstallChanges(Component parent, AddOnChangesResult changes) {
        return this.confirmChanges(parent, changes, false);
    }

    private boolean addDependencies(AddOn addOn, Set<AddOn> selectedAddOns, Set<AddOn> oldVersions, Set<AddOn> newVersions, Set<AddOn> installs) {
        AddOn.AddOnRunRequirements requirements = addOn.calculateInstallRequirements(this.availableAddOns.getAddOns());
        for (AddOn dep : requirements.getDependencies()) {
            if (selectedAddOns.contains(dep)) continue;
            AddOn installed = this.installedAddOns.getAddOn(dep.getId());
            if (installed == null) {
                if (AddOn.InstallationStatus.AVAILABLE != this.availableAddOns.getAddOn(dep.getId()).getInstallationStatus()) continue;
                installs.add(dep);
                continue;
            }
            if (!dep.isUpdateTo(installed) || AddOn.InstallationStatus.AVAILABLE != this.availableAddOns.getAddOn(dep.getId()).getInstallationStatus()) continue;
            oldVersions.add(installed);
            newVersions.add(dep);
        }
        return requirements.isNewerJavaVersionRequired();
    }

    private boolean confirmChanges(Component parent, AddOnChangesResult changesResult, boolean updating) {
        boolean confirmed;
        ExtensionsTableModel model;
        AddOnTableModel model2;
        String question;
        HashSet<AddOn> selectedAddOnsJavaIssue = new HashSet<AddOn>();
        for (AddOn addOn : changesResult.getSelectedAddOns()) {
            if (addOn.canRunInCurrentJavaVersion()) continue;
            selectedAddOnsJavaIssue.add(addOn);
        }
        HashSet<AddOn> installs = new HashSet<AddOn>(changesResult.getInstalls());
        HashSet<AddOn> updates = new HashSet<AddOn>(changesResult.getNewVersions());
        Set<AddOn> dependents = this.getDependents(updates, changesResult.getUninstalls());
        if (updating) {
            question = Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUpdate");
            updates.removeAll(changesResult.getSelectedAddOns());
        } else {
            question = Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithInstallation");
            installs.removeAll(changesResult.getSelectedAddOns());
        }
        if (changesResult.getUninstalls().isEmpty() && updates.isEmpty() && installs.isEmpty() && dependents.isEmpty() && changesResult.getOptionalAddOns().isEmpty() && changesResult.getSoftUnloadExtensions().isEmpty() && changesResult.getUnloadExtensions().isEmpty()) {
            if (selectedAddOnsJavaIssue.isEmpty()) {
                return true;
            }
            int size = changesResult.getSelectedAddOns().size();
            if (size == 1) {
                String baseMessage = Constant.messages.getString("cfu.confirmation.dialogue.message.selectedAddOnNewerJavaVersion", changesResult.getSelectedAddOns().iterator().next().getMinimumJavaVersion());
                return JOptionPane.showConfirmDialog(parent, baseMessage + question, "OWASP ZAP", 0) == 0;
            }
            String mainMessage = selectedAddOnsJavaIssue.size() == size ? Constant.messages.getString("cfu.confirmation.dialogue.message.addOnsNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someSelectedAddOnsNewerJavaVersion");
            JLabel label = new JLabel(Constant.messages.getString("cfu.confirmation.dialogue.message.warnAddOnsNotRunJavaVersion"), ManageAddOnsDialog.ICON_ADD_ON_ISSUES, 10);
            Object[] msgs = new Object[]{mainMessage, AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(selectedAddOnsJavaIssue, selectedAddOnsJavaIssue.size())), label, question};
            return JOptionPane.showConfirmDialog(parent, msgs, "OWASP ZAP", 0) == 0;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        panel.add(tabs);
        int issues = selectedAddOnsJavaIssue.size();
        if (!selectedAddOnsJavaIssue.isEmpty()) {
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.selectedAddOns"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(selectedAddOnsJavaIssue, selectedAddOnsJavaIssue.size())));
        }
        if (!changesResult.getUninstalls().isEmpty()) {
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.uninstallations"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(changesResult.getUninstalls(), false)));
        }
        if (!updates.isEmpty()) {
            model2 = new AddOnTableModel(updates);
            issues += model2.getMinimumJavaVersionIssues();
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.updates"), AddOnDependencyChecker.createScrollableTable(model2));
        }
        if (!installs.isEmpty()) {
            model2 = new AddOnTableModel(installs);
            issues += model2.getMinimumJavaVersionIssues();
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.installations"), AddOnDependencyChecker.createScrollableTable(model2));
        }
        if (!dependents.isEmpty()) {
            model2 = new AddOnTableModel(dependents);
            issues += model2.getMinimumJavaVersionIssues();
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.softUninstalls"), AddOnDependencyChecker.createScrollableTable(model2));
        }
        SelectableAddOnTableModel optionalAddOnsTableModel = null;
        if (!changesResult.getOptionalAddOns().isEmpty()) {
            optionalAddOnsTableModel = new SelectableAddOnTableModel(Constant.messages.getString("cfu.generic.table.header.selectInstall"), changesResult.getOptionalAddOns());
            issues += optionalAddOnsTableModel.getMinimumJavaVersionIssues();
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.optionalAddOns"), AddOnDependencyChecker.createScrollableTable(optionalAddOnsTableModel));
        }
        if (!changesResult.getUnloadExtensions().isEmpty()) {
            model = new ExtensionsTableModel(changesResult.getUnloadExtensions());
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionUnloads"), AddOnDependencyChecker.createScrollableTable(model));
        }
        if (!changesResult.getSoftUnloadExtensions().isEmpty()) {
            model = new ExtensionsTableModel(changesResult.getSoftUnloadExtensions());
            tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionSoftUnloads"), AddOnDependencyChecker.createScrollableTable(model));
        }
        ArrayList<Object> optionPaneContents = new ArrayList<Object>();
        if (!changesResult.getOptionalAddOns().isEmpty() && changesResult.getUninstalls().isEmpty() && updates.isEmpty() && installs.isEmpty() && dependents.isEmpty() && changesResult.getSoftUnloadExtensions().isEmpty() && changesResult.getUnloadExtensions().isEmpty()) {
            optionPaneContents.add(Constant.messages.getString("cfu.confirmation.dialogue.message.suggestedChanges"));
        } else if (!changesResult.getOptionalAddOns().isEmpty()) {
            optionPaneContents.add(Constant.messages.getString("cfu.confirmation.dialogue.message.requiredSuggestedChanges"));
        } else {
            optionPaneContents.add(Constant.messages.getString("cfu.confirmation.dialogue.message.requiredChanges"));
        }
        optionPaneContents.add(panel);
        if (issues != 0) {
            String message = selectedAddOnsJavaIssue.size() == issues ? (selectedAddOnsJavaIssue.size() == changesResult.getSelectedAddOns().size() ? Constant.messages.getString("cfu.confirmation.dialogue.message.selectedAddOnsNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someUnnamedSelectedAddOnsNewerJavaVersion")) : (issues == 1 ? Constant.messages.getString("cfu.confirmation.dialogue.message.addOnNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someAddOnsNewerJavaVersion"));
            JLabel label = new JLabel(Constant.messages.getString("cfu.confirmation.dialogue.message.warnUnknownNumberAddOnsNotRunJavaVersion"), ManageAddOnsDialog.ICON_ADD_ON_ISSUES, 10);
            optionPaneContents.add(message);
            optionPaneContents.add(label);
        }
        optionPaneContents.add(question);
        boolean bl = confirmed = JOptionPane.showConfirmDialog(parent, optionPaneContents.toArray(), "OWASP ZAP", 0) == 0;
        if (confirmed && optionalAddOnsTableModel != null) {
            changesResult.getInstalls().addAll(optionalAddOnsTableModel.getSelectedAddOns());
        }
        return confirmed;
    }

    private Set<AddOn> getDependents(Set<AddOn> updates, Set<AddOn> ignoreAddOns) {
        HashSet<AddOn> dependents = new HashSet<AddOn>();
        for (AddOn update : updates) {
            this.addDependents(dependents, update, ignoreAddOns);
        }
        return dependents;
    }

    private void addDependents(Set<AddOn> dependents, AddOn addOn, Set<AddOn> ignoreAddOns) {
        for (AddOn availableAddOn : this.installedAddOns.getInstalledAddOns()) {
            if (ignoreAddOns.contains(availableAddOn) || !availableAddOn.dependsOn(addOn) || !dependents.contains(availableAddOn)) continue;
            dependents.add(availableAddOn);
            this.addDependents(dependents, availableAddOn, ignoreAddOns);
        }
    }

    private static JScrollPane createScrollableTable(TableModel model) {
        JXTable table = new JXTable(model);
        table.setColumnControlVisible(true);
        table.setVisibleRowCount(Math.min(model.getRowCount() + 1, 5));
        table.packAll();
        return new JScrollPane(table);
    }

    public AddOnChangesResult calculateUpdateChanges(AddOn addOn) {
        HashSet<AddOn> addOns = new HashSet<AddOn>();
        addOns.add(addOn);
        return this.calculateUpdateChanges(addOns);
    }

    public AddOnChangesResult calculateUpdateChanges(Set<AddOn> addOns) {
        return this.calculateChanges(addOns, true);
    }

    public boolean confirmUpdateChanges(Component parent, AddOnChangesResult changes) {
        return this.confirmChanges(parent, changes, true);
    }

    private AddOnChangesResult calculateChanges(Set<AddOn> selectedAddOns, boolean updating) {
        AddOn addOn;
        HashSet<AddOn> oldVersions = new HashSet<AddOn>();
        HashSet<AddOn> uninstalls = new HashSet<AddOn>();
        HashSet<AddOn> newVersions = new HashSet<AddOn>();
        HashSet<AddOn> installs = new HashSet<AddOn>();
        if (updating) {
            for (AddOn addOn2 : selectedAddOns) {
                AddOn addOn3 = this.installedAddOns.getAddOn(addOn2.getId());
                oldVersions.add(addOn3);
            }
        }
        boolean newerJavaVersion = false;
        for (AddOn addOn4 : selectedAddOns) {
            newerJavaVersion |= this.addDependencies(addOn4, selectedAddOns, oldVersions, newVersions, installs);
        }
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOn addOn3 : this.installedAddOns.getAddOns()) {
            if (AddOnDependencyChecker.contains(selectedAddOns, addOn3) || AddOnDependencyChecker.contains(newVersions, addOn3)) continue;
            hashSet.add(addOn3);
        }
        HashSet<AddOn> hashSet2 = new HashSet<AddOn>();
        hashSet2.addAll(selectedAddOns);
        hashSet2.addAll(installs);
        hashSet2.addAll(newVersions);
        HashSet<AddOn> expectedInstalledAddOns = new HashSet<AddOn>(hashSet);
        expectedInstalledAddOns.addAll(hashSet2);
        hashSet2.addAll(oldVersions);
        for (AddOn addOn4 : hashSet) {
            if (!addOn4.dependsOn(hashSet2) || !addOn4.calculateInstallRequirements(expectedInstalledAddOns).hasDependencyIssue()) continue;
            uninstalls.add(addOn4);
        }
        Iterator it = uninstalls.iterator();
        while (it.hasNext()) {
            addOn = (AddOn)it.next();
            AddOn addOnUpdate = this.availableAddOns.getAddOn(addOn.getId());
            if (addOnUpdate == null || addOnUpdate.equals(addOn)) continue;
            it.remove();
            oldVersions.add(addOn);
            newVersions.add(addOnUpdate);
            newerJavaVersion |= this.addDependencies(addOnUpdate, selectedAddOns, oldVersions, newVersions, installs);
        }
        it = uninstalls.iterator();
        while (it.hasNext()) {
            addOn = (AddOn)it.next();
            if (!AddOnDependencyChecker.contains(installs, addOn) && !AddOnDependencyChecker.contains(newVersions, addOn) && (!addOn.calculateInstallRequirements(this.installedAddOns.getAddOns()).hasDependencyIssue() || this.containsAny(addOn.getIdsAddOnDependencies(), uninstalls))) continue;
            it.remove();
        }
        if (updating) {
            newVersions.addAll(selectedAddOns);
        } else {
            installs.addAll(selectedAddOns);
        }
        expectedInstalledAddOns = new HashSet(hashSet);
        expectedInstalledAddOns.removeAll(uninstalls);
        expectedInstalledAddOns.removeAll(oldVersions);
        expectedInstalledAddOns.addAll(installs);
        expectedInstalledAddOns.addAll(newVersions);
        HashSet<Extension> unloadExtensions = new HashSet<Extension>();
        HashSet<Extension> softUnloadExtensions = new HashSet<Extension>();
        HashSet<AddOn> optionalAddOns = new HashSet<AddOn>();
        for (AddOn addOn5 : expectedInstalledAddOns) {
            AddOn.ExtensionRunRequirements extReqs;
            AddOn.AddOnRunRequirements requirements;
            List<String> extensionsWithDeps = addOn5.getExtensionsWithDeps();
            for (Extension extension : addOn5.getLoadedExtensionsWithDeps()) {
                requirements = addOn5.calculateExtensionInstallRequirements(extension, expectedInstalledAddOns);
                extReqs = requirements.getExtensionRequirements().get(0);
                if (!extReqs.isRunnable()) {
                    unloadExtensions.add(extension);
                } else if (CollectionUtils.containsAny(extReqs.getDependencies(), oldVersions)) {
                    softUnloadExtensions.add(extension);
                }
                extensionsWithDeps.remove(extReqs.getClassname());
            }
            for (String classname : extensionsWithDeps) {
                requirements = addOn5.calculateExtensionInstallRequirements(classname, this.availableAddOns.getAddOns());
                extReqs = requirements.getExtensionRequirements().get(0);
                if (!extReqs.isRunnable()) continue;
                optionalAddOns.addAll(extReqs.getDependencies());
            }
        }
        optionalAddOns.removeAll(installs);
        optionalAddOns.removeAll(newVersions);
        optionalAddOns.removeAll(hashSet);
        return new AddOnChangesResult(selectedAddOns, oldVersions, uninstalls, newVersions, installs, newerJavaVersion, optionalAddOns, unloadExtensions, softUnloadExtensions);
    }

    public UninstallationResult calculateUninstallChanges(Set<AddOn> selectedAddOns) {
        ArrayList<AddOn> remainingAddOns = new ArrayList<AddOn>(this.installedAddOns.getAddOns());
        remainingAddOns.removeAll(selectedAddOns);
        HashSet<AddOn> uninstallations = new HashSet<AddOn>();
        ArrayList<AddOn> addOnsToCheck = new ArrayList<AddOn>(remainingAddOns);
        while (!addOnsToCheck.isEmpty()) {
            AddOn addOn = (AddOn)addOnsToCheck.remove(0);
            AddOn.AddOnRunRequirements requirements = addOn.calculateInstallRequirements(remainingAddOns);
            if (!requirements.hasDependencyIssue()) {
                addOnsToCheck.removeAll(requirements.getDependencies());
                continue;
            }
            if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOn.getInstallationStatus()) continue;
            uninstallations.add(addOn);
        }
        Iterator it = uninstallations.iterator();
        while (it.hasNext()) {
            AddOn addOn = (AddOn)it.next();
            if (!addOn.calculateInstallRequirements(this.installedAddOns.getAddOns()).hasDependencyIssue() || this.containsAny(addOn.getIdsAddOnDependencies(), uninstallations)) continue;
            it.remove();
        }
        remainingAddOns.removeAll(uninstallations);
        HashSet<Extension> extensions = new HashSet<Extension>();
        for (AddOn addOn : remainingAddOns) {
            if (!addOn.hasExtensionsWithDeps()) continue;
            for (Extension ext : addOn.getLoadedExtensions()) {
                AddOn.ExtensionRunRequirements extReqs;
                AddOn.AddOnRunRequirements requirements = addOn.calculateExtensionInstallRequirements(ext, remainingAddOns);
                if (requirements.getExtensionRequirements().isEmpty() || (extReqs = requirements.getExtensionRequirements().get(0)).isRunnable()) continue;
                extensions.add(ext);
            }
        }
        uninstallations.addAll(selectedAddOns);
        return new UninstallationResult(selectedAddOns, uninstallations, extensions);
    }

    private boolean containsAny(List<String> addOnIds, Collection<AddOn> addOns) {
        for (String id : addOnIds) {
            for (AddOn addOn : addOns) {
                if (!id.equals(addOn.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean confirmUninstallChanges(Component parent, UninstallationResult result, Set<AddOn> addOnsBeingDownloaded) {
        HashSet<AddOn> forcedUninstallations = new HashSet<AddOn>(result.getUninstallations());
        forcedUninstallations.removeAll(result.getSelectedAddOns());
        boolean dependencyDownloadFound = false;
        for (AddOn addOnDownloading : addOnsBeingDownloaded) {
            if (!this.containsAny(addOnDownloading.getIdsAddOnDependencies(), forcedUninstallations)) continue;
            dependencyDownloadFound = true;
            break;
        }
        if (!dependencyDownloadFound) {
            for (AddOn addOnDownloading : addOnsBeingDownloaded) {
                if (!this.containsAny(addOnDownloading.getIdsAddOnDependencies(), result.getSelectedAddOns())) continue;
                dependencyDownloadFound = true;
                break;
            }
        }
        if (dependencyDownloadFound && JOptionPane.showConfirmDialog(parent, new Object[]{Constant.messages.getString("cfu.confirmation.dialogue.message.uninstallsRequiredByAddOnsDownloading"), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) != 0) {
            return false;
        }
        if (forcedUninstallations.isEmpty() && result.getExtensions().isEmpty()) {
            return JOptionPane.showConfirmDialog(parent, Constant.messages.getString("cfu.uninstall.confirm"), "OWASP ZAP", 0) == 0;
        }
        if (result.getExtensions().isEmpty()) {
            return JOptionPane.showConfirmDialog(parent, new Object[]{Constant.messages.getString("cfu.uninstall.dependentAddOns.confirm"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(forcedUninstallations, false)), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) == 0;
        }
        if (forcedUninstallations.isEmpty()) {
            return JOptionPane.showConfirmDialog(parent, new Object[]{Constant.messages.getString("cfu.uninstall.dependentExtensions.confirm"), AddOnDependencyChecker.createScrollableTable(new ExtensionsTableModel(result.getExtensions())), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) == 0;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        panel.add(tabs);
        tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.uninstallations"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(forcedUninstallations, false)));
        tabs.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionUnloads"), AddOnDependencyChecker.createScrollableTable(new ExtensionsTableModel(result.getExtensions())));
        ArrayList<Object> optionPaneContents = new ArrayList<Object>();
        optionPaneContents.add(Constant.messages.getString("cfu.uninstall.dependentAddonsAndExtensions.confirm"));
        optionPaneContents.add(panel);
        optionPaneContents.add(Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation"));
        return JOptionPane.showConfirmDialog(parent, optionPaneContents.toArray(), "OWASP ZAP", 0) == 0;
    }

    private static class ExtensionsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5446781970087315105L;
        private static final String[] COLUMNS = new String[]{Constant.messages.getString("cfu.generic.table.header.extension")};
        private final List<Extension> extensions;

        public ExtensionsTableModel(Collection<Extension> extensions) {
            this.extensions = new ArrayList<Extension>(extensions);
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public int getRowCount() {
            return this.extensions.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Extension extension = this.extensions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return extension.getUIName();
                }
            }
            return "";
        }
    }

    private static class SelectableAddOnTableModel
    extends AddOnTableModel {
        private static final long serialVersionUID = 2337381848530495407L;
        private final String selectionRowName;
        private final Boolean[] selections;

        public SelectableAddOnTableModel(String selectionRowName, Collection<AddOn> addOns) {
            super(addOns, true);
            this.selectionRowName = selectionRowName;
            this.selections = new Boolean[addOns.size()];
            for (int i = 0; i < this.selections.length; ++i) {
                this.selections[i] = Boolean.FALSE;
            }
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return this.selectionRowName;
            }
            return super.getColumnName(column - 1);
        }

        @Override
        public int getColumnCount() {
            return super.getColumnCount() + 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex - 1);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.selections[rowIndex];
            }
            return super.getValueAt(rowIndex, columnIndex - 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                this.selections[rowIndex] = (Boolean)aValue;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public List<AddOn> getSelectedAddOns() {
            ArrayList<AddOn> selectedAddOns = new ArrayList<AddOn>(this.selections.length);
            for (int i = 0; i < this.selections.length; ++i) {
                if (!this.selections[i].booleanValue()) continue;
                selectedAddOns.add(this.getAddOn(i));
            }
            return selectedAddOns;
        }
    }

    private static class AddOnTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5446781970087315105L;
        private static final String[] COLUMNS = new String[]{Constant.messages.getString("cfu.generic.table.header.addOn"), Constant.messages.getString("cfu.generic.table.header.version"), Constant.messages.getString("cfu.generic.table.header.minimumJavaVersion")};
        private final List<AddOn> addOns;
        private final int columnCount;
        private final int issues;

        public AddOnTableModel(Collection<AddOn> addOns) {
            this(addOns, true);
        }

        public AddOnTableModel(Collection<AddOn> addOns, boolean checkMinimumJavaVersion) {
            this.addOns = new ArrayList<AddOn>(addOns);
            int count = 0;
            if (checkMinimumJavaVersion) {
                for (AddOn addOn : addOns) {
                    if (addOn.canRunInCurrentJavaVersion()) continue;
                    ++count;
                }
            }
            this.issues = count;
            this.columnCount = this.issues != 0 ? COLUMNS.length : COLUMNS.length - 1;
        }

        public AddOnTableModel(Collection<AddOn> addOns, int numberOfIssues) {
            this.addOns = new ArrayList<AddOn>(addOns);
            this.issues = numberOfIssues;
            this.columnCount = numberOfIssues != 0 ? COLUMNS.length : COLUMNS.length - 1;
        }

        public int getMinimumJavaVersionIssues() {
            return this.issues;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public int getRowCount() {
            return this.addOns.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AddOn addOn = this.getAddOn(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return addOn.getName();
                }
                case 1: {
                    return addOn.getVersion();
                }
                case 2: {
                    return addOn.getMinimumJavaVersion();
                }
            }
            return "";
        }

        protected AddOn getAddOn(int rowIndex) {
            return this.addOns.get(rowIndex);
        }
    }

    public static class UninstallationResult {
        private final Set<AddOn> selectedAddOns;
        private final Set<AddOn> uninstallations;
        private final Set<Extension> extensions;

        private UninstallationResult(Set<AddOn> selectedAddOns, Set<AddOn> uninstallations, Set<Extension> extensions) {
            this.selectedAddOns = selectedAddOns;
            this.uninstallations = uninstallations;
            this.extensions = extensions;
        }

        public Set<AddOn> getSelectedAddOns() {
            return this.selectedAddOns;
        }

        public Set<AddOn> getUninstallations() {
            return this.uninstallations;
        }

        public Set<Extension> getExtensions() {
            return this.extensions;
        }
    }

    public static class AddOnChangesResult {
        private final Set<AddOn> selectedAddOns;
        private final Set<AddOn> oldVersions;
        private final Set<AddOn> uninstalls;
        private final Set<AddOn> newVersions;
        private final Set<AddOn> installs;
        private final boolean newerJavaVersion;
        private final Set<AddOn> optionalAddOns;
        private final Set<Extension> unloadExtensions;
        private final Set<Extension> softUnloadExtensions;

        private AddOnChangesResult(Set<AddOn> selectedAddOns, Set<AddOn> oldVersions, Set<AddOn> uninstalls, Set<AddOn> newVersions, Set<AddOn> installs, boolean newerJavaVersion, Set<AddOn> optionalAddOns, Set<Extension> unloadExtensions, Set<Extension> softUnloadExtensions) {
            this.selectedAddOns = selectedAddOns;
            this.oldVersions = oldVersions;
            this.uninstalls = uninstalls;
            this.newVersions = newVersions;
            this.installs = installs;
            this.newerJavaVersion = newerJavaVersion;
            this.optionalAddOns = optionalAddOns;
            this.unloadExtensions = unloadExtensions;
            this.softUnloadExtensions = softUnloadExtensions;
        }

        public Set<AddOn> getSelectedAddOns() {
            return this.selectedAddOns;
        }

        public Set<AddOn> getOldVersions() {
            return this.oldVersions;
        }

        public Set<AddOn> getUninstalls() {
            return this.uninstalls;
        }

        public Set<AddOn> getNewVersions() {
            return this.newVersions;
        }

        public Set<AddOn> getInstalls() {
            return this.installs;
        }

        public boolean isNewerJavaVersionRequired() {
            return this.newerJavaVersion;
        }

        public Set<AddOn> getOptionalAddOns() {
            return this.optionalAddOns;
        }

        public Set<Extension> getUnloadExtensions() {
            return this.unloadExtensions;
        }

        public Set<Extension> getSoftUnloadExtensions() {
            return this.softUnloadExtensions;
        }

        public void addResults(AddOnChangesResult result) {
            this.selectedAddOns.addAll(result.getSelectedAddOns());
            this.oldVersions.addAll(result.oldVersions);
            this.uninstalls.addAll(result.getUninstalls());
            this.newVersions.addAll(result.getNewVersions());
            this.installs.addAll(result.getInstalls());
            this.optionalAddOns.addAll(result.getOptionalAddOns());
            this.unloadExtensions.addAll(result.getUnloadExtensions());
            this.softUnloadExtensions.addAll(result.getSoftUnloadExtensions());
        }
    }
}

