/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.globalexcludeurl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParamToken;

public class GlobalExcludeURLParam
extends AbstractParam {
    private static final Logger logger = LogManager.getLogger(GlobalExcludeURLParam.class);
    private static final String GLOBAL_EXCLUDE_URL_BASE_KEY = "globalexcludeurl";
    private static final String ALL_TOKENS_KEY = "globalexcludeurl.url_list.url";
    private static final String TOKEN_REGEX_KEY = "regex";
    private static final String TOKEN_DESCRIPTION_KEY = "description";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "globalexcludeurl.confirmRemoveToken";
    private static ArrayList<GlobalExcludeURLParamToken> defaultList = new ArrayList();
    private List<GlobalExcludeURLParamToken> tokens = null;
    private List<String> enabledTokensNames = null;
    private boolean confirmRemoveToken = true;

    private void setDefaultList() {
        String[][] defaultListArray;
        for (String[] row : defaultListArray = new String[][]{{"^.*\\.(?:gif|jpe?g|png|ico|icns|bmp)$", "Extension - Image (ends with .extension)", "false"}, {"^.*\\.(?:mp[34]|mpe?g|m4[ap]|aac|avi|mov|wmv|og[gav])$", "Extension - Audio/Video (ends with .extension)", "false"}, {"^.*\\.(?:pdf|docx?|xlsx?|pptx?)$", "Extension - PDF & Office (ends with .extension)", "false"}, {"^.*\\.(?:css|js)$", "Extension - Stylesheet, JavaScript (ends with .extension)", "false"}, {"^.*\\.(?:sw[fa]|flv)$", "Extension - Flash & related (ends with .extension)", "false"}, {"^[^\\?]*\\.(?:gif|jpe?g|png|ico|icns|bmp)\\?.*$", "ExtParam - Image (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(?:mp[34]|mpe?g|m4[ap]|aac|avi|mov|wmv|og[gav])\\?.*$", "ExtParam - Audio/Video (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(?:pdf|docx?|xlsx?|pptx?)\\?.*$", "ExtParam - PDF & Office (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(?:css|js)\\?.*$", "ExtParam - Stylesheet, JavaScript (extension plus ?params=values)", "false"}, {"^[^\\?]*\\.(?:sw[fa]|flv)\\?.*$", "ExtParam - Flash & related (extension plus ?params=values)", "false"}, {"^[^\\?]*/(?:WebResource|ScriptResource)\\.axd\\?d=.*$", "ExtParam - .NET adx resources (SR/WR.adx?d=)", "false"}, {"^https?://api\\.bing\\.com/qsml\\.aspx?query=.*$", "Site - Bing API queries", "false"}, {"^https?://(?:safebrowsing-cache|sb-ssl|sb|safebrowsing).*\\.(?:google|googleapis)\\.com/.*$", "Site - Google malware detector updates", "false"}, {"^https?://(?:[^/])*\\.?lastpass\\.com", "Site - Lastpass manager", "false"}, {"^https?://(?:.*addons|aus[0-9])\\.mozilla\\.(?:org|net|com)/.*$", "Site - Firefox browser updates", "false"}, {"^https?://(?:[^/])*\\.?(?:getfoxyproxy\\.org|getfirebug\\.com|noscript\\.net)", "Site - Firefox extensions phoning home", "false"}, {"^https?://(?:.*update\\.microsoft|.*\\.windowsupdate)\\.com/.*$", "Site - Microsoft Windows updates", "false"}, {"^https?://clients2\\.google\\.com/service/update2/crx.*$", "Site - Google Chrome extension updates", "false"}, {"^https?://detectportal\\.firefox\\.com.*$", "Site - Firefox captive portal detection", "false"}, {"^https?://www\\.google-analytics\\.com.*$", "Site - Google Analytics", "false"}, {"^https?://ciscobinary\\.openh264\\.org.*$", "Site - Firefox h264 codec download", "false"}, {"^https?://fonts.*$", "Site - Fonts CDNs such as fonts.gstatic.com, etc.", "false"}, {"^https?://.*\\.cdn\\.mozilla\\.(?:com|org|net)/.*$", "Site - Mozilla CDN (requests such as getpocket)", "false"}, {"^https?://.*\\.telemetry\\.mozilla\\.(?:com|org|net)/.*$", "Site - Firefox browser telemetry", "false"}, {"^https?://.*\\.adblockplus\\.org.*$", "Site - Adblockplus updates and notifications", "false"}, {"^https?://.*\\.services\\.mozilla\\.com.*$", "Site - Firefox services", "false"}, {"^https?://.*\\.gvt1\\.com.*$", "Site - Google updates", "false"}}) {
            boolean b = row[2].equalsIgnoreCase("true");
            defaultList.add(new GlobalExcludeURLParamToken(row[0], row[1], b));
        }
    }

    public GlobalExcludeURLParam() {
        this.setDefaultList();
    }

    @Override
    protected void parse() {
        try {
            List<HierarchicalConfiguration> fields = ((HierarchicalConfiguration)((Object)this.getConfig())).configurationsAt(ALL_TOKENS_KEY);
            this.tokens = new ArrayList<GlobalExcludeURLParamToken>(fields.size());
            this.enabledTokensNames = new ArrayList<String>(fields.size());
            ArrayList<String> tempTokensNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String regex = sub.getString(TOKEN_REGEX_KEY, "");
                if ("".equals(regex) || tempTokensNames.contains(regex)) continue;
                boolean enabled = sub.getBoolean(TOKEN_ENABLED_KEY, true);
                String desc = sub.getString(TOKEN_DESCRIPTION_KEY, "");
                this.tokens.add(new GlobalExcludeURLParamToken(regex, desc, enabled));
                tempTokensNames.add(regex);
                if (!enabled) continue;
                this.enabledTokensNames.add(regex);
            }
        }
        catch (ConversionException e) {
            logger.error("Error while loading Global Exclude URL tokens: " + e.getMessage(), (Throwable)e);
            this.tokens = new ArrayList<GlobalExcludeURLParamToken>(defaultList.size());
            this.enabledTokensNames = new ArrayList<String>(defaultList.size());
        }
        if (this.tokens.size() == 0) {
            for (GlobalExcludeURLParamToken geu : defaultList) {
                this.tokens.add(new GlobalExcludeURLParamToken(geu));
            }
        }
        this.confirmRemoveToken = this.getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
    }

    public List<GlobalExcludeURLParamToken> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<GlobalExcludeURLParamToken> tokens) {
        this.tokens = new ArrayList<GlobalExcludeURLParamToken>(tokens);
        ((HierarchicalConfiguration)((Object)this.getConfig())).clearTree(ALL_TOKENS_KEY);
        ArrayList<String> enabledTokens = new ArrayList<String>(tokens.size());
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "globalexcludeurl.url_list.url(" + i + ").";
            GlobalExcludeURLParamToken token = tokens.get(i);
            this.getConfig().setProperty(elementBaseKey + TOKEN_REGEX_KEY, token.getRegex());
            this.getConfig().setProperty(elementBaseKey + TOKEN_DESCRIPTION_KEY, token.getDescription());
            this.getConfig().setProperty(elementBaseKey + TOKEN_ENABLED_KEY, token.isEnabled());
            if (!token.isEnabled()) continue;
            enabledTokens.add(token.getRegex());
        }
        enabledTokens.trimToSize();
        this.enabledTokensNames = enabledTokens;
        Model.getSingleton().getSession().forceGlobalExcludeURLRefresh();
    }

    public void addToken(String regex) {
        this.tokens.add(new GlobalExcludeURLParamToken(regex));
        this.enabledTokensNames.add(regex);
    }

    public void removeToken(String regex) {
        this.tokens.remove(new GlobalExcludeURLParamToken(regex));
        this.enabledTokensNames.remove(regex);
    }

    public List<String> getTokensNames() {
        return this.enabledTokensNames;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveToken() {
        return this.confirmRemoveToken;
    }

    @ZapApiIgnore
    public void setConfirmRemoveToken(boolean confirmRemove) {
        this.confirmRemoveToken = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, this.confirmRemoveToken);
    }
}

