/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public abstract class PopupMenuItemHistoryReferenceContainer
extends PopupMenuItemHttpMessageContainer {
    private static final long serialVersionUID = -7860130362424758504L;

    public PopupMenuItemHistoryReferenceContainer(String label) {
        this(label, false);
    }

    public PopupMenuItemHistoryReferenceContainer(String label, boolean multiSelect) {
        super(label, multiSelect);
    }

    @Override
    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHistoryReferencesContainer || httpMessageContainer instanceof SingleHistoryReferenceContainer;
    }

    @Override
    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer messageContainer) {
        return this.isButtonEnabledForSelectedHistoryReferences(this.getSelectedHistoryReferences(messageContainer));
    }

    @Override
    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer messageContainer) {
        Session session = Model.getSingleton().getSession();
        for (HistoryReference historyReference : this.getSelectedHistoryReferences(messageContainer)) {
            if (historyReference == null || session.isInScope(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected List<HistoryReference> getSelectedHistoryReferences(HttpMessageContainer httpMessageContainer) {
        SingleHistoryReferenceContainer singleContainer;
        if (httpMessageContainer instanceof SelectableHistoryReferencesContainer) {
            return ((SelectableHistoryReferencesContainer)httpMessageContainer).getSelectedHistoryReferences();
        }
        if (httpMessageContainer instanceof SingleHistoryReferenceContainer && !(singleContainer = (SingleHistoryReferenceContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HistoryReference> selectedHistoryReferences = new ArrayList<HistoryReference>(1);
            selectedHistoryReferences.add(singleContainer.getHistoryReference());
            return selectedHistoryReferences;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedHistoryReferences(List<HistoryReference> historyReferences) {
        for (HistoryReference historyReference : historyReferences) {
            if (historyReference == null || this.isButtonEnabledForHistoryReference(historyReference)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        return historyReference.getHistoryType() != 0;
    }

    @Override
    protected final void performActions(HttpMessageContainer httpMessageContainer) {
        this.performHistoryReferenceActions(this.getSelectedHistoryReferences(httpMessageContainer));
    }

    @Override
    protected final void performActions(List<HttpMessage> httpMessages) {
    }

    @Override
    protected final void performAction(HttpMessage httpMessage) {
    }

    protected void performHistoryReferenceActions(List<HistoryReference> historyReferences) {
        for (HistoryReference historyReference : historyReferences) {
            if (historyReference == null) continue;
            this.performAction(historyReference);
        }
    }

    protected abstract void performAction(HistoryReference var1);
}

