/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBeanDeclaration
implements BeanDeclaration {
    public static final String RESERVED_PREFIX = "config-";
    public static final String ATTR_PREFIX = "[@config-";
    public static final String ATTR_BEAN_CLASS = "[@config-class]";
    public static final String ATTR_BEAN_FACTORY = "[@config-factory]";
    public static final String ATTR_FACTORY_PARAM = "[@config-factoryParam]";
    private final SubnodeConfiguration configuration;
    private final ConfigurationNode node;

    public XMLBeanDeclaration(HierarchicalConfiguration config, String key) {
        this(config, key, false);
    }

    public XMLBeanDeclaration(HierarchicalConfiguration config, String key, boolean optional) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        SubnodeConfiguration tmpconfiguration = null;
        ConfigurationNode tmpnode = null;
        try {
            tmpconfiguration = config.configurationAt(key);
            tmpnode = tmpconfiguration.getRootNode();
        }
        catch (IllegalArgumentException iex) {
            if (!optional || config.getMaxIndex(key) > 0) {
                throw iex;
            }
            tmpconfiguration = config.configurationAt(null);
            tmpnode = new DefaultConfigurationNode();
        }
        this.node = tmpnode;
        this.configuration = tmpconfiguration;
        this.initSubnodeConfiguration(this.getConfiguration());
    }

    public XMLBeanDeclaration(HierarchicalConfiguration config) {
        this(config, (String)null);
    }

    public XMLBeanDeclaration(SubnodeConfiguration config, ConfigurationNode node) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        this.node = node;
        this.configuration = config;
        this.initSubnodeConfiguration(config);
    }

    public SubnodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }

    @Override
    public String getBeanFactoryName() {
        return this.getConfiguration().getString(ATTR_BEAN_FACTORY);
    }

    @Override
    public Object getBeanFactoryParameter() {
        return this.getConfiguration().getProperty(ATTR_FACTORY_PARAM);
    }

    @Override
    public String getBeanClassName() {
        return this.getConfiguration().getString(ATTR_BEAN_CLASS);
    }

    @Override
    public Map<String, Object> getBeanProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (ConfigurationNode attr : this.getNode().getAttributes()) {
            if (this.isReservedNode(attr)) continue;
            props.put(attr.getName(), this.interpolate(attr.getValue()));
        }
        return props;
    }

    @Override
    public Map<String, Object> getNestedBeanDeclarations() {
        HashMap<String, Object> nested = new HashMap<String, Object>();
        for (ConfigurationNode child : this.getNode().getChildren()) {
            if (this.isReservedNode(child)) continue;
            if (nested.containsKey(child.getName())) {
                List<BeanDeclaration> list;
                Object obj = nested.get(child.getName());
                if (obj instanceof List) {
                    List tmpList = (List)obj;
                    list = tmpList;
                } else {
                    list = new ArrayList();
                    list.add((BeanDeclaration)obj);
                    nested.put(child.getName(), list);
                }
                list.add(this.createBeanDeclaration(child));
                continue;
            }
            nested.put(child.getName(), this.createBeanDeclaration(child));
        }
        return nested;
    }

    protected Object interpolate(Object value) {
        return PropertyConverter.interpolate(value, this.getConfiguration().getParent());
    }

    protected boolean isReservedNode(ConfigurationNode nd) {
        return nd.isAttribute() && (nd.getName() == null || nd.getName().startsWith(RESERVED_PREFIX));
    }

    protected BeanDeclaration createBeanDeclaration(ConfigurationNode node) {
        List<HierarchicalConfiguration> list = this.getConfiguration().configurationsAt(node.getName());
        if (list.size() == 1) {
            return new XMLBeanDeclaration((SubnodeConfiguration)list.get(0), node);
        }
        for (SubnodeConfiguration subnodeConfiguration : list) {
            if (!subnodeConfiguration.getRootNode().equals(node)) continue;
            return new XMLBeanDeclaration(subnodeConfiguration, node);
        }
        throw new ConfigurationRuntimeException("Unable to match node for " + node.getName());
    }

    private void initSubnodeConfiguration(SubnodeConfiguration conf) {
        conf.setThrowExceptionOnMissing(false);
        conf.setExpressionEngine(null);
    }
}

