/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.isomorphism;

import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;

public class VertexDegreeEquivalenceComparator<V, E>
implements EquivalenceComparator<V, Graph<V, E>> {
    @Override
    public boolean equivalenceCompare(V vertex1, V vertex2, Graph<V, E> context1, Graph<V, E> context2) {
        InOutDegrees inOut1 = this.getInOutDegrees(context1, vertex1);
        InOutDegrees inOut2 = this.getInOutDegrees(context2, vertex2);
        boolean result = inOut1.equals(inOut2);
        return result;
    }

    @Override
    public int equivalenceHashcode(V vertex, Graph<V, E> context) {
        InOutDegrees inOut = this.getInOutDegrees(context, vertex);
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(inOut.inDegree));
        sb.append("-");
        sb.append(String.valueOf(inOut.outDegree));
        return sb.toString().hashCode();
    }

    protected InOutDegrees getInOutDegrees(Graph<V, E> aContextGraph, V vertex) {
        int inVertexDegree = 0;
        int outVertexDegree = 0;
        if (aContextGraph instanceof UndirectedGraph) {
            UndirectedGraph undirectedGraph = (UndirectedGraph)aContextGraph;
            outVertexDegree = inVertexDegree = undirectedGraph.degreeOf(vertex);
        } else if (aContextGraph instanceof DirectedGraph) {
            DirectedGraph directedGraph = (DirectedGraph)aContextGraph;
            inVertexDegree = directedGraph.inDegreeOf(vertex);
            outVertexDegree = directedGraph.outDegreeOf(vertex);
        } else {
            throw new RuntimeException("contextGraph is of unsupported type . It must be one of these two : UndirectedGraph or DirectedGraph");
        }
        return new InOutDegrees(inVertexDegree, outVertexDegree);
    }

    protected class InOutDegrees {
        public int inDegree;
        public int outDegree;

        public InOutDegrees(int aInDegree, int aOutDegree) {
            this.inDegree = aInDegree;
            this.outDegree = aOutDegree;
        }

        public boolean equals(Object obj) {
            InOutDegrees other = (InOutDegrees)obj;
            return this.inDegree == other.inDegree && this.outDegree == other.outDegree;
        }
    }
}

