'\"
'\" Generated from file 'nns_protocol\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "nameserv::protocol" n 0\&.1 tcllib "Name service facility"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
nameserv::protocol \- Name service facility, client/server protocol
.SH SYNOPSIS
\fBBind\fR \fIname\fR \fIdata\fR
.sp
\fBRelease\fR
.sp
\fBSearch\fR \fIpattern\fR
.sp
\fBProtocolVersion\fR
.sp
\fBProtocolFeatures\fR
.sp
\fBSearch/Continuous/Start\fR \fItag\fR \fIpattern\fR
.sp
\fBSearch/Continuous/Stop\fR \fItag\fR
.sp
\fBSearch/Continuous/Change\fR \fItag\fR \fBadd\fR|\fBremove\fR \fIresponse\fR
.sp
.BE
.SH DESCRIPTION
The packages \fBnameserv::server\fR, \fBnameserv\fR, and
\fBnameserv::common\fR provide a simple unprotected name service
facility for use in small trusted environments\&.
.PP
Please read \fIName service facility, introduction\fR first\&.
.PP
This document contains the specification of the network protocol which
is used by client and server to talk to each other, enabling
implementations of the same protocol in other languages\&.
.SH "NANO NAME SERVICE PROTOCOL VERSION 1"
This protocol defines the basic set of messages to be supported by a
name service, also called the \fICore\fR feature\&.
.SS "BASIC LAYER"
The basic communication between client and server is done using the
remote-execution protocol specified by the Tcl package \fBcomm\fR\&.
The relevant document specifying its on-the-wire protocol can be found
in \fIcomm_wire\fR\&.
.PP
All the scripts exchanged via this protocol are single commands in
list form and thus can be interpreted as plain messages instead of as
Tcl commands\&. The commands/messages specified in the next section are
the only commands understood by the server-side\&. Command and variable
substitutions are not allowed within the messages, i\&.e\&. arguments have
to be literal values\&.
.PP
The protocol is synchronous\&. I\&.e\&. for each message sent a response is
expected, and has to be generated\&. All messages are sent by the client\&.
The server does not sent messages, only responses to messages\&.
.SS "MESSAGE LAYER"
.TP
\fBBind\fR \fIname\fR \fIdata\fR
The client sends this message when it registers itself at the service
with a \fIname\fR and some associated \fIdata\fR\&. The server has to
send an error response if the \fIname\fR is already in use\&. Otherwise
the response has to be an empty string\&.
.sp
The server has to accept multiple names for the same client\&.
.TP
\fBRelease\fR
The client sends this message to unregister all names it is known
under at the service\&. The response has to be an empty string, always\&.
.TP
\fBSearch\fR \fIpattern\fR
The client sends this message to search the service for names matching
the glob-\fIpattern\fR\&. The response has to be a dictionary containing
the matching names as keys, and mapping them to the data associated
with it at \fBBind\fR-time\&.
.TP
\fBProtocolVersion\fR
The client sends this message to query the service for the highest
version of the name service protocol it supports\&. The response has to
be a positive integer number\&.
.sp
Servers supporting only \fINano Name Service Protocol Version 1\fR
have to return \fB1\fR\&.
.TP
\fBProtocolFeatures\fR
The client sends this message to query the service for the features of
the name service protocol it supports\&. The response has to be a
list containing feature names\&.
.sp
Servers supporting only \fINano Name Service Protocol Version 1\fR
have to return \fB{Core}\fR\&.
.PP
.SH "NANO NAME SERVICE PROTOCOL EXTENSION: CONTINUOUS SEARCH"
This protocol defines an extended set of messages to be supported by a
name service, also called the \fISearch/Continuous\fR feature\&. This
feature defines additional messages between client and server, and is
otherwise identical to version 1 of the protocol\&. See the last section
for the details of our foundation\&.
.PP
A service supporting this feature has to put the feature name
\fBSearch/Continuous\fR into the list of features returned by the
message \fIProtocolFeatures\fR\&.
.PP
For this extension the protocol is asynchronous\&. No direct response is
expected for any of the messages in the extension\&. Furthermore the
server will start sending messages on its own, instead of only
responses to messages, and the client has to be able to handle these
notifications\&.
.TP
\fBSearch/Continuous/Start\fR \fItag\fR \fIpattern\fR
The client sends this message to start searching the service for names
matching the glob-\fIpattern\fR\&.
In contrast to the regular \fISearch\fR request this one asks the
server to continuously monitor the database for the addition and
removal of matching entries and to notify the client of all such
changes\&. The particular search is identified by the \fItag\fR\&.
.sp
No direct response is expected, rather the clients expect to be
notified of changes via explicit \fISearch/Continuous/Result\fR
messages generated by the service\&.
.sp
It is further expected that the \fItag\fR information is passed
unchanged to the \fISearch/Continuous/Result\fR messages\&. This
tagging of the results enables clients to start multiple searches and
distinguish between the different results\&.
.TP
\fBSearch/Continuous/Stop\fR \fItag\fR
The client sends this message to stop the continuous search identified
by the \fItag\fR\&.
.TP
\fBSearch/Continuous/Change\fR \fItag\fR \fBadd\fR|\fBremove\fR \fIresponse\fR
This message is sent by the service to clients with active continuous
searches to transfer found changes\&. The first such message for a new
continuous search has to contains the current set of matching entries\&.
.sp
To ensure this a service has to generate an \fBadd\fR-message with
an empty \fIresponse\fR if there were no matching entries at the time\&.
.sp
The \fIresponse\fR has to be a dictionary containing the matching
names as keys, and mapping them to the data associated with it at
\fBBind\fR-time\&.
The argument coming before the response tells the client whether the
names in the response were added or removed from the service\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fInameserv\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
comm_wire(n), nameserv(n), nameserv::server(n)
.SH KEYWORDS
comm, name service, protocol
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2007-2008 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
