/****************************************************************************
** Shared Class code from reading file 'KDbObject.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
   Copyright (C) 2003-2010 Jarosław Staniek <staniek@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KDB_OBJECT_H
#define KDB_OBJECT_H

#include "kdb_export.h"
#include "KDbGlobal.h"
#include <QSharedData>

/*! Provides common attributes for KDb objects: id, name, caption,
 help text. A KDb object is typically storable in database, for example:
 table schema or query schema.
 Default type of object is KDb::UnknownObjectType.
*/
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="https://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, virtual_dtor, implicit
class KDB_EXPORT KDbObject
{
public:





    //! @internal data class used to implement implicitly shared class KDbObject.
    //! Provides thread-safe reference counting.
    class Data : public QSharedData
    {
    public:
        Data()
        : type(KDb::UnknownObjectType)
        , id(-1)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , type(other.type)
         , id(other.id)
         , name(other.name)
         , caption(other.caption)
         , description(other.description)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        bool operator==(const Data &other) const {
            return type == other.type
                   && id == other.id
                   && name == other.name
                   && caption == other.caption
                   && description == other.description;
        }

        int type; //!< @see KDbObject::type()
        int id; //!< @see KDbObject::id(), KDbObject::setId()
        QString name; //!< @see KDbObject::name(), KDbObject::setName()
        QString caption; //!< @see KDbObject::caption(), KDbObject::setCaption()
        QString description; //!< @see KDbObject::description(), KDbObject::setDescription()
    };

    KDbObject()
     : d(new Data)
    {
    }

    KDbObject(const KDbObject &other)
     : d(other.d)
    {
    }

    virtual ~KDbObject();

    /*!
    @return the type of this object.
    */
    int type() const {
        return d->type;
    }

    /*!
    @return the identifier of this object, default is -1.
    */
    int id() const {
        return d->id;
    }

    /*!
    Sets the identifier for this object.
    */
    void setId(int id) {
        d->id = id;
    }

    /*!
    @return the name of this object.
    */
    QString name() const {
        return d->name;
    }

    /*!
    Sets the name for this object. It should be valid identifier,
    i.e. start with underscore or latin letter, contain underscores, latin letters and digits.
    */
    void setName(const QString & name) {
        d->name = name;
    }

    /*!
    @return the caption of this object, which is user-visible extended name which can be used
    in user interfaces and translated.
    */
    QString caption() const {
        return d->caption;
    }

    /*!
    Sets the caption for this object.
    */
    void setCaption(const QString & caption) {
        d->caption = caption;
    }

    /*!
    @return the description of this object, which is explanation
            of the object's purpose, etc.
    It can be any text and can be used in user interfaces and translated.
    */
    QString description() const {
        return d->description;
    }

    /*!
    Sets the description for this object.
    */
    void setDescription(const QString & description) {
        d->description = description;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbObject &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbObject &other) const {
        return !operator==(other);
    }


    /*! @return caption of this object if it is not empty, else returns object's name.
    */
    inline QString captionOrName() const {
        return d->caption.isEmpty() ? d->name : d->caption;
    }

    //! Creates new object of type @a type. */
    explicit KDbObject(int type);

protected:
    //! Clears all properties except 'type'.
    virtual void clear();

protected:
    QSharedDataPointer<Data> d;
};

//! Sends information about object @a object to debug output @a dbg.
KDB_EXPORT QDebug operator<<(QDebug dbg, const KDbObject& object);

#endif
