/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.EnumeratedValueResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.descriptor.converter.internal.NamedEnumValueConverter;
import org.hibernate.type.descriptor.converter.internal.OrdinalEnumValueConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.SerializableJavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static <T> BasicValue.Resolution<T> from(BasicJavaType<T> explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, Supplier<JavaType<T>> reflectedJtdResolver, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, MetadataBuildingContext buildingContext) {
        BasicType<Object> jdbcMapping;
        Dialect dialect = buildingContext.getMetadataCollector().getDatabase().getDialect();
        TypeConfiguration typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        JavaType<T> reflectedJtd = reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            JdbcType inferredJdbcType;
            if (explicitJavaType instanceof EnumJavaType) {
                return InferredBasicValueResolver.fromEnum((EnumJavaType)explicitJavaType, null, explicitJdbcType, stdIndicators, buildingContext);
            }
            if (JavaTypeHelper.isTemporal(explicitJavaType)) {
                return InferredBasicValueResolver.fromTemporal((TemporalJavaType)explicitJavaType, null, explicitJdbcType, resolvedJavaType, explicitMutabilityPlanAccess, stdIndicators, typeConfiguration);
            }
            jdbcMapping = explicitJdbcType != null ? typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, explicitJdbcType) : ((inferredJdbcType = explicitJavaType.getRecommendedJdbcType(stdIndicators)) instanceof ObjectJdbcType && (explicitJavaType instanceof SerializableJavaType || explicitJavaType.getJavaType() instanceof Serializable) ? new SerializableType<T>(explicitJavaType) : InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, inferredJdbcType), explicitJavaType));
        } else if (reflectedJtd != null) {
            if (reflectedJtd instanceof EnumJavaType) {
                return InferredBasicValueResolver.fromEnum((EnumJavaType)reflectedJtd, null, explicitJdbcType, stdIndicators, buildingContext);
            }
            if (JavaTypeHelper.isTemporal(reflectedJtd)) {
                return InferredBasicValueResolver.fromTemporal((TemporalJavaType)reflectedJtd, null, explicitJdbcType, resolvedJavaType, explicitMutabilityPlanAccess, stdIndicators, typeConfiguration);
            }
            if (explicitJdbcType != null) {
                jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, explicitJdbcType);
            } else {
                JdbcType recommendedJdbcType;
                BasicType registeredType;
                if (reflectedJtd instanceof BasicPluralJavaType) {
                    JdbcMapping registeredElementType;
                    BasicValue.Resolution resolution;
                    BasicPluralJavaType containerJtd = (BasicPluralJavaType)((Object)reflectedJtd);
                    JavaType elementJtd = containerJtd.getElementJavaType();
                    if (elementJtd instanceof EnumJavaType) {
                        resolution = InferredBasicValueResolver.fromEnum((EnumJavaType)elementJtd, null, null, stdIndicators, buildingContext);
                        registeredElementType = ((EnumeratedValueResolution)resolution).getJdbcMapping();
                    } else if (JavaTypeHelper.isTemporal(elementJtd)) {
                        resolution = InferredBasicValueResolver.fromTemporal((TemporalJavaType)elementJtd, null, null, resolvedJavaType, explicitMutabilityPlanAccess, stdIndicators, typeConfiguration);
                        registeredElementType = ((InferredBasicValueResolution)resolution).getLegacyResolvedBasicType();
                    } else {
                        registeredElementType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(elementJtd.getJavaType());
                    }
                    ColumnTypeInformation columnTypeInformation = selectable instanceof ColumnTypeInformation ? (ColumnTypeInformation)((Object)selectable) : null;
                    BasicType<Object> basicType = registeredType = registeredElementType == null ? null : containerJtd.resolveType(typeConfiguration, dialect, InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredElementType, elementJtd), columnTypeInformation, stdIndicators);
                    if (registeredType instanceof BasicPluralType) {
                        typeConfiguration.getBasicTypeRegistry().register(registeredType);
                    }
                } else {
                    registeredType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
                }
                jdbcMapping = registeredType != null ? InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType, reflectedJtd) : ((recommendedJdbcType = reflectedJtd.getRecommendedJdbcType(stdIndicators)) != null ? InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd, recommendedJdbcType), reflectedJtd) : (reflectedJtd instanceof SerializableJavaType || Serializable.class.isAssignableFrom(reflectedJtd.getJavaTypeClass()) ? new SerializableType<T>(reflectedJtd) : null));
            }
        } else if (explicitJdbcType != null) {
            Integer length = null;
            Integer scale = null;
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                if (column.getPrecision() != null && column.getPrecision() > 0) {
                    length = column.getPrecision();
                    scale = column.getScale();
                } else if (column.getLength() != null) {
                    length = column.getLength() > Integer.MAX_VALUE ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(column.getLength().intValue());
                }
            }
            JavaType recommendedJtd = explicitJdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration);
            jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, typeConfiguration.getBasicTypeRegistry().resolve(recommendedJtd, explicitJdbcType), recommendedJtd);
        } else {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        if (jdbcMapping == null) {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for " + ((BasicValue)stdIndicators).getResolvedJavaType() + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution<Object, T>(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJdbcType(), jdbcMapping, InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, jdbcMapping.getJavaTypeDescriptor(), typeConfiguration));
    }

    public static <T> BasicType<T> resolveSqlTypeIndicators(JdbcTypeIndicators stdIndicators, BasicType<T> resolved, JavaType<T> domainJtd) {
        if (resolved instanceof AdjustableBasicType) {
            AdjustableBasicType indicatorCapable = (AdjustableBasicType)resolved;
            BasicType<T> indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators, domainJtd);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static <E extends Enum<E>, R> EnumeratedValueResolution<E, R> fromEnum(EnumJavaType<E> enumJavaType, BasicJavaType<R> explicitJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, MetadataBuildingContext context) {
        EnumType enumStyle = stdIndicators.getEnumeratedType();
        if (enumStyle == EnumType.STRING) {
            return InferredBasicValueResolver.stringEnumValueResolution(enumJavaType, explicitJavaType, explicitJdbcType, stdIndicators, context);
        }
        if (enumStyle == EnumType.ORDINAL) {
            return InferredBasicValueResolver.ordinalEnumValueResolution(enumJavaType, explicitJavaType, explicitJdbcType, context);
        }
        if (enumStyle == null) {
            return InferredBasicValueResolver.ordinalEnumValueResolution(enumJavaType, explicitJavaType, explicitJdbcType, context);
        }
        throw new MappingException("Unknown enumeration-style (JPA EnumType) : " + enumStyle);
    }

    private static <E extends Enum<E>, N extends Number> EnumeratedValueResolution<E, N> ordinalEnumValueResolution(EnumJavaType<E> enumJavaType, BasicJavaType<N> explicitJavaType, JdbcType explicitJdbcType, MetadataBuildingContext context) {
        JdbcType jdbcType = InferredBasicValueResolver.ordinalJdbcType(explicitJdbcType, enumJavaType, context);
        JavaType<N> relationalJavaType = InferredBasicValueResolver.ordinalJavaType(explicitJavaType, jdbcType, context);
        return new EnumeratedValueResolution<E, N>(jdbcType, new OrdinalEnumValueConverter<E, N>(enumJavaType, jdbcType, relationalJavaType), context);
    }

    private static JdbcType ordinalJdbcType(JdbcType explicitJdbcType, EnumJavaType<?> enumJavaType, MetadataBuildingContext context) {
        return explicitJdbcType != null ? explicitJdbcType : context.getMetadataCollector().getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(enumJavaType.hasManyValues() ? 5 : -6);
    }

    private static <N extends Number> JavaType<N> ordinalJavaType(JavaType<N> explicitJavaType, JdbcType jdbcType, MetadataBuildingContext context) {
        if (explicitJavaType != null) {
            if (!Integer.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] applied to enumerated value with EnumType#ORDINAL should handle `java.lang.Integer` as its relational type descriptor");
            }
            return explicitJavaType;
        }
        return jdbcType.getJdbcRecommendedJavaTypeMapping(null, null, context.getMetadataCollector().getTypeConfiguration());
    }

    private static <E extends Enum<E>> EnumeratedValueResolution<E, String> stringEnumValueResolution(EnumJavaType<E> enumJavaType, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, MetadataBuildingContext context) {
        JdbcType jdbcType = explicitJdbcType == null ? enumJavaType.getRecommendedJdbcType(stdIndicators) : explicitJdbcType;
        JavaType<String> relationalJtd = InferredBasicValueResolver.stringJavaType(explicitJavaType, stdIndicators, context);
        return new EnumeratedValueResolution(jdbcType, new NamedEnumValueConverter<E>(enumJavaType, jdbcType, relationalJtd), context);
    }

    private static JdbcType stringJdbcType(JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, JavaType<String> relationalJtd) {
        return explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(stdIndicators);
    }

    private static JavaType<String> stringJavaType(BasicJavaType<?> explicitJavaType, JdbcTypeIndicators stdIndicators, MetadataBuildingContext context) {
        if (explicitJavaType != null) {
            if (!String.class.isAssignableFrom(explicitJavaType.getJavaTypeClass())) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] applied to enumerated value with EnumType#STRING should handle `java.lang.String` as its relational type descriptor");
            }
            return explicitJavaType;
        }
        return context.getMetadataCollector().getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)(stdIndicators.getColumnLength() == 1L ? Character.class : String.class)));
    }

    public static <T> InferredBasicValueResolution<T, T> fromTemporal(TemporalJavaType<T> reflectedJtd, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators, TypeConfiguration typeConfiguration) {
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!JavaTypeHelper.isTemporal(explicitJavaType)) {
                throw new MappingException("Explicit JavaType [" + explicitJavaType + "] defined for temporal value must implement TemporalJavaType");
            }
            TemporalJavaType explicitTemporalJtd = (TemporalJavaType)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`jakarta.persistence.TemporalType`) mismatch... requested precision = " + requestedTemporalPrecision + "; explicit JavaType (`" + explicitTemporalJtd + "`) precision = " + explicitTemporalJtd.getPrecision());
            }
            JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : explicitTemporalJtd.getRecommendedJdbcType(stdIndicators);
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(explicitTemporalJtd, jdbcType);
            MutabilityPlan<T> mutabilityPlan = InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, explicitTemporalJtd, typeConfiguration);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, jdbcType, jdbcMapping, mutabilityPlan);
        }
        if (explicitJdbcType != null) {
            TemporalJavaType jtd = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd.resolveTypeForPrecision(reflectedJtd.getPrecision(), typeConfiguration);
            BasicType jdbcMapping = typeConfiguration.getBasicTypeRegistry().resolve(jtd, explicitJdbcType);
            return new InferredBasicValueResolution(jdbcMapping, jtd, jtd, explicitJdbcType, jdbcMapping, jtd.getMutabilityPlan());
        }
        BasicType basicType = requestedTemporalPrecision != null && requestedTemporalPrecision != reflectedJtd.getPrecision() ? typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration), TemporalJavaType.resolveJdbcTypeCode(requestedTemporalPrecision)) : typeConfiguration.getBasicTypeRegistry().resolve(reflectedJtd.resolveTypeForPrecision(reflectedJtd.getPrecision(), typeConfiguration), reflectedJtd.getRecommendedJdbcType(stdIndicators));
        return new InferredBasicValueResolution(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getJdbcType(), basicType, InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, reflectedJtd, typeConfiguration));
    }

    private static <T> MutabilityPlan<T> determineMutabilityPlan(Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, JavaType<T> jtd, TypeConfiguration typeConfiguration) {
        MutabilityPlan mutabilityPlan;
        if (explicitMutabilityPlanAccess != null && (mutabilityPlan = explicitMutabilityPlanAccess.apply(typeConfiguration)) != null) {
            return mutabilityPlan;
        }
        return jtd.getMutabilityPlan();
    }
}

