/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.keycloak.utils.ClosingStream;

public class StreamsUtil {
    public static <T> Stream<T> closing(Stream<T> stream) {
        return new ClosingStream<T>(stream);
    }

    public static <T> Stream<T> throwIfEmpty(Stream<T> stream, RuntimeException ex) {
        Iterator iterator = stream.iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        throw ex;
    }

    public static <T> Stream<T> paginatedStream(Stream<T> originalStream, Integer first, Integer max) {
        if (first != null && first > 0) {
            originalStream = originalStream.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            originalStream = originalStream.limit(max.intValue());
        }
        return originalStream;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

