"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addDetectorMethods = addDetectorMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addDetectorMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.CREATE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_DETECTORS] = createAction({
    url: {
      fmt: `${_constants.API.SEARCH_DETECTORS}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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