"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAlertsRoutes = setupAlertsRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupAlertsRoutes(services, router) {
  const {
    alertService
  } = services;
  router.get({
    path: _constants.API.GET_ALERTS,
    validate: {
      query: _configSchema.schema.object({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detector_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, alertService.getAlerts);
  router.post({
    path: _constants.API.ACKNOWLEDGE_ALERTS,
    validate: {
      params: _configSchema.schema.object({
        detector_id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, alertService.acknowledgeAlerts);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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