/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import org.apache.batik.util.DoublyLinkedList;

public class LRUCache {
    private DoublyLinkedList free = null;
    private DoublyLinkedList used = null;
    private int maxSize = 0;

    public LRUCache(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.maxSize = n;
        this.free = new DoublyLinkedList();
        this.used = new DoublyLinkedList();
        while (n > 0) {
            this.free.add(new LRUNode());
            --n;
        }
    }

    public int getUsed() {
        return this.used.getSize();
    }

    public synchronized void setSize(int n) {
        if (this.maxSize < n) {
            int n2 = this.maxSize;
            while (n2 < n) {
                this.free.add(new LRUNode());
                ++n2;
            }
        } else if (this.maxSize > n) {
            int n3 = this.used.getSize();
            while (n3 > n) {
                LRUNode lRUNode = (LRUNode)this.used.getTail();
                this.used.remove(lRUNode);
                lRUNode.setObj(null);
                --n3;
            }
        }
        this.maxSize = n;
    }

    public synchronized void flush() {
        while (this.used.getSize() > 0) {
            LRUNode lRUNode = (LRUNode)this.used.pop();
            lRUNode.setObj(null);
            this.free.add(lRUNode);
        }
    }

    public synchronized void remove(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.remove(lRUNode);
        lRUNode.setObj(null);
        this.free.add(lRUNode);
    }

    public synchronized void touch(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.touch(lRUNode);
    }

    public synchronized void add(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode != null) {
            this.used.touch(lRUNode);
            return;
        }
        if (this.free.getSize() > 0) {
            lRUNode = (LRUNode)this.free.pop();
            lRUNode.setObj(lRUObj);
            this.used.add(lRUNode);
        } else {
            lRUNode = (LRUNode)this.used.getTail();
            lRUNode.setObj(lRUObj);
            this.used.touch(lRUNode);
        }
    }

    protected synchronized void print() {
        System.out.println("In Use: " + this.used.getSize() + " Free: " + this.free.getSize());
        LRUNode lRUNode = (LRUNode)this.used.getHead();
        if (lRUNode == null) {
            return;
        }
        do {
            System.out.println(lRUNode.getObj());
        } while ((lRUNode = (LRUNode)lRUNode.getNext()) != this.used.getHead());
    }

    public class LRUNode
    extends DoublyLinkedList.Node {
        private LRUObj obj = null;

        public LRUObj getObj() {
            return this.obj;
        }

        protected void setObj(LRUObj lRUObj) {
            if (this.obj != null) {
                this.obj.lruRemove();
            }
            this.obj = lRUObj;
            if (this.obj != null) {
                this.obj.lruSet(this);
            }
        }
    }

    public static interface LRUObj {
        public void lruSet(LRUNode var1);

        public LRUNode lruGet();

        public void lruRemove();
    }
}

