// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"context"
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourcePrivateCaCACustomDiff(_ context.Context, diff *schema.ResourceDiff, meta interface{}) error {
	if diff.HasChange("desired_state") {
		_, new := diff.GetChange("desired_state")

		if isNewResource(diff) {
			if diff.Get("type").(string) == "SUBORDINATE" {
				return fmt.Errorf("`desired_state` can not be specified when creating a SUBORDINATE CA")
			}
			if new.(string) != "STAGED" && new.(string) != "ENABLED" {
				return fmt.Errorf("`desired_state` can only be set to `STAGED` or `ENABLED` when creating a new CA")
			}
		} else {
			if new == "STAGED" && diff.Get("state") != new {
				return fmt.Errorf("Field `desired_state` can only be set to `STAGED` when creating a new CA")
			}
		}
	}
	return nil
}

func isNewResource(diff *schema.ResourceDiff) bool {
	name := diff.Get("name")
	return name.(string) == ""
}

func resourcePrivatecaCertificateAuthority() *schema.Resource {
	return &schema.Resource{
		Create: resourcePrivatecaCertificateAuthorityCreate,
		Read:   resourcePrivatecaCertificateAuthorityRead,
		Update: resourcePrivatecaCertificateAuthorityUpdate,
		Delete: resourcePrivatecaCertificateAuthorityDelete,

		Importer: &schema.ResourceImporter{
			State: resourcePrivatecaCertificateAuthorityImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		CustomizeDiff: resourcePrivateCaCACustomDiff,

		Schema: map[string]*schema.Schema{
			"certificate_authority_id": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The user provided Resource ID for this Certificate Authority.`,
			},
			"config": {
				Type:        schema.TypeList,
				Required:    true,
				ForceNew:    true,
				Description: `The config used to create a self-signed X.509 certificate or CSR.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"subject_config": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Specifies some of the values in a certificate that are related to the subject.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"subject": {
										Type:        schema.TypeList,
										Required:    true,
										ForceNew:    true,
										Description: `Contains distinguished name fields such as the location and organization.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"common_name": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The common name of the distinguished name.`,
												},
												"organization": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The organization of the subject.`,
												},
												"country_code": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The country code of the subject.`,
												},
												"locality": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The locality or city of the subject.`,
												},
												"organizational_unit": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The organizational unit of the subject.`,
												},
												"postal_code": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The postal code of the subject.`,
												},
												"province": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The province, territory, or regional state of the subject.`,
												},
												"street_address": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The street address of the subject.`,
												},
											},
										},
									},
									"subject_alt_name": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The subject alternative name fields.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"dns_names": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid, fully-qualified host names.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"email_addresses": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid RFC 2822 E-mail addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"ip_addresses": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"uris": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid RFC 3986 URIs.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
											},
										},
									},
								},
							},
						},
						"x509_config": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Describes how some of the technical X.509 fields in a certificate should be populated.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"ca_options": {
										Type:        schema.TypeList,
										Required:    true,
										ForceNew:    true,
										Description: `Describes values that are relevant in a CA certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"is_ca": {
													Type:        schema.TypeBool,
													Required:    true,
													ForceNew:    true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to true.`,
												},
												"max_issuer_path_length": {
													Type:     schema.TypeInt,
													Optional: true,
													ForceNew: true,
													Description: `Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.`,
												},
												"non_ca": {
													Type:     schema.TypeBool,
													Optional: true,
													ForceNew: true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to false. 
If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.`,
												},
												"zero_max_issuer_path_length": {
													Type:     schema.TypeBool,
													Optional: true,
													ForceNew: true,
													Description: `When true, the "path length constraint" in Basic Constraints extension will be set to 0.
if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
the max path length will be omitted from the CA certificate.`,
												},
											},
										},
									},
									"key_usage": {
										Type:        schema.TypeList,
										Required:    true,
										ForceNew:    true,
										Description: `Indicates the intended use for keys that correspond to a certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"base_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"cert_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to sign certificates.`,
															},
															"content_commitment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".`,
															},
															"crl_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used sign certificate revocation lists.`,
															},
															"data_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher data.`,
															},
															"decipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to decipher only.`,
															},
															"digital_signature": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used for digital signatures.`,
															},
															"encipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher only.`,
															},
															"key_agreement": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used in a key agreement protocol.`,
															},
															"key_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher other keys.`,
															},
														},
													},
												},
												"extended_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"client_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.`,
															},
															"code_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".`,
															},
															"email_protection": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".`,
															},
															"ocsp_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".`,
															},
															"server_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.`,
															},
															"time_stamping": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".`,
															},
														},
													},
												},
												"unknown_extended_key_usages": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																ForceNew:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
											},
										},
									},
									"additional_extensions": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"critical": {
													Type:     schema.TypeBool,
													Required: true,
													ForceNew: true,
													Description: `Indicates whether or not this extension is critical (i.e., if the client does not know how to
handle this extension, the client should consider this to be an error).`,
												},
												"object_id": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes values that are relevant in a CA certificate.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																ForceNew:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
												"value": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The value of this X.509 extension. A base64-encoded string.`,
												},
											},
										},
									},
									"aia_ocsp_servers": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
"Authority Information Access" extension in the certificate.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"policy_ids": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"object_id_path": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
			"key_spec": {
				Type:     schema.TypeList,
				Required: true,
				ForceNew: true,
				Description: `Used when issuing certificates for this CertificateAuthority. If this CertificateAuthority
is a self-signed CertificateAuthority, this key is also used to sign the self-signed CA
certificate. Otherwise, it is used to sign a CSR.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"algorithm": {
							Type:         schema.TypeString,
							Optional:     true,
							ForceNew:     true,
							ValidateFunc: validateEnum([]string{"SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384", ""}),
							Description: `The algorithm to use for creating a managed Cloud KMS key for a for a simplified
experience. All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]`,
							ExactlyOneOf: []string{"key_spec.0.cloud_kms_key_version", "key_spec.0.algorithm"},
						},
						"cloud_kms_key_version": {
							Type:     schema.TypeString,
							Optional: true,
							ForceNew: true,
							Description: `The resource name for an existing Cloud KMS CryptoKeyVersion in the format
'projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*'.`,
							ExactlyOneOf: []string{"key_spec.0.cloud_kms_key_version", "key_spec.0.algorithm"},
						},
					},
				},
			},
			"location": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `Location of the CertificateAuthority. A full list of valid locations can be found by
running 'gcloud privateca locations list'.`,
			},
			"pool": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name of the CaPool this Certificate Authority belongs to.`,
			},
			"gcs_bucket": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
(such as 'gs://') or suffixes (such as '.googleapis.com'). For example, to use a bucket named
my-bucket, you would simply specify 'my-bucket'. If not specified, a managed bucket will be
created.`,
			},
			"ignore_active_certificates_on_deletion": {
				Type:     schema.TypeBool,
				Optional: true,
				Description: `This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
Use with care. Defaults to 'false'.`,
				Default: false,
			},
			"labels": {
				Type:     schema.TypeMap,
				Optional: true,
				Description: `Labels with user-defined metadata.

An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
"1.3kg", "count": "3" }.`,
				Elem: &schema.Schema{Type: schema.TypeString},
			},
			"lifetime": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
"notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
fractional digits, terminated by 's'. Example: "3.5s".`,
				Default: "315360000s",
			},
			"pem_ca_certificate": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.`,
			},
			"subordinate_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `If this is a subordinate CertificateAuthority, this field will be set
with the subordinate configuration, which describes its issuers.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"certificate_authority": {
							Type:             schema.TypeString,
							Optional:         true,
							DiffSuppressFunc: compareResourceNames,
							Description: `This can refer to a CertificateAuthority that was used to create a
subordinate CertificateAuthority. This field is used for information
and usability purposes only. The resource name is in the format
'projects/*/locations/*/caPools/*/certificateAuthorities/*'.`,
							ExactlyOneOf: []string{"subordinate_config.0.certificate_authority", "subordinate_config.0.pem_issuer_chain"},
						},
						"pem_issuer_chain": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Contains the PEM certificate chain for the issuers of this CertificateAuthority, 
but not pem certificate for this CA itself.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"pem_certificates": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Expected to be in leaf-to-root order according to RFC 5246.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
							ExactlyOneOf: []string{"subordinate_config.0.certificate_authority", "subordinate_config.0.pem_issuer_chain"},
						},
					},
				},
			},
			"type": {
				Type:         schema.TypeString,
				Optional:     true,
				ForceNew:     true,
				ValidateFunc: validateEnum([]string{"SELF_SIGNED", "SUBORDINATE", ""}),
				Description: `The Type of this CertificateAuthority.

~> **Note:** For 'SUBORDINATE' Certificate Authorities, they need to
be activated before they can issue certificates. Default value: "SELF_SIGNED" Possible values: ["SELF_SIGNED", "SUBORDINATE"]`,
				Default: "SELF_SIGNED",
			},
			"access_urls": {
				Type:        schema.TypeList,
				Computed:    true,
				Description: `URLs for accessing content published by this CA, such as the CA certificate and CRLs.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"ca_certificate_access_url": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `The URL where this CertificateAuthority's CA certificate is published. This will only be
set for CAs that have been activated.`,
						},
						"crl_access_urls": {
							Type:     schema.TypeList,
							Computed: true,
							Description: `The URL where this CertificateAuthority's CRLs are published. This will only be set for
CAs that have been activated.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
					},
				},
			},
			"create_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The time at which this CertificateAuthority was created.

A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The resource name for this CertificateAuthority in the format
projects/*/locations/*/certificateAuthorities/*.`,
			},
			"pem_ca_certificates": {
				Type:     schema.TypeList,
				Computed: true,
				Description: `This CertificateAuthority's certificate chain, including the current
CertificateAuthority's certificate. Ordered such that the root issuer is the final
element (consistent with RFC 5246). For a self-signed CA, this will only list the current
CertificateAuthority's certificate.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"state": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The State for this CertificateAuthority.`,
			},
			"update_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The time at which this CertificateAuthority was updated.

A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
			},
			"deletion_protection": {
				Type:     schema.TypeBool,
				Optional: true,
				Default:  true,
			},
			"desired_state": {
				Type:     schema.TypeString,
				Optional: true,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourcePrivatecaCertificateAuthorityCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	typeProp, err := expandPrivatecaCertificateAuthorityType(d.Get("type"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("type"); !isEmptyValue(reflect.ValueOf(typeProp)) && (ok || !reflect.DeepEqual(v, typeProp)) {
		obj["type"] = typeProp
	}
	configProp, err := expandPrivatecaCertificateAuthorityConfig(d.Get("config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("config"); !isEmptyValue(reflect.ValueOf(configProp)) && (ok || !reflect.DeepEqual(v, configProp)) {
		obj["config"] = configProp
	}
	lifetimeProp, err := expandPrivatecaCertificateAuthorityLifetime(d.Get("lifetime"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("lifetime"); !isEmptyValue(reflect.ValueOf(lifetimeProp)) && (ok || !reflect.DeepEqual(v, lifetimeProp)) {
		obj["lifetime"] = lifetimeProp
	}
	keySpecProp, err := expandPrivatecaCertificateAuthorityKeySpec(d.Get("key_spec"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("key_spec"); !isEmptyValue(reflect.ValueOf(keySpecProp)) && (ok || !reflect.DeepEqual(v, keySpecProp)) {
		obj["keySpec"] = keySpecProp
	}
	subordinateConfigProp, err := expandPrivatecaCertificateAuthoritySubordinateConfig(d.Get("subordinate_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("subordinate_config"); !isEmptyValue(reflect.ValueOf(subordinateConfigProp)) && (ok || !reflect.DeepEqual(v, subordinateConfigProp)) {
		obj["subordinateConfig"] = subordinateConfigProp
	}
	gcsBucketProp, err := expandPrivatecaCertificateAuthorityGcsBucket(d.Get("gcs_bucket"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("gcs_bucket"); !isEmptyValue(reflect.ValueOf(gcsBucketProp)) && (ok || !reflect.DeepEqual(v, gcsBucketProp)) {
		obj["gcsBucket"] = gcsBucketProp
	}
	labelsProp, err := expandPrivatecaCertificateAuthorityLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(labelsProp)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities?certificateAuthorityId={{certificate_authority_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new CertificateAuthority: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CertificateAuthority: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	// Drop `subordinateConfig` as it can not be set during CA creation.
	// It can be used to activate CA during post_create or pre_update.
	delete(obj, "subordinateConfig")
	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating CertificateAuthority: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = privatecaOperationWaitTimeWithResponse(
		config, res, &opRes, project, "Creating CertificateAuthority", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create CertificateAuthority: %s", err)
	}

	opRes, err = resourcePrivatecaCertificateAuthorityDecoder(d, meta, opRes)
	if err != nil {
		return fmt.Errorf("Error decoding response from operation: %s", err)
	}
	if opRes == nil {
		return fmt.Errorf("Error decoding response from operation, could not find object")
	}

	if err := d.Set("name", flattenPrivatecaCertificateAuthorityName(opRes["name"], d, config)); err != nil {
		return err
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	staged := d.Get("type").(string) == "SELF_SIGNED"

	if d.Get("type").(string) == "SUBORDINATE" {
		if _, ok := d.GetOk("subordinate_config"); ok {
			// First party issuer
			log.Printf("[DEBUG] Activating CertificateAuthority with first party issuer")
			if err := activateSubCAWithFirstPartyIssuer(config, d, project, billingProject, userAgent); err != nil {
				return fmt.Errorf("Error activating subordinate CA with first party issuer: %v", err)
			}
			staged = true
			log.Printf("[DEBUG] CertificateAuthority activated")
		}
	}

	// Enable the CA if `desired_state` is unspecified or specified as `ENABLED`.
	if p, ok := d.GetOk("desired_state"); !ok || p.(string) == "ENABLED" {
		// Skip enablement on SUBORDINATE CA for backward compatible.
		if staged {
			if err := enableCA(config, d, project, billingProject, userAgent); err != nil {
				return fmt.Errorf("Error enabling CertificateAuthority: %v", err)
			}
		}
	}

	log.Printf("[DEBUG] Finished creating CertificateAuthority %q: %#v", d.Id(), res)

	return resourcePrivatecaCertificateAuthorityRead(d, meta)
}

func resourcePrivatecaCertificateAuthorityRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CertificateAuthority: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("PrivatecaCertificateAuthority %q", d.Id()))
	}

	res, err = resourcePrivatecaCertificateAuthorityDecoder(d, meta, res)
	if err != nil {
		return err
	}

	if res == nil {
		// Decoding the object has resulted in it being gone. It may be marked deleted
		log.Printf("[DEBUG] Removing PrivatecaCertificateAuthority because it no longer exists.")
		d.SetId("")
		return nil
	}

	// Explicitly set virtual fields to default values if unset
	if _, ok := d.GetOkExists("deletion_protection"); !ok {
		if err := d.Set("deletion_protection", true); err != nil {
			return fmt.Errorf("Error setting deletion_protection: %s", err)
		}
	}
	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}

	if err := d.Set("name", flattenPrivatecaCertificateAuthorityName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("type", flattenPrivatecaCertificateAuthorityType(res["type"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("config", flattenPrivatecaCertificateAuthorityConfig(res["config"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("lifetime", flattenPrivatecaCertificateAuthorityLifetime(res["lifetime"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("key_spec", flattenPrivatecaCertificateAuthorityKeySpec(res["keySpec"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("subordinate_config", flattenPrivatecaCertificateAuthoritySubordinateConfig(res["subordinateConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("state", flattenPrivatecaCertificateAuthorityState(res["state"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("pem_ca_certificates", flattenPrivatecaCertificateAuthorityPemCaCertificates(res["pemCaCertificates"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("gcs_bucket", flattenPrivatecaCertificateAuthorityGcsBucket(res["gcsBucket"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("access_urls", flattenPrivatecaCertificateAuthorityAccessUrls(res["accessUrls"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("create_time", flattenPrivatecaCertificateAuthorityCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("update_time", flattenPrivatecaCertificateAuthorityUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}
	if err := d.Set("labels", flattenPrivatecaCertificateAuthorityLabels(res["labels"], d, config)); err != nil {
		return fmt.Errorf("Error reading CertificateAuthority: %s", err)
	}

	return nil
}

func resourcePrivatecaCertificateAuthorityUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CertificateAuthority: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	subordinateConfigProp, err := expandPrivatecaCertificateAuthoritySubordinateConfig(d.Get("subordinate_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("subordinate_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, subordinateConfigProp)) {
		obj["subordinateConfig"] = subordinateConfigProp
	}
	labelsProp, err := expandPrivatecaCertificateAuthorityLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating CertificateAuthority %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("subordinate_config") {
		updateMask = append(updateMask, "subordinateConfig")
	}

	if d.HasChange("labels") {
		updateMask = append(updateMask, "labels")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}
	if d.HasChange("subordinate_config") {
		if d.Get("type").(string) != "SUBORDINATE" {
			return fmt.Errorf("`subordinate_config` can only be configured on subordinate CA")
		}

		// Activate subordinate CA in `AWAITING_USER_ACTIVATION` state.
		if d.Get("state") == "AWAITING_USER_ACTIVATION" {
			if _, ok := d.GetOk("pem_ca_certificate"); ok {
				// Third party issuer
				log.Printf("[DEBUG] Activating CertificateAuthority with third party issuer")
				if err := activateSubCAWithThirdPartyIssuer(config, d, project, billingProject, userAgent); err != nil {
					return fmt.Errorf("Error activating subordinate CA with third party issuer: %v", err)
				}
			} else {
				// First party issuer
				log.Printf("[DEBUG] Activating CertificateAuthority with first party issuer")
				if err := activateSubCAWithFirstPartyIssuer(config, d, project, billingProject, userAgent); err != nil {
					return fmt.Errorf("Error activating subordinate CA with first party issuer: %v", err)
				}
			}
			log.Printf("[DEBUG] CertificateAuthority activated")
		}
	}

	log.Printf("[DEBUG] checking desired_state")
	if d.HasChange("desired_state") {
		// Currently, most CA state update operations are not idempotent.
		// Try to change state only if the current `state` does not match the `desired_state`.
		if p, ok := d.GetOk("desired_state"); ok && p.(string) != d.Get("state").(string) {
			switch p.(string) {
			case "ENABLED":
				if err := enableCA(config, d, project, billingProject, userAgent); err != nil {
					return fmt.Errorf("Error enabling CertificateAuthority: %v", err)
				}
			case "DISABLED":
				if err := disableCA(config, d, project, billingProject, userAgent); err != nil {
					return fmt.Errorf("Error disabling CertificateAuthority: %v", err)
				}
			default:
				return fmt.Errorf("Unsupported value in field `desired_state`")
			}
		}
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating CertificateAuthority %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating CertificateAuthority %q: %#v", d.Id(), res)
	}

	err = privatecaOperationWaitTime(
		config, res, project, "Updating CertificateAuthority", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourcePrivatecaCertificateAuthorityRead(d, meta)
}

func resourcePrivatecaCertificateAuthorityDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for CertificateAuthority: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}?ignoreActiveCertificates={{ignore_active_certificates_on_deletion}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	if d.Get("deletion_protection").(bool) {
		return fmt.Errorf("cannot destroy CertificateAuthority without setting deletion_protection=false and running `terraform apply`")
	}

	if d.Get("state").(string) == "ENABLED" {
		disableUrl, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}:disable")
		if err != nil {
			return err
		}

		log.Printf("[DEBUG] Disabling CertificateAuthority: %#v", obj)

		dRes, err := sendRequest(config, "POST", billingProject, disableUrl, userAgent, nil)
		if err != nil {
			return fmt.Errorf("Error disabling CertificateAuthority: %s", err)
		}

		var opRes map[string]interface{}
		err = privatecaOperationWaitTimeWithResponse(
			config, dRes, &opRes, project, "Disabling CertificateAuthority", userAgent,
			d.Timeout(schema.TimeoutDelete))
		if err != nil {
			return fmt.Errorf("Error waiting to disable CertificateAuthority: %s", err)
		}
	}
	log.Printf("[DEBUG] Deleting CertificateAuthority %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "CertificateAuthority")
	}

	err = privatecaOperationWaitTime(
		config, res, project, "Deleting CertificateAuthority", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting CertificateAuthority %q: %#v", d.Id(), res)
	return nil
}

func resourcePrivatecaCertificateAuthorityImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/caPools/(?P<pool>[^/]+)/certificateAuthorities/(?P<certificate_authority_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<pool>[^/]+)/(?P<certificate_authority_id>[^/]+)",
		"(?P<location>[^/]+)/(?P<pool>[^/]+)/(?P<certificate_authority_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificateAuthorities/{{certificate_authority_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Explicitly set virtual fields to default values on import
	if err := d.Set("deletion_protection", true); err != nil {
		return nil, fmt.Errorf("Error setting deletion_protection: %s", err)
	}
	if err := d.Set("ignore_active_certificates_on_deletion", false); err != nil {
		return nil, err
	}

	return []*schema.ResourceData{d}, nil
}

func flattenPrivatecaCertificateAuthorityName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["x509_config"] =
		flattenPrivatecaCertificateAuthorityConfigX509Config(original["x509Config"], d, config)
	transformed["subject_config"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfig(original["subjectConfig"], d, config)
	return []interface{}{transformed}
}

func flattenPrivatecaCertificateAuthorityConfigX509Config(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		v = make(map[string]interface{})
	}
	original := v.(map[string]interface{})
	transformed := make(map[string]interface{})
	transformed["additional_extensions"] =
		flattenPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additionalExtensions"], d, config)
	transformed["policy_ids"] =
		flattenPrivatecaCertificateConfigX509ConfigPolicyIds(original["policyIds"], d, config)
	transformed["aia_ocsp_servers"] = flattenPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aiaOcspServers"], d, config)
	transformed["ca_options"] =
		flattenPrivatecaCertificateConfigX509ConfigCaOptions(original["caOptions"], d, config)
	transformed["key_usage"] =
		flattenPrivatecaCertificateConfigX509ConfigKeyUsage(original["keyUsage"], d, config)
	return []interface{}{transformed}
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["subject"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubject(original["subject"], d, config)
	transformed["subject_alt_name"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName(original["subjectAltName"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["country_code"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCountryCode(original["countryCode"], d, config)
	transformed["organization"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganization(original["organization"], d, config)
	transformed["organizational_unit"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganizationalUnit(original["organizationalUnit"], d, config)
	transformed["locality"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectLocality(original["locality"], d, config)
	transformed["province"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectProvince(original["province"], d, config)
	transformed["street_address"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectStreetAddress(original["streetAddress"], d, config)
	transformed["postal_code"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectPostalCode(original["postalCode"], d, config)
	transformed["common_name"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCommonName(original["commonName"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCountryCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganizationalUnit(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectLocality(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectProvince(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectStreetAddress(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectPostalCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCommonName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["dns_names"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameDnsNames(original["dnsNames"], d, config)
	transformed["uris"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameUris(original["uris"], d, config)
	transformed["email_addresses"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameEmailAddresses(original["emailAddresses"], d, config)
	transformed["ip_addresses"] =
		flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameIpAddresses(original["ipAddresses"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameDnsNames(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameUris(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameEmailAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameIpAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityLifetime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityKeySpec(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["cloud_kms_key_version"] =
		flattenPrivatecaCertificateAuthorityKeySpecCloudKmsKeyVersion(original["cloudKmsKeyVersion"], d, config)
	transformed["algorithm"] =
		flattenPrivatecaCertificateAuthorityKeySpecAlgorithm(original["algorithm"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthorityKeySpecCloudKmsKeyVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityKeySpecAlgorithm(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthoritySubordinateConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["certificate_authority"] =
		flattenPrivatecaCertificateAuthoritySubordinateConfigCertificateAuthority(original["certificateAuthority"], d, config)
	transformed["pem_issuer_chain"] =
		flattenPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain(original["pemIssuerChain"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthoritySubordinateConfigCertificateAuthority(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["pem_certificates"] =
		flattenPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainPemCertificates(original["pemCertificates"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainPemCertificates(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityPemCaCertificates(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityGcsBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityAccessUrls(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["ca_certificate_access_url"] =
		flattenPrivatecaCertificateAuthorityAccessUrlsCaCertificateAccessUrl(original["caCertificateAccessUrl"], d, config)
	transformed["crl_access_urls"] =
		flattenPrivatecaCertificateAuthorityAccessUrlsCrlAccessUrls(original["crlAccessUrls"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateAuthorityAccessUrlsCaCertificateAccessUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityAccessUrlsCrlAccessUrls(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateAuthorityLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandPrivatecaCertificateAuthorityType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedX509Config, err := expandPrivatecaCertificateAuthorityConfigX509Config(original["x509_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedX509Config); val.IsValid() && !isEmptyValue(val) {
		transformed["x509Config"] = transformedX509Config
	}

	transformedSubjectConfig, err := expandPrivatecaCertificateAuthorityConfigSubjectConfig(original["subject_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubjectConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["subjectConfig"] = transformedSubjectConfig
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityConfigX509Config(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	if v == nil {
		return v, nil
	}
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	if len(original) == 0 {
		return nil, nil
	}
	transformed := make(map[string]interface{})

	caOptions, err := expandPrivatecaCertificateConfigX509ConfigCaOptions(original["ca_options"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["caOptions"] = caOptions

	keyUsage, err := expandPrivatecaCertificateConfigX509ConfigKeyUsage(original["key_usage"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["keyUsage"] = keyUsage

	policyIds, err := expandPrivatecaCertificateConfigX509ConfigPolicyIds(original["policy_ids"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["policyIds"] = policyIds

	aiaOcspServers, err := expandPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aia_ocsp_servers"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["aiaOcspServers"] = aiaOcspServers

	addExts, err := expandPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additional_extensions"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["additionalExtensions"] = addExts

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSubject, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubject(original["subject"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubject); val.IsValid() && !isEmptyValue(val) {
		transformed["subject"] = transformedSubject
	}

	transformedSubjectAltName, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName(original["subject_alt_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubjectAltName); val.IsValid() && !isEmptyValue(val) {
		transformed["subjectAltName"] = transformedSubjectAltName
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCountryCode, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCountryCode(original["country_code"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCountryCode); val.IsValid() && !isEmptyValue(val) {
		transformed["countryCode"] = transformedCountryCode
	}

	transformedOrganization, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganization(original["organization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOrganization); val.IsValid() && !isEmptyValue(val) {
		transformed["organization"] = transformedOrganization
	}

	transformedOrganizationalUnit, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganizationalUnit(original["organizational_unit"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOrganizationalUnit); val.IsValid() && !isEmptyValue(val) {
		transformed["organizationalUnit"] = transformedOrganizationalUnit
	}

	transformedLocality, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectLocality(original["locality"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocality); val.IsValid() && !isEmptyValue(val) {
		transformed["locality"] = transformedLocality
	}

	transformedProvince, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectProvince(original["province"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProvince); val.IsValid() && !isEmptyValue(val) {
		transformed["province"] = transformedProvince
	}

	transformedStreetAddress, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectStreetAddress(original["street_address"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStreetAddress); val.IsValid() && !isEmptyValue(val) {
		transformed["streetAddress"] = transformedStreetAddress
	}

	transformedPostalCode, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectPostalCode(original["postal_code"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPostalCode); val.IsValid() && !isEmptyValue(val) {
		transformed["postalCode"] = transformedPostalCode
	}

	transformedCommonName, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCommonName(original["common_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommonName); val.IsValid() && !isEmptyValue(val) {
		transformed["commonName"] = transformedCommonName
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCountryCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectOrganizationalUnit(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectLocality(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectProvince(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectStreetAddress(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectPostalCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectCommonName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDnsNames, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameDnsNames(original["dns_names"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDnsNames); val.IsValid() && !isEmptyValue(val) {
		transformed["dnsNames"] = transformedDnsNames
	}

	transformedUris, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameUris(original["uris"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUris); val.IsValid() && !isEmptyValue(val) {
		transformed["uris"] = transformedUris
	}

	transformedEmailAddresses, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameEmailAddresses(original["email_addresses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEmailAddresses); val.IsValid() && !isEmptyValue(val) {
		transformed["emailAddresses"] = transformedEmailAddresses
	}

	transformedIpAddresses, err := expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameIpAddresses(original["ip_addresses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIpAddresses); val.IsValid() && !isEmptyValue(val) {
		transformed["ipAddresses"] = transformedIpAddresses
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameDnsNames(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameUris(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameEmailAddresses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameIpAddresses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityLifetime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityKeySpec(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCloudKmsKeyVersion, err := expandPrivatecaCertificateAuthorityKeySpecCloudKmsKeyVersion(original["cloud_kms_key_version"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCloudKmsKeyVersion); val.IsValid() && !isEmptyValue(val) {
		transformed["cloudKmsKeyVersion"] = transformedCloudKmsKeyVersion
	}

	transformedAlgorithm, err := expandPrivatecaCertificateAuthorityKeySpecAlgorithm(original["algorithm"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAlgorithm); val.IsValid() && !isEmptyValue(val) {
		transformed["algorithm"] = transformedAlgorithm
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthorityKeySpecCloudKmsKeyVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityKeySpecAlgorithm(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthoritySubordinateConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCertificateAuthority, err := expandPrivatecaCertificateAuthoritySubordinateConfigCertificateAuthority(original["certificate_authority"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCertificateAuthority); val.IsValid() && !isEmptyValue(val) {
		transformed["certificateAuthority"] = transformedCertificateAuthority
	}

	transformedPemIssuerChain, err := expandPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain(original["pem_issuer_chain"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPemIssuerChain); val.IsValid() && !isEmptyValue(val) {
		transformed["pemIssuerChain"] = transformedPemIssuerChain
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthoritySubordinateConfigCertificateAuthority(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPemCertificates, err := expandPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainPemCertificates(original["pem_certificates"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPemCertificates); val.IsValid() && !isEmptyValue(val) {
		transformed["pemCertificates"] = transformedPemCertificates
	}

	return transformed, nil
}

func expandPrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainPemCertificates(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityGcsBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateAuthorityLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func resourcePrivatecaCertificateAuthorityDecoder(d *schema.ResourceData, meta interface{}, res map[string]interface{}) (map[string]interface{}, error) {
	if v := res["state"]; v == "DELETED" {
		return nil, nil
	}

	return res, nil
}
