// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"context"
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func stepTimeoutCustomizeDiff(_ context.Context, diff *schema.ResourceDiff, v interface{}) error {
	buildList := diff.Get("build").([]interface{})
	if len(buildList) == 0 || buildList[0] == nil {
		return nil
	}
	build := buildList[0].(map[string]interface{})
	buildTimeoutString := build["timeout"].(string)

	buildTimeout, err := time.ParseDuration(buildTimeoutString)
	if err != nil {
		return fmt.Errorf("Error parsing build timeout : %s", err)
	}

	var stepTimeoutSum time.Duration = 0
	steps := build["step"].([]interface{})
	for _, rawstep := range steps {
		if rawstep == nil {
			continue
		}
		step := rawstep.(map[string]interface{})
		timeoutString := step["timeout"].(string)
		if len(timeoutString) == 0 {
			continue
		}

		timeout, err := time.ParseDuration(timeoutString)
		if err != nil {
			return fmt.Errorf("Error parsing build step timeout: %s", err)
		}
		stepTimeoutSum += timeout
	}
	if stepTimeoutSum > buildTimeout {
		return fmt.Errorf("Step timeout sum (%v) cannot be greater than build timeout (%v)", stepTimeoutSum, buildTimeout)
	}
	return nil
}

func resourceCloudBuildTrigger() *schema.Resource {
	return &schema.Resource{
		Create: resourceCloudBuildTriggerCreate,
		Read:   resourceCloudBuildTriggerRead,
		Update: resourceCloudBuildTriggerUpdate,
		Delete: resourceCloudBuildTriggerDelete,

		Importer: &schema.ResourceImporter{
			State: resourceCloudBuildTriggerImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		SchemaVersion: 2,
		StateUpgraders: []schema.StateUpgrader{
			{
				Type:    resourceCloudBuildTriggerResourceV0().CoreConfigSchema().ImpliedType(),
				Upgrade: resourceCloudBuildTriggerUpgradeV0,
				Version: 0,
			},
			{
				Type:    resourceCloudBuildTriggerResourceV1().CoreConfigSchema().ImpliedType(),
				Upgrade: resourceCloudBuildTriggerUpgradeV1,
				Version: 1,
			},
		},

		CustomizeDiff: stepTimeoutCustomizeDiff,

		Schema: map[string]*schema.Schema{
			"approval_config": {
				Type:     schema.TypeList,
				Computed: true,
				Optional: true,
				Description: `Configuration for manual approval to start a build invocation of this BuildTrigger. 
Builds created by this trigger will require approval before they execute. 
Any user with a Cloud Build Approver role for the project can approve a build.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"approval_required": {
							Type:     schema.TypeBool,
							Optional: true,
							Description: `Whether or not approval is needed. If this is set on a build, it will become pending when run, 
and will need to be explicitly approved to start.`,
							Default: false,
						},
					},
				},
			},
			"build": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Contents of the build template. Either a filename or build template must be provided.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"step": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `The operations to be performed on the workspace.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"name": {
										Type:     schema.TypeString,
										Required: true,
										Description: `The name of the container image that will run this particular build step.

If the image is available in the host's Docker daemon's cache, it will be
run directly. If not, the host will attempt to pull the image first, using
the builder service account's credentials if necessary.

The Docker daemon's cache will already have the latest versions of all of
the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders 
for images and examples).
The Docker daemon will also have cached many of the layers for some popular
images, like "ubuntu", "debian", but they will be refreshed at the time
you attempt to use them.

If you built an image in a previous build step, it will be stored in the
host's Docker daemon's cache and is available to use as the name for a
later build step.`,
									},
									"args": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of arguments that will be presented to the step when it is started.

If the image used to run the step's container has an entrypoint, the args
are used as arguments to that entrypoint. If the image does not define an
entrypoint, the first element in args is used as the entrypoint, and the
remainder will be used as arguments.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"dir": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Working directory to use when running this step's container.

If this value is a relative path, it is relative to the build's working
directory. If this value is absolute, it may be outside the build's working
directory, in which case the contents of the path may not be persisted
across build step executions, unless a 'volume' for that path is specified.

If the build specifies a 'RepoSource' with 'dir' and a step with a
'dir',
which specifies an absolute path, the 'RepoSource' 'dir' is ignored
for the step's execution.`,
									},
									"entrypoint": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Entrypoint to be used instead of the build step image's
default entrypoint.
If unset, the image's default entrypoint is used`,
									},
									"env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of environment variable definitions to be used when
running a step.

The elements are of the form "KEY=VALUE" for the environment variable
"KEY" being given the value "VALUE".`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"id": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Unique identifier for this build step, used in 'wait_for' to
reference this build step as a dependency.`,
									},
									"secret_env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of environment variables which are encrypted using
a Cloud Key
Management Service crypto key. These values must be specified in
the build's 'Secret'.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"timeout": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Time limit for executing this build step. If not defined,
the step has no
time limit and will be allowed to continue to run until either it
completes or the build itself times out.`,
									},
									"timing": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Output only. Stores timing information for executing this
build step.`,
									},
									"volumes": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `List of volumes to mount into the build step.

Each volume is created as an empty volume prior to execution of the
build step. Upon completion of the build, volumes and their contents
are discarded.

Using a named volume in only one step is not valid as it is
indicative of a build request with an incorrect configuration.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"name": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Name of the volume to mount.

Volume names must be unique per build step and must be valid names for
Docker volumes. Each named volume must be used by at least two build steps.`,
												},
												"path": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Path at which to mount the volume.

Paths must be absolute and cannot conflict with other volume paths on
the same build step or with certain reserved volume paths.`,
												},
											},
										},
									},
									"wait_for": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `The ID(s) of the step(s) that this build step depends on.

This build step will not start until all the build steps in 'wait_for'
have completed successfully. If 'wait_for' is empty, this build step
will start when all previous build steps in the 'Build.Steps' list
have completed successfully.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
						},
						"artifacts": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Artifacts produced by the build that should be uploaded upon successful completion of all build steps.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"images": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of images to be pushed upon the successful completion of all build steps.

The images will be pushed using the builder service account's credentials.

The digests of the pushed images will be stored in the Build resource's results field.

If any of the images fail to be pushed, the build is marked FAILURE.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"objects": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.

Files in the workspace matching specified paths globs will be uploaded to the
Cloud Storage location using the builder service account's credentials.

The location and generation of the uploaded objects will be stored in the Build resource's results field.

If any objects fail to be pushed, the build is marked FAILURE.`,
										MaxItems: 1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"location": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".

Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
this location as a prefix.`,
												},
												"paths": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `Path globs used to match files in the build's workspace.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"timing": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Output only. Stores timing information for pushing all artifact objects.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"end_time": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `End of time span.

A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
															},
															"start_time": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `Start of time span.

A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						"available_secrets": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secrets and secret environment variables.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"secret_manager": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Pairs a secret environment variable with a SecretVersion in Secret Manager.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"env": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Environment variable name to associate with the secret. Secret environment
variables must be unique across all of a build's secrets, and must be used
by at least one build step.`,
												},
												"version_name": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*`,
												},
											},
										},
									},
								},
							},
						},
						"images": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `A list of images to be pushed upon the successful completion of all build steps.
The images are pushed using the builder service account's credentials.
The digests of the pushed images will be stored in the Build resource's results field.
If any of the images fail to be pushed, the build status is marked FAILURE.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"logs_bucket": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Google Cloud Storage bucket where logs should be written. 
Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.`,
						},
						"options": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Special options for this build.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"disk_size_gb": {
										Type:     schema.TypeInt,
										Optional: true,
										Description: `Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
some of the space will be used by the operating system and build utilities.
Also note that this is the minimum disk size that will be allocated for the build --
the build may run with a larger disk than requested. At present, the maximum disk size
is 1000GB; builds that request more than the maximum are rejected with an error.`,
									},
									"dynamic_substitutions": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Option to specify whether or not to apply bash style string operations to the substitutions.

NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.`,
									},
									"env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of global environment variable definitions that will exist for all build steps
in this build. If a variable is defined in both globally and in a build step,
the variable will use the build step value.

The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"log_streaming_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF", ""}),
										Description:  `Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"]`,
									},
									"logging": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE", ""}),
										Description:  `Option to specify the logging mode, which determines if and where build logs are stored. Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE"]`,
									},
									"machine_type": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32", ""}),
										Description:  `Compute Engine machine type on which to run the build. Possible values: ["UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32"]`,
									},
									"requested_verify_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"NOT_VERIFIED", "VERIFIED", ""}),
										Description:  `Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"]`,
									},
									"secret_env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of global environment variables, which are encrypted using a Cloud Key Management
Service crypto key. These values must be specified in the build's Secret. These variables
will be available to all build steps in this build.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"source_provenance_hash": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"]`,
										Elem: &schema.Schema{
											Type:         schema.TypeString,
											ValidateFunc: validateEnum([]string{"NONE", "SHA256", "MD5"}),
										},
									},
									"substitution_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"MUST_MATCH", "ALLOW_LOOSE", ""}),
										Description: `Option to specify behavior when there is an error in the substitution checks.

NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]`,
									},
									"volumes": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `Global list of volumes to mount for ALL build steps

Each volume is created as an empty volume prior to starting the build process.
Upon completion of the build, volumes and their contents are discarded. Global
volume names and paths cannot conflict with the volumes defined a build step.

Using a global volume in a build with only one step is not valid as it is indicative
of a build request with an incorrect configuration.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Name of the volume to mount.

Volume names must be unique per build step and must be valid names for Docker volumes.
Each named volume must be used by at least two build steps.`,
												},
												"path": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Path at which to mount the volume.

Paths must be absolute and cannot conflict with other volume paths on the same
build step or with certain reserved volume paths.`,
												},
											},
										},
									},
									"worker_pool": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}

This field is experimental.`,
									},
								},
							},
						},
						"queue_ttl": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `TTL in queue for this build. If provided and the build is enqueued longer than this value, 
the build will expire and the build status will be EXPIRED.
The TTL starts ticking from createTime.
A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".`,
						},
						"secret": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secrets to decrypt using Cloud Key Management Service.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"kms_key_name": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Cloud KMS key name to use to decrypt these envs.`,
									},
									"secret_env": {
										Type:     schema.TypeMap,
										Optional: true,
										Description: `Map of environment variable name to its encrypted value.
Secret environment variables must be unique across all of a build's secrets, 
and must be used by at least one build step. Values can be at most 64 KB in size. 
There can be at most 100 secret values across all of a build's secrets.`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
								},
							},
						},
						"source": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `The location of the source files to build.

One of 'storageSource' or 'repoSource' must be provided.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"repo_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Location of the source in a Google Cloud Source Repository.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"repo_name": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Name of the Cloud Source Repository.`,
												},
												"branch_name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
The syntax of the regular expressions accepted is the syntax accepted by RE2 and 
described at https://github.com/google/re2/wiki/Syntax`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
												"commit_sha": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
												"dir": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Directory, relative to the source root, in which to run the build.
This must be a relative path. If a step's dir is specified and is an absolute path, 
this value is ignored for that step's execution.`,
												},
												"invert_regex": {
													Type:        schema.TypeBool,
													Optional:    true,
													Description: `Only trigger a build if the revision regex does NOT match the revision regex.`,
												},
												"project_id": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `ID of the project that owns the Cloud Source Repository. 
If omitted, the project ID requesting the build is assumed.`,
												},
												"substitutions": {
													Type:        schema.TypeMap,
													Optional:    true,
													Description: `Substitutions to use in a triggered build. Should only be used with triggers.run`,
													Elem:        &schema.Schema{Type: schema.TypeString},
												},
												"tag_name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
The syntax of the regular expressions accepted is the syntax accepted by RE2 and 
described at https://github.com/google/re2/wiki/Syntax`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
											},
										},
									},
									"storage_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Location of the source in an archive file in Google Cloud Storage.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"bucket": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Google Cloud Storage bucket containing the source.`,
												},
												"object": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Google Cloud Storage object containing the source.
This object must be a gzipped archive file (.tar.gz) containing source to build.`,
												},
												"generation": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Google Cloud Storage generation for the object. 
If the generation is omitted, the latest generation will be used`,
												},
											},
										},
									},
								},
							},
						},
						"substitutions": {
							Type:        schema.TypeMap,
							Optional:    true,
							Description: `Substitutions data for Build resource.`,
							Elem:        &schema.Schema{Type: schema.TypeString},
						},
						"tags": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Tags for annotation of a Build. These are not docker tags.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"timeout": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Amount of time that this build should be allowed to run, to second granularity.
If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
The expected format is the number of seconds followed by s.
Default time is ten minutes (600s).`,
							Default: "600s",
						},
					},
				},
				ExactlyOneOf: []string{"filename", "build", "git_file_source"},
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Human-readable description of the trigger.`,
			},
			"disabled": {
				Type:        schema.TypeBool,
				Optional:    true,
				Description: `Whether the trigger is disabled or not. If true, the trigger will never result in a build.`,
			},
			"filename": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Path, from the source root, to a file whose contents is used for the template. 
Either a filename or build template must be provided. Set this only when using trigger_template or github.
When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.`,
				ExactlyOneOf: []string{"filename", "build", "git_file_source"},
			},
			"filter": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `A Common Expression Language string. Used only with Pub/Sub and Webhook.`,
			},
			"git_file_source": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The file source describing the local or remote Build template.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"path": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The path of the file, with the repo root as the root of the path.`,
						},
						"repo_type": {
							Type:         schema.TypeString,
							Required:     true,
							ValidateFunc: validateEnum([]string{"UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"}),
							Description: `The type of the repo, since it may not be explicit from the repo field (e.g from a URL). 
Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]`,
						},
						"revision": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the 
filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions 
If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.`,
						},
						"uri": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The URI of the repo (optional). If unspecified, the repo from which the trigger 
invocation originated is assumed to be the repo from which to read the specified path.`,
						},
					},
				},
				ExactlyOneOf: []string{"filename", "git_file_source", "build"},
			},
			"github": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Describes the configuration of a trigger that creates a build whenever a GitHub event is received.

One of 'trigger_template', 'github', 'pubsub_config' or 'webhook_config' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the repository. For example: The name for
https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".`,
						},
						"owner": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Owner of the repository. For example: The owner for
https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".`,
						},
						"pull_request": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `filter to match changes in pull requests. Specify only one of 'pull_request' or 'push'.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"branch": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Regex of branches to match.`,
									},
									"comment_control": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY", ""}),
										Description:  `Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]`,
									},
									"invert_regex": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `If true, branches that do NOT match the git_ref will trigger a build.`,
									},
								},
							},
							ExactlyOneOf: []string{"github.0.pull_request", "github.0.push"},
						},
						"push": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `filter to match changes in refs, like branches or tags. Specify only one of 'pull_request' or 'push'.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"branch": {
										Type:         schema.TypeString,
										Optional:     true,
										Description:  `Regex of branches to match.  Specify only one of branch or tag.`,
										ExactlyOneOf: []string{"github.0.push.0.branch", "github.0.push.0.tag"},
									},
									"invert_regex": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `When true, only trigger a build if the revision regex does NOT match the git_ref regex.`,
									},
									"tag": {
										Type:         schema.TypeString,
										Optional:     true,
										Description:  `Regex of tags to match.  Specify only one of branch or tag.`,
										ExactlyOneOf: []string{"github.0.push.0.branch", "github.0.push.0.tag"},
									},
								},
							},
							ExactlyOneOf: []string{"github.0.pull_request", "github.0.push"},
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"ignored_files": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
extended with support for '**'.

If ignoredFiles and changed files are both empty, then they are not
used to determine whether or not to trigger a build.

If ignoredFiles is not empty, then we ignore any files that match any
of the ignored_file globs. If the change has no files that are outside
of the ignoredFiles globs, then we do not trigger a build.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"include_build_logs": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validateEnum([]string{"INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS", ""}),
				Description: `Build logs will be sent back to GitHub as part of the checkrun
result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
INCLUDE_BUILD_LOGS_WITH_STATUS Possible values: ["INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS"]`,
			},
			"included_files": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
extended with support for '**'.

If any of the files altered in the commit pass the ignoredFiles filter
and includedFiles is empty, then as far as this filter is concerned, we
should trigger the build.

If any of the files altered in the commit pass the ignoredFiles filter
and includedFiles is not empty, then we make sure that at least one of
those files matches a includedFiles glob. If not, then we do not trigger
a build.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"location": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
If not specified, "global" is used.`,
				Default: "global",
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Optional:    true,
				Description: `Name of the trigger. Must be unique within the project.`,
			},
			"pubsub_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `PubsubConfig describes the configuration of a trigger that creates 
a build whenever a Pub/Sub message is published.

One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"topic": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The name of the topic from which this subscription is receiving messages.`,
						},
						"service_account_email": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Service account that will make the push request.`,
						},
						"state": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `Potential issues with the underlying Pub/Sub subscription configuration.
Only populated on get requests.`,
						},
						"subscription": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `Output only. Name of the subscription.`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"service_account": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `The service account used for all user-controlled operations including
triggers.patch, triggers.run, builds.create, and builds.cancel.

If no service account is set, then the standard Cloud Build service account
([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.

Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`,
			},
			"source_to_build": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `The repo and ref of the repository from which to build. 
This field is used only for those triggers that do not respond to SCM events. 
Triggers that respond to such events build source at whatever commit caused the event. 
This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.

One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"ref": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The branch or tag to use. Must start with "refs/" (required).`,
						},
						"repo_type": {
							Type:         schema.TypeString,
							Required:     true,
							ValidateFunc: validateEnum([]string{"UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"}),
							Description: `The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]`,
						},
						"uri": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The URI of the repo (required).`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"substitutions": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Substitutions data for Build resource.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"tags": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Tags for annotation of a BuildTrigger`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"trigger_template": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Template describing the types of source changes to trigger a build.

Branch and tag names in trigger templates are interpreted as regular
expressions. Any branch or tag change that matches that regular
expression will trigger a build.

One of 'trigger_template', 'github', 'pubsub_config', 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"branch_name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
This field is a regular expression.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
						"commit_sha": {
							Type:         schema.TypeString,
							Optional:     true,
							Description:  `Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
						"dir": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Directory, relative to the source root, in which to run the build.

This must be a relative path. If a step's dir is specified and
is an absolute path, this value is ignored for that step's
execution.`,
						},
						"invert_regex": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Only trigger a build if the revision regex does NOT match the revision regex.`,
						},
						"project_id": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							Description: `ID of the project that owns the Cloud Source Repository. If
omitted, the project ID requesting the build is assumed.`,
						},
						"repo_name": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Name of the Cloud Source Repository. If omitted, the name "default" is assumed.`,
							Default:     "default",
						},
						"tag_name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
This field is a regular expression.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"webhook_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `WebhookConfig describes the configuration of a trigger that creates 
a build whenever a webhook is sent to a trigger's webhook URL.

One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"secret": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Resource name for the secret required as a URL parameter.`,
						},
						"state": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `Potential issues with the underlying Pub/Sub subscription configuration.
Only populated on get requests.`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"create_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Time when the trigger was created.`,
			},
			"trigger_id": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The unique identifier for the trigger.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceCloudBuildTriggerCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	nameProp, err := expandCloudBuildTriggerName(d.Get("name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("name"); !isEmptyValue(reflect.ValueOf(nameProp)) && (ok || !reflect.DeepEqual(v, nameProp)) {
		obj["name"] = nameProp
	}
	descriptionProp, err := expandCloudBuildTriggerDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	tagsProp, err := expandCloudBuildTriggerTags(d.Get("tags"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("tags"); !isEmptyValue(reflect.ValueOf(tagsProp)) && (ok || !reflect.DeepEqual(v, tagsProp)) {
		obj["tags"] = tagsProp
	}
	disabledProp, err := expandCloudBuildTriggerDisabled(d.Get("disabled"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("disabled"); !isEmptyValue(reflect.ValueOf(disabledProp)) && (ok || !reflect.DeepEqual(v, disabledProp)) {
		obj["disabled"] = disabledProp
	}
	substitutionsProp, err := expandCloudBuildTriggerSubstitutions(d.Get("substitutions"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("substitutions"); !isEmptyValue(reflect.ValueOf(substitutionsProp)) && (ok || !reflect.DeepEqual(v, substitutionsProp)) {
		obj["substitutions"] = substitutionsProp
	}
	serviceAccountProp, err := expandCloudBuildTriggerServiceAccount(d.Get("service_account"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_account"); !isEmptyValue(reflect.ValueOf(serviceAccountProp)) && (ok || !reflect.DeepEqual(v, serviceAccountProp)) {
		obj["serviceAccount"] = serviceAccountProp
	}
	includeBuildLogsProp, err := expandCloudBuildTriggerIncludeBuildLogs(d.Get("include_build_logs"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("include_build_logs"); !isEmptyValue(reflect.ValueOf(includeBuildLogsProp)) && (ok || !reflect.DeepEqual(v, includeBuildLogsProp)) {
		obj["includeBuildLogs"] = includeBuildLogsProp
	}
	filenameProp, err := expandCloudBuildTriggerFilename(d.Get("filename"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("filename"); !isEmptyValue(reflect.ValueOf(filenameProp)) && (ok || !reflect.DeepEqual(v, filenameProp)) {
		obj["filename"] = filenameProp
	}
	filterProp, err := expandCloudBuildTriggerFilter(d.Get("filter"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("filter"); !isEmptyValue(reflect.ValueOf(filterProp)) && (ok || !reflect.DeepEqual(v, filterProp)) {
		obj["filter"] = filterProp
	}
	gitFileSourceProp, err := expandCloudBuildTriggerGitFileSource(d.Get("git_file_source"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("git_file_source"); !isEmptyValue(reflect.ValueOf(gitFileSourceProp)) && (ok || !reflect.DeepEqual(v, gitFileSourceProp)) {
		obj["gitFileSource"] = gitFileSourceProp
	}
	sourceToBuildProp, err := expandCloudBuildTriggerSourceToBuild(d.Get("source_to_build"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("source_to_build"); !isEmptyValue(reflect.ValueOf(sourceToBuildProp)) && (ok || !reflect.DeepEqual(v, sourceToBuildProp)) {
		obj["sourceToBuild"] = sourceToBuildProp
	}
	ignoredFilesProp, err := expandCloudBuildTriggerIgnoredFiles(d.Get("ignored_files"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("ignored_files"); !isEmptyValue(reflect.ValueOf(ignoredFilesProp)) && (ok || !reflect.DeepEqual(v, ignoredFilesProp)) {
		obj["ignoredFiles"] = ignoredFilesProp
	}
	includedFilesProp, err := expandCloudBuildTriggerIncludedFiles(d.Get("included_files"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("included_files"); !isEmptyValue(reflect.ValueOf(includedFilesProp)) && (ok || !reflect.DeepEqual(v, includedFilesProp)) {
		obj["includedFiles"] = includedFilesProp
	}
	triggerTemplateProp, err := expandCloudBuildTriggerTriggerTemplate(d.Get("trigger_template"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("trigger_template"); !isEmptyValue(reflect.ValueOf(triggerTemplateProp)) && (ok || !reflect.DeepEqual(v, triggerTemplateProp)) {
		obj["triggerTemplate"] = triggerTemplateProp
	}
	githubProp, err := expandCloudBuildTriggerGithub(d.Get("github"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("github"); !isEmptyValue(reflect.ValueOf(githubProp)) && (ok || !reflect.DeepEqual(v, githubProp)) {
		obj["github"] = githubProp
	}
	pubsubConfigProp, err := expandCloudBuildTriggerPubsubConfig(d.Get("pubsub_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("pubsub_config"); !isEmptyValue(reflect.ValueOf(pubsubConfigProp)) && (ok || !reflect.DeepEqual(v, pubsubConfigProp)) {
		obj["pubsubConfig"] = pubsubConfigProp
	}
	webhookConfigProp, err := expandCloudBuildTriggerWebhookConfig(d.Get("webhook_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("webhook_config"); !isEmptyValue(reflect.ValueOf(webhookConfigProp)) && (ok || !reflect.DeepEqual(v, webhookConfigProp)) {
		obj["webhookConfig"] = webhookConfigProp
	}
	approvalConfigProp, err := expandCloudBuildTriggerApprovalConfig(d.Get("approval_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("approval_config"); !isEmptyValue(reflect.ValueOf(approvalConfigProp)) && (ok || !reflect.DeepEqual(v, approvalConfigProp)) {
		obj["approvalConfig"] = approvalConfigProp
	}
	buildProp, err := expandCloudBuildTriggerBuild(d.Get("build"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("build"); !isEmptyValue(reflect.ValueOf(buildProp)) && (ok || !reflect.DeepEqual(v, buildProp)) {
		obj["build"] = buildProp
	}

	url, err := replaceVars(d, config, "{{CloudBuildBasePath}}projects/{{project}}/locations/{{location}}/triggers")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Trigger: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Trigger: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Trigger: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// `name` is autogenerated from the api so needs to be set post-create
	triggerId, ok := res["id"]
	if !ok {
		return fmt.Errorf("Create response didn't contain id. Create may not have succeeded.")
	}
	if err := d.Set("trigger_id", triggerId.(string)); err != nil {
		return fmt.Errorf("Error setting trigger_id: %s", err)
	}

	// Store the ID now. We tried to set it before and it failed because
	// trigger_id didn't exist yet.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	// Force legacy id format for global triggers.
	id = strings.ReplaceAll(id, "/locations/global/", "/")
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Trigger %q: %#v", d.Id(), res)

	return resourceCloudBuildTriggerRead(d, meta)
}

func resourceCloudBuildTriggerRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{CloudBuildBasePath}}projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Trigger: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	// To support import with the legacy id format.
	url = strings.ReplaceAll(url, "/locations//", "/locations/global/")
	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("CloudBuildTrigger %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}

	if err := d.Set("trigger_id", flattenCloudBuildTriggerTriggerId(res["id"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("name", flattenCloudBuildTriggerName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("description", flattenCloudBuildTriggerDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("tags", flattenCloudBuildTriggerTags(res["tags"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("disabled", flattenCloudBuildTriggerDisabled(res["disabled"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("create_time", flattenCloudBuildTriggerCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("substitutions", flattenCloudBuildTriggerSubstitutions(res["substitutions"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("service_account", flattenCloudBuildTriggerServiceAccount(res["serviceAccount"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("include_build_logs", flattenCloudBuildTriggerIncludeBuildLogs(res["includeBuildLogs"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("filename", flattenCloudBuildTriggerFilename(res["filename"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("filter", flattenCloudBuildTriggerFilter(res["filter"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("git_file_source", flattenCloudBuildTriggerGitFileSource(res["gitFileSource"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("source_to_build", flattenCloudBuildTriggerSourceToBuild(res["sourceToBuild"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("ignored_files", flattenCloudBuildTriggerIgnoredFiles(res["ignoredFiles"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("included_files", flattenCloudBuildTriggerIncludedFiles(res["includedFiles"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("trigger_template", flattenCloudBuildTriggerTriggerTemplate(res["triggerTemplate"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("github", flattenCloudBuildTriggerGithub(res["github"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("pubsub_config", flattenCloudBuildTriggerPubsubConfig(res["pubsubConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("webhook_config", flattenCloudBuildTriggerWebhookConfig(res["webhookConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("approval_config", flattenCloudBuildTriggerApprovalConfig(res["approvalConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}
	if err := d.Set("build", flattenCloudBuildTriggerBuild(res["build"], d, config)); err != nil {
		return fmt.Errorf("Error reading Trigger: %s", err)
	}

	return nil
}

func resourceCloudBuildTriggerUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Trigger: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	nameProp, err := expandCloudBuildTriggerName(d.Get("name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, nameProp)) {
		obj["name"] = nameProp
	}
	descriptionProp, err := expandCloudBuildTriggerDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	tagsProp, err := expandCloudBuildTriggerTags(d.Get("tags"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("tags"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, tagsProp)) {
		obj["tags"] = tagsProp
	}
	disabledProp, err := expandCloudBuildTriggerDisabled(d.Get("disabled"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("disabled"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, disabledProp)) {
		obj["disabled"] = disabledProp
	}
	substitutionsProp, err := expandCloudBuildTriggerSubstitutions(d.Get("substitutions"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("substitutions"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, substitutionsProp)) {
		obj["substitutions"] = substitutionsProp
	}
	serviceAccountProp, err := expandCloudBuildTriggerServiceAccount(d.Get("service_account"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_account"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, serviceAccountProp)) {
		obj["serviceAccount"] = serviceAccountProp
	}
	includeBuildLogsProp, err := expandCloudBuildTriggerIncludeBuildLogs(d.Get("include_build_logs"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("include_build_logs"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, includeBuildLogsProp)) {
		obj["includeBuildLogs"] = includeBuildLogsProp
	}
	filenameProp, err := expandCloudBuildTriggerFilename(d.Get("filename"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("filename"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, filenameProp)) {
		obj["filename"] = filenameProp
	}
	filterProp, err := expandCloudBuildTriggerFilter(d.Get("filter"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("filter"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, filterProp)) {
		obj["filter"] = filterProp
	}
	gitFileSourceProp, err := expandCloudBuildTriggerGitFileSource(d.Get("git_file_source"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("git_file_source"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, gitFileSourceProp)) {
		obj["gitFileSource"] = gitFileSourceProp
	}
	sourceToBuildProp, err := expandCloudBuildTriggerSourceToBuild(d.Get("source_to_build"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("source_to_build"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, sourceToBuildProp)) {
		obj["sourceToBuild"] = sourceToBuildProp
	}
	ignoredFilesProp, err := expandCloudBuildTriggerIgnoredFiles(d.Get("ignored_files"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("ignored_files"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, ignoredFilesProp)) {
		obj["ignoredFiles"] = ignoredFilesProp
	}
	includedFilesProp, err := expandCloudBuildTriggerIncludedFiles(d.Get("included_files"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("included_files"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, includedFilesProp)) {
		obj["includedFiles"] = includedFilesProp
	}
	triggerTemplateProp, err := expandCloudBuildTriggerTriggerTemplate(d.Get("trigger_template"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("trigger_template"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, triggerTemplateProp)) {
		obj["triggerTemplate"] = triggerTemplateProp
	}
	githubProp, err := expandCloudBuildTriggerGithub(d.Get("github"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("github"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, githubProp)) {
		obj["github"] = githubProp
	}
	pubsubConfigProp, err := expandCloudBuildTriggerPubsubConfig(d.Get("pubsub_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("pubsub_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, pubsubConfigProp)) {
		obj["pubsubConfig"] = pubsubConfigProp
	}
	webhookConfigProp, err := expandCloudBuildTriggerWebhookConfig(d.Get("webhook_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("webhook_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, webhookConfigProp)) {
		obj["webhookConfig"] = webhookConfigProp
	}
	approvalConfigProp, err := expandCloudBuildTriggerApprovalConfig(d.Get("approval_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("approval_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, approvalConfigProp)) {
		obj["approvalConfig"] = approvalConfigProp
	}
	buildProp, err := expandCloudBuildTriggerBuild(d.Get("build"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("build"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, buildProp)) {
		obj["build"] = buildProp
	}

	url, err := replaceVars(d, config, "{{CloudBuildBasePath}}projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Trigger %q: %#v", d.Id(), obj)
	obj["id"] = d.Get("trigger_id")

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Trigger %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating Trigger %q: %#v", d.Id(), res)
	}

	return resourceCloudBuildTriggerRead(d, meta)
}

func resourceCloudBuildTriggerDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Trigger: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{CloudBuildBasePath}}projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Trigger %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Trigger")
	}

	log.Printf("[DEBUG] Finished deleting Trigger %q: %#v", d.Id(), res)
	return nil
}

func resourceCloudBuildTriggerImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/triggers/(?P<trigger_id>[^/]+)",
		"projects/(?P<project>[^/]+)/triggers/(?P<trigger_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<trigger_id>[^/]+)",
		"(?P<trigger_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/triggers/{{trigger_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Force legacy id format for global triggers.
	id = strings.ReplaceAll(id, "/locations//", "/")
	id = strings.ReplaceAll(id, "/locations/global/", "/")
	d.SetId(id)
	if d.Get("location") == "" {
		// Happens when imported with legacy import format.
		d.Set("location", "global")
	}

	return []*schema.ResourceData{d}, nil
}

func flattenCloudBuildTriggerTriggerId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTags(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerDisabled(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerSubstitutions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerServiceAccount(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerIncludeBuildLogs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerFilename(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerFilter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGitFileSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["path"] =
		flattenCloudBuildTriggerGitFileSourcePath(original["path"], d, config)
	transformed["uri"] =
		flattenCloudBuildTriggerGitFileSourceUri(original["uri"], d, config)
	transformed["repo_type"] =
		flattenCloudBuildTriggerGitFileSourceRepoType(original["repoType"], d, config)
	transformed["revision"] =
		flattenCloudBuildTriggerGitFileSourceRevision(original["revision"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerGitFileSourcePath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGitFileSourceUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGitFileSourceRepoType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGitFileSourceRevision(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerSourceToBuild(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["uri"] =
		flattenCloudBuildTriggerSourceToBuildUri(original["uri"], d, config)
	transformed["ref"] =
		flattenCloudBuildTriggerSourceToBuildRef(original["ref"], d, config)
	transformed["repo_type"] =
		flattenCloudBuildTriggerSourceToBuildRepoType(original["repoType"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerSourceToBuildUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerSourceToBuildRef(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerSourceToBuildRepoType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerIgnoredFiles(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerIncludedFiles(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenCloudBuildTriggerTriggerTemplateProjectId(original["projectId"], d, config)
	transformed["repo_name"] =
		flattenCloudBuildTriggerTriggerTemplateRepoName(original["repoName"], d, config)
	transformed["dir"] =
		flattenCloudBuildTriggerTriggerTemplateDir(original["dir"], d, config)
	transformed["invert_regex"] =
		flattenCloudBuildTriggerTriggerTemplateInvertRegex(original["invertRegex"], d, config)
	transformed["branch_name"] =
		flattenCloudBuildTriggerTriggerTemplateBranchName(original["branchName"], d, config)
	transformed["tag_name"] =
		flattenCloudBuildTriggerTriggerTemplateTagName(original["tagName"], d, config)
	transformed["commit_sha"] =
		flattenCloudBuildTriggerTriggerTemplateCommitSha(original["commitSha"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerTriggerTemplateProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateRepoName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateDir(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateInvertRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateBranchName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateTagName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerTriggerTemplateCommitSha(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithub(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["owner"] =
		flattenCloudBuildTriggerGithubOwner(original["owner"], d, config)
	transformed["name"] =
		flattenCloudBuildTriggerGithubName(original["name"], d, config)
	transformed["pull_request"] =
		flattenCloudBuildTriggerGithubPullRequest(original["pullRequest"], d, config)
	transformed["push"] =
		flattenCloudBuildTriggerGithubPush(original["push"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerGithubOwner(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPullRequest(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["branch"] =
		flattenCloudBuildTriggerGithubPullRequestBranch(original["branch"], d, config)
	transformed["comment_control"] =
		flattenCloudBuildTriggerGithubPullRequestCommentControl(original["commentControl"], d, config)
	transformed["invert_regex"] =
		flattenCloudBuildTriggerGithubPullRequestInvertRegex(original["invertRegex"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerGithubPullRequestBranch(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPullRequestCommentControl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPullRequestInvertRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPush(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["invert_regex"] =
		flattenCloudBuildTriggerGithubPushInvertRegex(original["invertRegex"], d, config)
	transformed["branch"] =
		flattenCloudBuildTriggerGithubPushBranch(original["branch"], d, config)
	transformed["tag"] =
		flattenCloudBuildTriggerGithubPushTag(original["tag"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerGithubPushInvertRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPushBranch(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerGithubPushTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerPubsubConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["subscription"] =
		flattenCloudBuildTriggerPubsubConfigSubscription(original["subscription"], d, config)
	transformed["topic"] =
		flattenCloudBuildTriggerPubsubConfigTopic(original["topic"], d, config)
	transformed["service_account_email"] =
		flattenCloudBuildTriggerPubsubConfigServiceAccountEmail(original["service_account_email"], d, config)
	transformed["state"] =
		flattenCloudBuildTriggerPubsubConfigState(original["state"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerPubsubConfigSubscription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerPubsubConfigTopic(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerPubsubConfigServiceAccountEmail(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerPubsubConfigState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerWebhookConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["secret"] =
		flattenCloudBuildTriggerWebhookConfigSecret(original["secret"], d, config)
	transformed["state"] =
		flattenCloudBuildTriggerWebhookConfigState(original["state"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerWebhookConfigSecret(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerWebhookConfigState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerApprovalConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	transformed := make(map[string]interface{})
	if v == nil {
		// Disabled by default, but API will not return object if value is false
		transformed["approval_required"] = false
		return []interface{}{transformed}
	}

	original := v.(map[string]interface{})
	transformed["approval_required"] = original["approvalRequired"]
	return []interface{}{transformed}
}

func flattenCloudBuildTriggerBuild(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["source"] =
		flattenCloudBuildTriggerBuildSource(original["source"], d, config)
	transformed["tags"] =
		flattenCloudBuildTriggerBuildTags(original["tags"], d, config)
	transformed["images"] =
		flattenCloudBuildTriggerBuildImages(original["images"], d, config)
	transformed["substitutions"] =
		flattenCloudBuildTriggerBuildSubstitutions(original["substitutions"], d, config)
	transformed["queue_ttl"] =
		flattenCloudBuildTriggerBuildQueueTtl(original["queueTtl"], d, config)
	transformed["logs_bucket"] =
		flattenCloudBuildTriggerBuildLogsBucket(original["logsBucket"], d, config)
	transformed["timeout"] =
		flattenCloudBuildTriggerBuildTimeout(original["timeout"], d, config)
	transformed["secret"] =
		flattenCloudBuildTriggerBuildSecret(original["secrets"], d, config)
	transformed["available_secrets"] =
		flattenCloudBuildTriggerBuildAvailableSecrets(original["availableSecrets"], d, config)
	transformed["step"] =
		flattenCloudBuildTriggerBuildStep(original["steps"], d, config)
	transformed["artifacts"] =
		flattenCloudBuildTriggerBuildArtifacts(original["artifacts"], d, config)
	transformed["options"] =
		flattenCloudBuildTriggerBuildOptions(original["options"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["storage_source"] =
		flattenCloudBuildTriggerBuildSourceStorageSource(original["storageSource"], d, config)
	transformed["repo_source"] =
		flattenCloudBuildTriggerBuildSourceRepoSource(original["repoSource"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildSourceStorageSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenCloudBuildTriggerBuildSourceStorageSourceBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenCloudBuildTriggerBuildSourceStorageSourceObject(original["object"], d, config)
	transformed["generation"] =
		flattenCloudBuildTriggerBuildSourceStorageSourceGeneration(original["generation"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildSourceStorageSourceBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceStorageSourceObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceStorageSourceGeneration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["project_id"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceProjectId(original["projectId"], d, config)
	transformed["repo_name"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceRepoName(original["repoName"], d, config)
	transformed["dir"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceDir(original["dir"], d, config)
	transformed["invert_regex"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceInvertRegex(original["invertRegex"], d, config)
	transformed["substitutions"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceSubstitutions(original["substitutions"], d, config)
	transformed["branch_name"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceBranchName(original["branchName"], d, config)
	transformed["tag_name"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceTagName(original["tagName"], d, config)
	transformed["commit_sha"] =
		flattenCloudBuildTriggerBuildSourceRepoSourceCommitSha(original["commitSha"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildSourceRepoSourceProjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceRepoName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceDir(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceInvertRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceSubstitutions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceBranchName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceTagName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSourceRepoSourceCommitSha(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildTags(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildImages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSubstitutions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildQueueTtl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildLogsBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSecret(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"kms_key_name": flattenCloudBuildTriggerBuildSecretKmsKeyName(original["kmsKeyName"], d, config),
			"secret_env":   flattenCloudBuildTriggerBuildSecretSecretEnv(original["secretEnv"], d, config),
		})
	}
	return transformed
}
func flattenCloudBuildTriggerBuildSecretKmsKeyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildSecretSecretEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildAvailableSecrets(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["secret_manager"] =
		flattenCloudBuildTriggerBuildAvailableSecretsSecretManager(original["secretManager"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildAvailableSecretsSecretManager(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"version_name": flattenCloudBuildTriggerBuildAvailableSecretsSecretManagerVersionName(original["versionName"], d, config),
			"env":          flattenCloudBuildTriggerBuildAvailableSecretsSecretManagerEnv(original["env"], d, config),
		})
	}
	return transformed
}
func flattenCloudBuildTriggerBuildAvailableSecretsSecretManagerVersionName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildAvailableSecretsSecretManagerEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStep(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":       flattenCloudBuildTriggerBuildStepName(original["name"], d, config),
			"args":       flattenCloudBuildTriggerBuildStepArgs(original["args"], d, config),
			"env":        flattenCloudBuildTriggerBuildStepEnv(original["env"], d, config),
			"id":         flattenCloudBuildTriggerBuildStepId(original["id"], d, config),
			"entrypoint": flattenCloudBuildTriggerBuildStepEntrypoint(original["entrypoint"], d, config),
			"dir":        flattenCloudBuildTriggerBuildStepDir(original["dir"], d, config),
			"secret_env": flattenCloudBuildTriggerBuildStepSecretEnv(original["secretEnv"], d, config),
			"timeout":    flattenCloudBuildTriggerBuildStepTimeout(original["timeout"], d, config),
			"timing":     flattenCloudBuildTriggerBuildStepTiming(original["timing"], d, config),
			"volumes":    flattenCloudBuildTriggerBuildStepVolumes(original["volumes"], d, config),
			"wait_for":   flattenCloudBuildTriggerBuildStepWaitFor(original["waitFor"], d, config),
		})
	}
	return transformed
}
func flattenCloudBuildTriggerBuildStepName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepArgs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepEntrypoint(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepDir(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepSecretEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepTiming(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepVolumes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name": flattenCloudBuildTriggerBuildStepVolumesName(original["name"], d, config),
			"path": flattenCloudBuildTriggerBuildStepVolumesPath(original["path"], d, config),
		})
	}
	return transformed
}
func flattenCloudBuildTriggerBuildStepVolumesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepVolumesPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildStepWaitFor(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildArtifacts(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["images"] =
		flattenCloudBuildTriggerBuildArtifactsImages(original["images"], d, config)
	transformed["objects"] =
		flattenCloudBuildTriggerBuildArtifactsObjects(original["objects"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildArtifactsImages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildArtifactsObjects(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["location"] =
		flattenCloudBuildTriggerBuildArtifactsObjectsLocation(original["location"], d, config)
	transformed["paths"] =
		flattenCloudBuildTriggerBuildArtifactsObjectsPaths(original["paths"], d, config)
	transformed["timing"] =
		flattenCloudBuildTriggerBuildArtifactsObjectsTiming(original["timing"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildArtifactsObjectsLocation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildArtifactsObjectsPaths(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildArtifactsObjectsTiming(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["start_time"] =
		flattenCloudBuildTriggerBuildArtifactsObjectsTimingStartTime(original["startTime"], d, config)
	transformed["end_time"] =
		flattenCloudBuildTriggerBuildArtifactsObjectsTimingEndTime(original["endTime"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildArtifactsObjectsTimingStartTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildArtifactsObjectsTimingEndTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["source_provenance_hash"] =
		flattenCloudBuildTriggerBuildOptionsSourceProvenanceHash(original["sourceProvenanceHash"], d, config)
	transformed["requested_verify_option"] =
		flattenCloudBuildTriggerBuildOptionsRequestedVerifyOption(original["requestedVerifyOption"], d, config)
	transformed["machine_type"] =
		flattenCloudBuildTriggerBuildOptionsMachineType(original["machineType"], d, config)
	transformed["disk_size_gb"] =
		flattenCloudBuildTriggerBuildOptionsDiskSizeGb(original["diskSizeGb"], d, config)
	transformed["substitution_option"] =
		flattenCloudBuildTriggerBuildOptionsSubstitutionOption(original["substitutionOption"], d, config)
	transformed["dynamic_substitutions"] =
		flattenCloudBuildTriggerBuildOptionsDynamicSubstitutions(original["dynamicSubstitutions"], d, config)
	transformed["log_streaming_option"] =
		flattenCloudBuildTriggerBuildOptionsLogStreamingOption(original["logStreamingOption"], d, config)
	transformed["worker_pool"] =
		flattenCloudBuildTriggerBuildOptionsWorkerPool(original["workerPool"], d, config)
	transformed["logging"] =
		flattenCloudBuildTriggerBuildOptionsLogging(original["logging"], d, config)
	transformed["env"] =
		flattenCloudBuildTriggerBuildOptionsEnv(original["env"], d, config)
	transformed["secret_env"] =
		flattenCloudBuildTriggerBuildOptionsSecretEnv(original["secretEnv"], d, config)
	transformed["volumes"] =
		flattenCloudBuildTriggerBuildOptionsVolumes(original["volumes"], d, config)
	return []interface{}{transformed}
}
func flattenCloudBuildTriggerBuildOptionsSourceProvenanceHash(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsRequestedVerifyOption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsMachineType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsDiskSizeGb(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenCloudBuildTriggerBuildOptionsSubstitutionOption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsDynamicSubstitutions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsLogStreamingOption(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsWorkerPool(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsLogging(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsSecretEnv(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsVolumes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name": flattenCloudBuildTriggerBuildOptionsVolumesName(original["name"], d, config),
			"path": flattenCloudBuildTriggerBuildOptionsVolumesPath(original["path"], d, config),
		})
	}
	return transformed
}
func flattenCloudBuildTriggerBuildOptionsVolumesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudBuildTriggerBuildOptionsVolumesPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandCloudBuildTriggerName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTags(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerDisabled(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerSubstitutions(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudBuildTriggerServiceAccount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerIncludeBuildLogs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerFilename(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerFilter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGitFileSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPath, err := expandCloudBuildTriggerGitFileSourcePath(original["path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
		transformed["path"] = transformedPath
	}

	transformedUri, err := expandCloudBuildTriggerGitFileSourceUri(original["uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUri); val.IsValid() && !isEmptyValue(val) {
		transformed["uri"] = transformedUri
	}

	transformedRepoType, err := expandCloudBuildTriggerGitFileSourceRepoType(original["repo_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoType); val.IsValid() && !isEmptyValue(val) {
		transformed["repoType"] = transformedRepoType
	}

	transformedRevision, err := expandCloudBuildTriggerGitFileSourceRevision(original["revision"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRevision); val.IsValid() && !isEmptyValue(val) {
		transformed["revision"] = transformedRevision
	}

	return transformed, nil
}

func expandCloudBuildTriggerGitFileSourcePath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGitFileSourceUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGitFileSourceRepoType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGitFileSourceRevision(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerSourceToBuild(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedUri, err := expandCloudBuildTriggerSourceToBuildUri(original["uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUri); val.IsValid() && !isEmptyValue(val) {
		transformed["uri"] = transformedUri
	}

	transformedRef, err := expandCloudBuildTriggerSourceToBuildRef(original["ref"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRef); val.IsValid() && !isEmptyValue(val) {
		transformed["ref"] = transformedRef
	}

	transformedRepoType, err := expandCloudBuildTriggerSourceToBuildRepoType(original["repo_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoType); val.IsValid() && !isEmptyValue(val) {
		transformed["repoType"] = transformedRepoType
	}

	return transformed, nil
}

func expandCloudBuildTriggerSourceToBuildUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerSourceToBuildRef(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerSourceToBuildRepoType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerIgnoredFiles(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerIncludedFiles(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandCloudBuildTriggerTriggerTemplateProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedRepoName, err := expandCloudBuildTriggerTriggerTemplateRepoName(original["repo_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoName); val.IsValid() && !isEmptyValue(val) {
		transformed["repoName"] = transformedRepoName
	}

	transformedDir, err := expandCloudBuildTriggerTriggerTemplateDir(original["dir"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDir); val.IsValid() && !isEmptyValue(val) {
		transformed["dir"] = transformedDir
	}

	transformedInvertRegex, err := expandCloudBuildTriggerTriggerTemplateInvertRegex(original["invert_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInvertRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["invertRegex"] = transformedInvertRegex
	}

	transformedBranchName, err := expandCloudBuildTriggerTriggerTemplateBranchName(original["branch_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBranchName); val.IsValid() && !isEmptyValue(val) {
		transformed["branchName"] = transformedBranchName
	}

	transformedTagName, err := expandCloudBuildTriggerTriggerTemplateTagName(original["tag_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTagName); val.IsValid() && !isEmptyValue(val) {
		transformed["tagName"] = transformedTagName
	}

	transformedCommitSha, err := expandCloudBuildTriggerTriggerTemplateCommitSha(original["commit_sha"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommitSha); val.IsValid() && !isEmptyValue(val) {
		transformed["commitSha"] = transformedCommitSha
	}

	return transformed, nil
}

func expandCloudBuildTriggerTriggerTemplateProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateRepoName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateDir(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateInvertRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateBranchName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateTagName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerTriggerTemplateCommitSha(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithub(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedOwner, err := expandCloudBuildTriggerGithubOwner(original["owner"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOwner); val.IsValid() && !isEmptyValue(val) {
		transformed["owner"] = transformedOwner
	}

	transformedName, err := expandCloudBuildTriggerGithubName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	transformedPullRequest, err := expandCloudBuildTriggerGithubPullRequest(original["pull_request"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPullRequest); val.IsValid() && !isEmptyValue(val) {
		transformed["pullRequest"] = transformedPullRequest
	}

	transformedPush, err := expandCloudBuildTriggerGithubPush(original["push"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPush); val.IsValid() && !isEmptyValue(val) {
		transformed["push"] = transformedPush
	}

	return transformed, nil
}

func expandCloudBuildTriggerGithubOwner(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPullRequest(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBranch, err := expandCloudBuildTriggerGithubPullRequestBranch(original["branch"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBranch); val.IsValid() && !isEmptyValue(val) {
		transformed["branch"] = transformedBranch
	}

	transformedCommentControl, err := expandCloudBuildTriggerGithubPullRequestCommentControl(original["comment_control"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommentControl); val.IsValid() && !isEmptyValue(val) {
		transformed["commentControl"] = transformedCommentControl
	}

	transformedInvertRegex, err := expandCloudBuildTriggerGithubPullRequestInvertRegex(original["invert_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInvertRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["invertRegex"] = transformedInvertRegex
	}

	return transformed, nil
}

func expandCloudBuildTriggerGithubPullRequestBranch(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPullRequestCommentControl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPullRequestInvertRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPush(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInvertRegex, err := expandCloudBuildTriggerGithubPushInvertRegex(original["invert_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInvertRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["invertRegex"] = transformedInvertRegex
	}

	transformedBranch, err := expandCloudBuildTriggerGithubPushBranch(original["branch"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBranch); val.IsValid() && !isEmptyValue(val) {
		transformed["branch"] = transformedBranch
	}

	transformedTag, err := expandCloudBuildTriggerGithubPushTag(original["tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTag); val.IsValid() && !isEmptyValue(val) {
		transformed["tag"] = transformedTag
	}

	return transformed, nil
}

func expandCloudBuildTriggerGithubPushInvertRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPushBranch(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerGithubPushTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerPubsubConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSubscription, err := expandCloudBuildTriggerPubsubConfigSubscription(original["subscription"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubscription); val.IsValid() && !isEmptyValue(val) {
		transformed["subscription"] = transformedSubscription
	}

	transformedTopic, err := expandCloudBuildTriggerPubsubConfigTopic(original["topic"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTopic); val.IsValid() && !isEmptyValue(val) {
		transformed["topic"] = transformedTopic
	}

	transformedServiceAccountEmail, err := expandCloudBuildTriggerPubsubConfigServiceAccountEmail(original["service_account_email"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedServiceAccountEmail); val.IsValid() && !isEmptyValue(val) {
		transformed["service_account_email"] = transformedServiceAccountEmail
	}

	transformedState, err := expandCloudBuildTriggerPubsubConfigState(original["state"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedState); val.IsValid() && !isEmptyValue(val) {
		transformed["state"] = transformedState
	}

	return transformed, nil
}

func expandCloudBuildTriggerPubsubConfigSubscription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerPubsubConfigTopic(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerPubsubConfigServiceAccountEmail(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerPubsubConfigState(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerWebhookConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSecret, err := expandCloudBuildTriggerWebhookConfigSecret(original["secret"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecret); val.IsValid() && !isEmptyValue(val) {
		transformed["secret"] = transformedSecret
	}

	transformedState, err := expandCloudBuildTriggerWebhookConfigState(original["state"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedState); val.IsValid() && !isEmptyValue(val) {
		transformed["state"] = transformedState
	}

	return transformed, nil
}

func expandCloudBuildTriggerWebhookConfigSecret(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerWebhookConfigState(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerApprovalConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedApprovalRequired, err := expandCloudBuildTriggerApprovalConfigApprovalRequired(original["approval_required"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedApprovalRequired); val.IsValid() && !isEmptyValue(val) {
		transformed["approvalRequired"] = transformedApprovalRequired
	}

	return transformed, nil
}

func expandCloudBuildTriggerApprovalConfigApprovalRequired(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuild(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSource, err := expandCloudBuildTriggerBuildSource(original["source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSource); val.IsValid() && !isEmptyValue(val) {
		transformed["source"] = transformedSource
	}

	transformedTags, err := expandCloudBuildTriggerBuildTags(original["tags"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTags); val.IsValid() && !isEmptyValue(val) {
		transformed["tags"] = transformedTags
	}

	transformedImages, err := expandCloudBuildTriggerBuildImages(original["images"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedImages); val.IsValid() && !isEmptyValue(val) {
		transformed["images"] = transformedImages
	}

	transformedSubstitutions, err := expandCloudBuildTriggerBuildSubstitutions(original["substitutions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubstitutions); val.IsValid() && !isEmptyValue(val) {
		transformed["substitutions"] = transformedSubstitutions
	}

	transformedQueueTtl, err := expandCloudBuildTriggerBuildQueueTtl(original["queue_ttl"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedQueueTtl); val.IsValid() && !isEmptyValue(val) {
		transformed["queueTtl"] = transformedQueueTtl
	}

	transformedLogsBucket, err := expandCloudBuildTriggerBuildLogsBucket(original["logs_bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLogsBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["logsBucket"] = transformedLogsBucket
	}

	transformedTimeout, err := expandCloudBuildTriggerBuildTimeout(original["timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["timeout"] = transformedTimeout
	}

	transformedSecret, err := expandCloudBuildTriggerBuildSecret(original["secret"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecret); val.IsValid() && !isEmptyValue(val) {
		transformed["secrets"] = transformedSecret
	}

	transformedAvailableSecrets, err := expandCloudBuildTriggerBuildAvailableSecrets(original["available_secrets"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAvailableSecrets); val.IsValid() && !isEmptyValue(val) {
		transformed["availableSecrets"] = transformedAvailableSecrets
	}

	transformedStep, err := expandCloudBuildTriggerBuildStep(original["step"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStep); val.IsValid() && !isEmptyValue(val) {
		transformed["steps"] = transformedStep
	}

	transformedArtifacts, err := expandCloudBuildTriggerBuildArtifacts(original["artifacts"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifacts); val.IsValid() && !isEmptyValue(val) {
		transformed["artifacts"] = transformedArtifacts
	}

	transformedOptions, err := expandCloudBuildTriggerBuildOptions(original["options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["options"] = transformedOptions
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedStorageSource, err := expandCloudBuildTriggerBuildSourceStorageSource(original["storage_source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStorageSource); val.IsValid() && !isEmptyValue(val) {
		transformed["storageSource"] = transformedStorageSource
	}

	transformedRepoSource, err := expandCloudBuildTriggerBuildSourceRepoSource(original["repo_source"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoSource); val.IsValid() && !isEmptyValue(val) {
		transformed["repoSource"] = transformedRepoSource
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildSourceStorageSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandCloudBuildTriggerBuildSourceStorageSourceBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandCloudBuildTriggerBuildSourceStorageSourceObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGeneration, err := expandCloudBuildTriggerBuildSourceStorageSourceGeneration(original["generation"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGeneration); val.IsValid() && !isEmptyValue(val) {
		transformed["generation"] = transformedGeneration
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildSourceStorageSourceBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceStorageSourceObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceStorageSourceGeneration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedProjectId, err := expandCloudBuildTriggerBuildSourceRepoSourceProjectId(original["project_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["projectId"] = transformedProjectId
	}

	transformedRepoName, err := expandCloudBuildTriggerBuildSourceRepoSourceRepoName(original["repo_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRepoName); val.IsValid() && !isEmptyValue(val) {
		transformed["repoName"] = transformedRepoName
	}

	transformedDir, err := expandCloudBuildTriggerBuildSourceRepoSourceDir(original["dir"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDir); val.IsValid() && !isEmptyValue(val) {
		transformed["dir"] = transformedDir
	}

	transformedInvertRegex, err := expandCloudBuildTriggerBuildSourceRepoSourceInvertRegex(original["invert_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInvertRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["invertRegex"] = transformedInvertRegex
	}

	transformedSubstitutions, err := expandCloudBuildTriggerBuildSourceRepoSourceSubstitutions(original["substitutions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubstitutions); val.IsValid() && !isEmptyValue(val) {
		transformed["substitutions"] = transformedSubstitutions
	}

	transformedBranchName, err := expandCloudBuildTriggerBuildSourceRepoSourceBranchName(original["branch_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBranchName); val.IsValid() && !isEmptyValue(val) {
		transformed["branchName"] = transformedBranchName
	}

	transformedTagName, err := expandCloudBuildTriggerBuildSourceRepoSourceTagName(original["tag_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTagName); val.IsValid() && !isEmptyValue(val) {
		transformed["tagName"] = transformedTagName
	}

	transformedCommitSha, err := expandCloudBuildTriggerBuildSourceRepoSourceCommitSha(original["commit_sha"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommitSha); val.IsValid() && !isEmptyValue(val) {
		transformed["commitSha"] = transformedCommitSha
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceProjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceRepoName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceDir(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceInvertRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceSubstitutions(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceBranchName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceTagName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSourceRepoSourceCommitSha(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildTags(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildImages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSubstitutions(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudBuildTriggerBuildQueueTtl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildLogsBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSecret(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedKmsKeyName, err := expandCloudBuildTriggerBuildSecretKmsKeyName(original["kms_key_name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedKmsKeyName); val.IsValid() && !isEmptyValue(val) {
			transformed["kmsKeyName"] = transformedKmsKeyName
		}

		transformedSecretEnv, err := expandCloudBuildTriggerBuildSecretSecretEnv(original["secret_env"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSecretEnv); val.IsValid() && !isEmptyValue(val) {
			transformed["secretEnv"] = transformedSecretEnv
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudBuildTriggerBuildSecretKmsKeyName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildSecretSecretEnv(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandCloudBuildTriggerBuildAvailableSecrets(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSecretManager, err := expandCloudBuildTriggerBuildAvailableSecretsSecretManager(original["secret_manager"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecretManager); val.IsValid() && !isEmptyValue(val) {
		transformed["secretManager"] = transformedSecretManager
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildAvailableSecretsSecretManager(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedVersionName, err := expandCloudBuildTriggerBuildAvailableSecretsSecretManagerVersionName(original["version_name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVersionName); val.IsValid() && !isEmptyValue(val) {
			transformed["versionName"] = transformedVersionName
		}

		transformedEnv, err := expandCloudBuildTriggerBuildAvailableSecretsSecretManagerEnv(original["env"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEnv); val.IsValid() && !isEmptyValue(val) {
			transformed["env"] = transformedEnv
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudBuildTriggerBuildAvailableSecretsSecretManagerVersionName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildAvailableSecretsSecretManagerEnv(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStep(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandCloudBuildTriggerBuildStepName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedArgs, err := expandCloudBuildTriggerBuildStepArgs(original["args"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedArgs); val.IsValid() && !isEmptyValue(val) {
			transformed["args"] = transformedArgs
		}

		transformedEnv, err := expandCloudBuildTriggerBuildStepEnv(original["env"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEnv); val.IsValid() && !isEmptyValue(val) {
			transformed["env"] = transformedEnv
		}

		transformedId, err := expandCloudBuildTriggerBuildStepId(original["id"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedId); val.IsValid() && !isEmptyValue(val) {
			transformed["id"] = transformedId
		}

		transformedEntrypoint, err := expandCloudBuildTriggerBuildStepEntrypoint(original["entrypoint"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEntrypoint); val.IsValid() && !isEmptyValue(val) {
			transformed["entrypoint"] = transformedEntrypoint
		}

		transformedDir, err := expandCloudBuildTriggerBuildStepDir(original["dir"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDir); val.IsValid() && !isEmptyValue(val) {
			transformed["dir"] = transformedDir
		}

		transformedSecretEnv, err := expandCloudBuildTriggerBuildStepSecretEnv(original["secret_env"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSecretEnv); val.IsValid() && !isEmptyValue(val) {
			transformed["secretEnv"] = transformedSecretEnv
		}

		transformedTimeout, err := expandCloudBuildTriggerBuildStepTimeout(original["timeout"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTimeout); val.IsValid() && !isEmptyValue(val) {
			transformed["timeout"] = transformedTimeout
		}

		transformedTiming, err := expandCloudBuildTriggerBuildStepTiming(original["timing"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTiming); val.IsValid() && !isEmptyValue(val) {
			transformed["timing"] = transformedTiming
		}

		transformedVolumes, err := expandCloudBuildTriggerBuildStepVolumes(original["volumes"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVolumes); val.IsValid() && !isEmptyValue(val) {
			transformed["volumes"] = transformedVolumes
		}

		transformedWaitFor, err := expandCloudBuildTriggerBuildStepWaitFor(original["wait_for"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedWaitFor); val.IsValid() && !isEmptyValue(val) {
			transformed["waitFor"] = transformedWaitFor
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudBuildTriggerBuildStepName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepArgs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepEnv(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepEntrypoint(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepDir(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepSecretEnv(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepTiming(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepVolumes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandCloudBuildTriggerBuildStepVolumesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedPath, err := expandCloudBuildTriggerBuildStepVolumesPath(original["path"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
			transformed["path"] = transformedPath
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudBuildTriggerBuildStepVolumesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepVolumesPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildStepWaitFor(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildArtifacts(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedImages, err := expandCloudBuildTriggerBuildArtifactsImages(original["images"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedImages); val.IsValid() && !isEmptyValue(val) {
		transformed["images"] = transformedImages
	}

	transformedObjects, err := expandCloudBuildTriggerBuildArtifactsObjects(original["objects"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObjects); val.IsValid() && !isEmptyValue(val) {
		transformed["objects"] = transformedObjects
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildArtifactsImages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildArtifactsObjects(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedLocation, err := expandCloudBuildTriggerBuildArtifactsObjectsLocation(original["location"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocation); val.IsValid() && !isEmptyValue(val) {
		transformed["location"] = transformedLocation
	}

	transformedPaths, err := expandCloudBuildTriggerBuildArtifactsObjectsPaths(original["paths"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPaths); val.IsValid() && !isEmptyValue(val) {
		transformed["paths"] = transformedPaths
	}

	transformedTiming, err := expandCloudBuildTriggerBuildArtifactsObjectsTiming(original["timing"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTiming); val.IsValid() && !isEmptyValue(val) {
		transformed["timing"] = transformedTiming
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildArtifactsObjectsLocation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildArtifactsObjectsPaths(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildArtifactsObjectsTiming(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedStartTime, err := expandCloudBuildTriggerBuildArtifactsObjectsTimingStartTime(original["start_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStartTime); val.IsValid() && !isEmptyValue(val) {
		transformed["startTime"] = transformedStartTime
	}

	transformedEndTime, err := expandCloudBuildTriggerBuildArtifactsObjectsTimingEndTime(original["end_time"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEndTime); val.IsValid() && !isEmptyValue(val) {
		transformed["endTime"] = transformedEndTime
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildArtifactsObjectsTimingStartTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildArtifactsObjectsTimingEndTime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSourceProvenanceHash, err := expandCloudBuildTriggerBuildOptionsSourceProvenanceHash(original["source_provenance_hash"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceProvenanceHash); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceProvenanceHash"] = transformedSourceProvenanceHash
	}

	transformedRequestedVerifyOption, err := expandCloudBuildTriggerBuildOptionsRequestedVerifyOption(original["requested_verify_option"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequestedVerifyOption); val.IsValid() && !isEmptyValue(val) {
		transformed["requestedVerifyOption"] = transformedRequestedVerifyOption
	}

	transformedMachineType, err := expandCloudBuildTriggerBuildOptionsMachineType(original["machine_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMachineType); val.IsValid() && !isEmptyValue(val) {
		transformed["machineType"] = transformedMachineType
	}

	transformedDiskSizeGb, err := expandCloudBuildTriggerBuildOptionsDiskSizeGb(original["disk_size_gb"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskSizeGb); val.IsValid() && !isEmptyValue(val) {
		transformed["diskSizeGb"] = transformedDiskSizeGb
	}

	transformedSubstitutionOption, err := expandCloudBuildTriggerBuildOptionsSubstitutionOption(original["substitution_option"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubstitutionOption); val.IsValid() && !isEmptyValue(val) {
		transformed["substitutionOption"] = transformedSubstitutionOption
	}

	transformedDynamicSubstitutions, err := expandCloudBuildTriggerBuildOptionsDynamicSubstitutions(original["dynamic_substitutions"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["dynamicSubstitutions"] = transformedDynamicSubstitutions
	}

	transformedLogStreamingOption, err := expandCloudBuildTriggerBuildOptionsLogStreamingOption(original["log_streaming_option"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLogStreamingOption); val.IsValid() && !isEmptyValue(val) {
		transformed["logStreamingOption"] = transformedLogStreamingOption
	}

	transformedWorkerPool, err := expandCloudBuildTriggerBuildOptionsWorkerPool(original["worker_pool"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedWorkerPool); val.IsValid() && !isEmptyValue(val) {
		transformed["workerPool"] = transformedWorkerPool
	}

	transformedLogging, err := expandCloudBuildTriggerBuildOptionsLogging(original["logging"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLogging); val.IsValid() && !isEmptyValue(val) {
		transformed["logging"] = transformedLogging
	}

	transformedEnv, err := expandCloudBuildTriggerBuildOptionsEnv(original["env"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEnv); val.IsValid() && !isEmptyValue(val) {
		transformed["env"] = transformedEnv
	}

	transformedSecretEnv, err := expandCloudBuildTriggerBuildOptionsSecretEnv(original["secret_env"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecretEnv); val.IsValid() && !isEmptyValue(val) {
		transformed["secretEnv"] = transformedSecretEnv
	}

	transformedVolumes, err := expandCloudBuildTriggerBuildOptionsVolumes(original["volumes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVolumes); val.IsValid() && !isEmptyValue(val) {
		transformed["volumes"] = transformedVolumes
	}

	return transformed, nil
}

func expandCloudBuildTriggerBuildOptionsSourceProvenanceHash(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsRequestedVerifyOption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsMachineType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsDiskSizeGb(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsSubstitutionOption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsDynamicSubstitutions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsLogStreamingOption(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsWorkerPool(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsLogging(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsEnv(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsSecretEnv(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsVolumes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandCloudBuildTriggerBuildOptionsVolumesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedPath, err := expandCloudBuildTriggerBuildOptionsVolumesPath(original["path"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
			transformed["path"] = transformedPath
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandCloudBuildTriggerBuildOptionsVolumesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudBuildTriggerBuildOptionsVolumesPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceCloudBuildTriggerUpgradeV1(_ context.Context, rawState map[string]interface{}, meta interface{}) (map[string]interface{}, error) {
	log.Printf("[DEBUG] Attributes before migration: %#v", rawState)
	// Versions 0 and 1 didn't support location. Default them to global.
	rawState["location"] = "global"
	log.Printf("[DEBUG] Attributes after migration: %#v", rawState)
	return rawState, nil
}

func resourceCloudBuildTriggerResourceV1() *schema.Resource {
	// Cloud Build Triggers started with V1 since its beginnings.
	return resourceCloudBuildTriggerResourceV0()
}

func resourceCloudBuildTriggerUpgradeV0(_ context.Context, rawState map[string]interface{}, meta interface{}) (map[string]interface{}, error) {
	// Do nothing as V0 and V1 are exactly the same.
	return rawState, nil
}

func resourceCloudBuildTriggerResourceV0() *schema.Resource {
	return &schema.Resource{
		Create: resourceCloudBuildTriggerCreate,
		Read:   resourceCloudBuildTriggerRead,
		Update: resourceCloudBuildTriggerUpdate,
		Delete: resourceCloudBuildTriggerDelete,

		Importer: &schema.ResourceImporter{
			State: resourceCloudBuildTriggerImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		SchemaVersion: 1,
		CustomizeDiff: stepTimeoutCustomizeDiff,

		Schema: map[string]*schema.Schema{
			"approval_config": {
				Type:     schema.TypeList,
				Computed: true,
				Optional: true,
				Description: `Configuration for manual approval to start a build invocation of this BuildTrigger. 
Builds created by this trigger will require approval before they execute. 
Any user with a Cloud Build Approver role for the project can approve a build.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"approval_required": {
							Type:     schema.TypeBool,
							Optional: true,
							Description: `Whether or not approval is needed. If this is set on a build, it will become pending when run, 
and will need to be explicitly approved to start.`,
							Default: false,
						},
					},
				},
			},
			"build": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Contents of the build template. Either a filename or build template must be provided.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"step": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `The operations to be performed on the workspace.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"name": {
										Type:     schema.TypeString,
										Required: true,
										Description: `The name of the container image that will run this particular build step.
If the image is available in the host's Docker daemon's cache, it will be
run directly. If not, the host will attempt to pull the image first, using
the builder service account's credentials if necessary.
The Docker daemon's cache will already have the latest versions of all of
the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders 
for images and examples).
The Docker daemon will also have cached many of the layers for some popular
images, like "ubuntu", "debian", but they will be refreshed at the time
you attempt to use them.
If you built an image in a previous build step, it will be stored in the
host's Docker daemon's cache and is available to use as the name for a
later build step.`,
									},
									"args": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of arguments that will be presented to the step when it is started.
If the image used to run the step's container has an entrypoint, the args
are used as arguments to that entrypoint. If the image does not define an
entrypoint, the first element in args is used as the entrypoint, and the
remainder will be used as arguments.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"dir": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Working directory to use when running this step's container.
If this value is a relative path, it is relative to the build's working
directory. If this value is absolute, it may be outside the build's working
directory, in which case the contents of the path may not be persisted
across build step executions, unless a 'volume' for that path is specified.
If the build specifies a 'RepoSource' with 'dir' and a step with a
'dir',
which specifies an absolute path, the 'RepoSource' 'dir' is ignored
for the step's execution.`,
									},
									"entrypoint": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Entrypoint to be used instead of the build step image's
default entrypoint.
If unset, the image's default entrypoint is used`,
									},
									"env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of environment variable definitions to be used when
running a step.
The elements are of the form "KEY=VALUE" for the environment variable
"KEY" being given the value "VALUE".`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"id": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Unique identifier for this build step, used in 'wait_for' to
reference this build step as a dependency.`,
									},
									"secret_env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of environment variables which are encrypted using
a Cloud Key
Management Service crypto key. These values must be specified in
the build's 'Secret'.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"timeout": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Time limit for executing this build step. If not defined,
the step has no
time limit and will be allowed to continue to run until either it
completes or the build itself times out.`,
									},
									"timing": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Output only. Stores timing information for executing this
build step.`,
									},
									"volumes": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `List of volumes to mount into the build step.
Each volume is created as an empty volume prior to execution of the
build step. Upon completion of the build, volumes and their contents
are discarded.
Using a named volume in only one step is not valid as it is
indicative of a build request with an incorrect configuration.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"name": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Name of the volume to mount.
Volume names must be unique per build step and must be valid names for
Docker volumes. Each named volume must be used by at least two build steps.`,
												},
												"path": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Path at which to mount the volume.
Paths must be absolute and cannot conflict with other volume paths on
the same build step or with certain reserved volume paths.`,
												},
											},
										},
									},
									"wait_for": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `The ID(s) of the step(s) that this build step depends on.
This build step will not start until all the build steps in 'wait_for'
have completed successfully. If 'wait_for' is empty, this build step
will start when all previous build steps in the 'Build.Steps' list
have completed successfully.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
						},
						"artifacts": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Artifacts produced by the build that should be uploaded upon successful completion of all build steps.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"images": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of images to be pushed upon the successful completion of all build steps.
The images will be pushed using the builder service account's credentials.
The digests of the pushed images will be stored in the Build resource's results field.
If any of the images fail to be pushed, the build is marked FAILURE.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"objects": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
Files in the workspace matching specified paths globs will be uploaded to the
Cloud Storage location using the builder service account's credentials.
The location and generation of the uploaded objects will be stored in the Build resource's results field.
If any objects fail to be pushed, the build is marked FAILURE.`,
										MaxItems: 1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"location": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
this location as a prefix.`,
												},
												"paths": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `Path globs used to match files in the build's workspace.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"timing": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Output only. Stores timing information for pushing all artifact objects.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"end_time": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `End of time span.
A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
															},
															"start_time": {
																Type:     schema.TypeString,
																Optional: true,
																Description: `Start of time span.
A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".`,
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						"available_secrets": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secrets and secret environment variables.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"secret_manager": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `Pairs a secret environment variable with a SecretVersion in Secret Manager.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"env": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Environment variable name to associate with the secret. Secret environment
variables must be unique across all of a build's secrets, and must be used
by at least one build step.`,
												},
												"version_name": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*`,
												},
											},
										},
									},
								},
							},
						},
						"images": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `A list of images to be pushed upon the successful completion of all build steps.
The images are pushed using the builder service account's credentials.
The digests of the pushed images will be stored in the Build resource's results field.
If any of the images fail to be pushed, the build status is marked FAILURE.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"logs_bucket": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Google Cloud Storage bucket where logs should be written. 
Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.`,
						},
						"options": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Special options for this build.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"disk_size_gb": {
										Type:     schema.TypeInt,
										Optional: true,
										Description: `Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
some of the space will be used by the operating system and build utilities.
Also note that this is the minimum disk size that will be allocated for the build --
the build may run with a larger disk than requested. At present, the maximum disk size
is 1000GB; builds that request more than the maximum are rejected with an error.`,
									},
									"dynamic_substitutions": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Option to specify whether or not to apply bash style string operations to the substitutions.
NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.`,
									},
									"env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of global environment variable definitions that will exist for all build steps
in this build. If a variable is defined in both globally and in a build step,
the variable will use the build step value.
The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"log_streaming_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF", ""}),
										Description:  `Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"]`,
									},
									"logging": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE", ""}),
										Description:  `Option to specify the logging mode, which determines if and where build logs are stored. Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE"]`,
									},
									"machine_type": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32", ""}),
										Description:  `Compute Engine machine type on which to run the build. Possible values: ["UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32"]`,
									},
									"requested_verify_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"NOT_VERIFIED", "VERIFIED", ""}),
										Description:  `Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"]`,
									},
									"secret_env": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `A list of global environment variables, which are encrypted using a Cloud Key Management
Service crypto key. These values must be specified in the build's Secret. These variables
will be available to all build steps in this build.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"source_provenance_hash": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"]`,
										Elem: &schema.Schema{
											Type:         schema.TypeString,
											ValidateFunc: validateEnum([]string{"NONE", "SHA256", "MD5"}),
										},
									},
									"substitution_option": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"MUST_MATCH", "ALLOW_LOOSE", ""}),
										Description: `Option to specify behavior when there is an error in the substitution checks.
NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]`,
									},
									"volumes": {
										Type:     schema.TypeList,
										Optional: true,
										Description: `Global list of volumes to mount for ALL build steps
Each volume is created as an empty volume prior to starting the build process.
Upon completion of the build, volumes and their contents are discarded. Global
volume names and paths cannot conflict with the volumes defined a build step.
Using a global volume in a build with only one step is not valid as it is indicative
of a build request with an incorrect configuration.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Name of the volume to mount.
Volume names must be unique per build step and must be valid names for Docker volumes.
Each named volume must be used by at least two build steps.`,
												},
												"path": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Path at which to mount the volume.
Paths must be absolute and cannot conflict with other volume paths on the same
build step or with certain reserved volume paths.`,
												},
											},
										},
									},
									"worker_pool": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
This field is experimental.`,
									},
								},
							},
						},
						"queue_ttl": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `TTL in queue for this build. If provided and the build is enqueued longer than this value, 
the build will expire and the build status will be EXPIRED.
The TTL starts ticking from createTime.
A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".`,
						},
						"secret": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Secrets to decrypt using Cloud Key Management Service.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"kms_key_name": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Cloud KMS key name to use to decrypt these envs.`,
									},
									"secret_env": {
										Type:     schema.TypeMap,
										Optional: true,
										Description: `Map of environment variable name to its encrypted value.
Secret environment variables must be unique across all of a build's secrets, 
and must be used by at least one build step. Values can be at most 64 KB in size. 
There can be at most 100 secret values across all of a build's secrets.`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
								},
							},
						},
						"source": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `The location of the source files to build.
One of 'storageSource' or 'repoSource' must be provided.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"repo_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Location of the source in a Google Cloud Source Repository.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"repo_name": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Name of the Cloud Source Repository.`,
												},
												"branch_name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
The syntax of the regular expressions accepted is the syntax accepted by RE2 and 
described at https://github.com/google/re2/wiki/Syntax`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
												"commit_sha": {
													Type:         schema.TypeString,
													Optional:     true,
													Description:  `Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
												"dir": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Directory, relative to the source root, in which to run the build.
This must be a relative path. If a step's dir is specified and is an absolute path, 
this value is ignored for that step's execution.`,
												},
												"invert_regex": {
													Type:        schema.TypeBool,
													Optional:    true,
													Description: `Only trigger a build if the revision regex does NOT match the revision regex.`,
												},
												"project_id": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `ID of the project that owns the Cloud Source Repository. 
If omitted, the project ID requesting the build is assumed.`,
												},
												"substitutions": {
													Type:        schema.TypeMap,
													Optional:    true,
													Description: `Substitutions to use in a triggered build. Should only be used with triggers.run`,
													Elem:        &schema.Schema{Type: schema.TypeString},
												},
												"tag_name": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
The syntax of the regular expressions accepted is the syntax accepted by RE2 and 
described at https://github.com/google/re2/wiki/Syntax`,
													ExactlyOneOf: []string{"build.0.source.0.repo_source.0.branch_name", "build.0.source.0.repo_source.0.commit_sha", "build.0.source.0.repo_source.0.tag_name"},
												},
											},
										},
									},
									"storage_source": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Location of the source in an archive file in Google Cloud Storage.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"bucket": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `Google Cloud Storage bucket containing the source.`,
												},
												"object": {
													Type:     schema.TypeString,
													Required: true,
													Description: `Google Cloud Storage object containing the source.
This object must be a gzipped archive file (.tar.gz) containing source to build.`,
												},
												"generation": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Google Cloud Storage generation for the object. 
If the generation is omitted, the latest generation will be used`,
												},
											},
										},
									},
								},
							},
						},
						"substitutions": {
							Type:        schema.TypeMap,
							Optional:    true,
							Description: `Substitutions data for Build resource.`,
							Elem:        &schema.Schema{Type: schema.TypeString},
						},
						"tags": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Tags for annotation of a Build. These are not docker tags.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"timeout": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Amount of time that this build should be allowed to run, to second granularity.
If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
The expected format is the number of seconds followed by s.
Default time is ten minutes (600s).`,
							Default: "600s",
						},
					},
				},
				ExactlyOneOf: []string{"filename", "build", "git_file_source"},
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Human-readable description of the trigger.`,
			},
			"disabled": {
				Type:        schema.TypeBool,
				Optional:    true,
				Description: `Whether the trigger is disabled or not. If true, the trigger will never result in a build.`,
			},
			"filename": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Path, from the source root, to a file whose contents is used for the template. 
Either a filename or build template must be provided. Set this only when using trigger_template or github.
When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.`,
				ExactlyOneOf: []string{"filename", "build", "git_file_source"},
			},
			"filter": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `A Common Expression Language string. Used only with Pub/Sub and Webhook.`,
			},
			"git_file_source": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The file source describing the local or remote Build template.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"path": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The path of the file, with the repo root as the root of the path.`,
						},
						"repo_type": {
							Type:         schema.TypeString,
							Required:     true,
							ValidateFunc: validateEnum([]string{"UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"}),
							Description: `The type of the repo, since it may not be explicit from the repo field (e.g from a URL). 
Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]`,
						},
						"revision": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the 
filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions 
If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.`,
						},
						"uri": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The URI of the repo (optional). If unspecified, the repo from which the trigger 
invocation originated is assumed to be the repo from which to read the specified path.`,
						},
					},
				},
				ExactlyOneOf: []string{"filename", "git_file_source", "build"},
			},
			"github": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Describes the configuration of a trigger that creates a build whenever a GitHub event is received.
One of 'trigger_template', 'github', 'pubsub_config' or 'webhook_config' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the repository. For example: The name for
https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".`,
						},
						"owner": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Owner of the repository. For example: The owner for
https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".`,
						},
						"pull_request": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `filter to match changes in pull requests. Specify only one of 'pull_request' or 'push'.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"branch": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Regex of branches to match.`,
									},
									"comment_control": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY", ""}),
										Description:  `Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]`,
									},
									"invert_regex": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `If true, branches that do NOT match the git_ref will trigger a build.`,
									},
								},
							},
							ExactlyOneOf: []string{"github.0.pull_request", "github.0.push"},
						},
						"push": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `filter to match changes in refs, like branches or tags. Specify only one of 'pull_request' or 'push'.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"branch": {
										Type:         schema.TypeString,
										Optional:     true,
										Description:  `Regex of branches to match.  Specify only one of branch or tag.`,
										ExactlyOneOf: []string{"github.0.push.0.branch", "github.0.push.0.tag"},
									},
									"invert_regex": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `When true, only trigger a build if the revision regex does NOT match the git_ref regex.`,
									},
									"tag": {
										Type:         schema.TypeString,
										Optional:     true,
										Description:  `Regex of tags to match.  Specify only one of branch or tag.`,
										ExactlyOneOf: []string{"github.0.push.0.branch", "github.0.push.0.tag"},
									},
								},
							},
							ExactlyOneOf: []string{"github.0.pull_request", "github.0.push"},
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"ignored_files": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
extended with support for '**'.
If ignoredFiles and changed files are both empty, then they are not
used to determine whether or not to trigger a build.
If ignoredFiles is not empty, then we ignore any files that match any
of the ignored_file globs. If the change has no files that are outside
of the ignoredFiles globs, then we do not trigger a build.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"include_build_logs": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validateEnum([]string{"INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS", ""}),
				Description: `Build logs will be sent back to GitHub as part of the checkrun
result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
INCLUDE_BUILD_LOGS_WITH_STATUS Possible values: ["INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS"]`,
			},
			"included_files": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
extended with support for '**'.
If any of the files altered in the commit pass the ignoredFiles filter
and includedFiles is empty, then as far as this filter is concerned, we
should trigger the build.
If any of the files altered in the commit pass the ignoredFiles filter
and includedFiles is not empty, then we make sure that at least one of
those files matches a includedFiles glob. If not, then we do not trigger
a build.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Optional:    true,
				Description: `Name of the trigger. Must be unique within the project.`,
			},
			"pubsub_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `PubsubConfig describes the configuration of a trigger that creates 
a build whenever a Pub/Sub message is published.
One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"topic": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The name of the topic from which this subscription is receiving messages.`,
						},
						"service_account_email": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Service account that will make the push request.`,
						},
						"state": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `Potential issues with the underlying Pub/Sub subscription configuration.
Only populated on get requests.`,
						},
						"subscription": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `Output only. Name of the subscription.`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"service_account": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `The service account used for all user-controlled operations including
triggers.patch, triggers.run, builds.create, and builds.cancel.
If no service account is set, then the standard Cloud Build service account
([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`,
			},
			"source_to_build": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `The repo and ref of the repository from which to build. 
This field is used only for those triggers that do not respond to SCM events. 
Triggers that respond to such events build source at whatever commit caused the event. 
This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers.
One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"ref": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The branch or tag to use. Must start with "refs/" (required).`,
						},
						"repo_type": {
							Type:         schema.TypeString,
							Required:     true,
							ValidateFunc: validateEnum([]string{"UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"}),
							Description: `The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]`,
						},
						"uri": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The URI of the repo (required).`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"substitutions": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Substitutions data for Build resource.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"tags": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Tags for annotation of a BuildTrigger`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"trigger_template": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `Template describing the types of source changes to trigger a build.
Branch and tag names in trigger templates are interpreted as regular
expressions. Any branch or tag change that matches that regular
expression will trigger a build.
One of 'trigger_template', 'github', 'pubsub_config', 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"branch_name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
This field is a regular expression.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
						"commit_sha": {
							Type:         schema.TypeString,
							Optional:     true,
							Description:  `Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
						"dir": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Directory, relative to the source root, in which to run the build.
This must be a relative path. If a step's dir is specified and
is an absolute path, this value is ignored for that step's
execution.`,
						},
						"invert_regex": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Only trigger a build if the revision regex does NOT match the revision regex.`,
						},
						"project_id": {
							Type:     schema.TypeString,
							Computed: true,
							Optional: true,
							Description: `ID of the project that owns the Cloud Source Repository. If
omitted, the project ID requesting the build is assumed.`,
						},
						"repo_name": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Name of the Cloud Source Repository. If omitted, the name "default" is assumed.`,
							Default:     "default",
						},
						"tag_name": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
This field is a regular expression.`,
							ExactlyOneOf: []string{"trigger_template.0.branch_name", "trigger_template.0.tag_name", "trigger_template.0.commit_sha"},
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"webhook_config": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `WebhookConfig describes the configuration of a trigger that creates 
a build whenever a webhook is sent to a trigger's webhook URL.
One of 'trigger_template', 'github', 'pubsub_config' 'webhook_config' or 'source_to_build' must be provided.`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"secret": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Resource name for the secret required as a URL parameter.`,
						},
						"state": {
							Type:     schema.TypeString,
							Computed: true,
							Description: `Potential issues with the underlying Pub/Sub subscription configuration.
Only populated on get requests.`,
						},
					},
				},
				AtLeastOneOf: []string{"trigger_template", "github", "pubsub_config", "webhook_config", "source_to_build"},
			},
			"create_time": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Time when the trigger was created.`,
			},
			"trigger_id": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The unique identifier for the trigger.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}
