"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALLOWED_FILE_EXTENSIONS", {
  enumerable: true,
  get: function () {
    return _shared.ALLOWED_FILE_EXTENSIONS;
  }
});
exports.MAPS_APP_ICON = exports.MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = exports.LAYER_VISIBILITY = exports.LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_ICON_TYPE_MAP = exports.FILTER_DRAW_MODE = exports.FALLBACK_LANGUAGE = exports.DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON = exports.DRAW_FILTER_CANCEL = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS = exports.DEFAULT_VECTOR_TILE_STYLES = exports.DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.CUSTOM_MAP = exports.APP_PATH = exports.APP_API = void 0;
Object.defineProperty(exports, "MAPS_APP_ID", {
  enumerable: true,
  get: function () {
    return _shared.MAPS_APP_ID;
  }
});
exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_INITIAL_STATE = exports.MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAPS_VISUALIZATION_DESCRIPTION = void 0;
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE;
  }
});
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE_IN_MB", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE_IN_MB;
  }
});
exports.PER_PAGE_REQUEST_NUMBER = exports.OSD_LANGUAGES = exports.OPENSEARCH_MAP_LAYER = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = exports.MIN_LONGITUDE = exports.MAX_LONGITUDE = exports.MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_LIMIT = void 0;
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_NAME", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_NAME;
  }
});
exports.TOOLTIP_STATE = void 0;
Object.defineProperty(exports, "fromMBtoBytes", {
  enumerable: true,
  get: function () {
    return _util.fromMBtoBytes;
  }
});

var _util = require("./util");

var _shared = require("./constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const DOCUMENTS_DEFAULT_MARKER_SIZE = 5;
exports.DOCUMENTS_DEFAULT_MARKER_SIZE = DOCUMENTS_DEFAULT_MARKER_SIZE;
const DOCUMENTS_MIN_MARKER_SIZE = 0;
exports.DOCUMENTS_MIN_MARKER_SIZE = DOCUMENTS_MIN_MARKER_SIZE;
const DOCUMENTS_MAX_MARKER_SIZE = 100;
exports.DOCUMENTS_MAX_MARKER_SIZE = DOCUMENTS_MAX_MARKER_SIZE;
const DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = 1;
exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS;
const DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = 0;
exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = DOCUMENTS_MIN_MARKER_BORDER_THICKNESS;
const DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = 100;
exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = DOCUMENTS_MAX_MARKER_BORDER_THICKNESS;
const DOCUMENTS_DEFAULT_REQUEST_NUMBER = 1000;
exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = DOCUMENTS_DEFAULT_REQUEST_NUMBER;
const DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = false;
exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = DOCUMENTS_DEFAULT_SHOW_TOOLTIPS;
const DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = true;
exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER;
const DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = true;
exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS;
const DOCUMENTS_DEFAULT_TOOLTIPS = [];
exports.DOCUMENTS_DEFAULT_TOOLTIPS = DOCUMENTS_DEFAULT_TOOLTIPS;
const DOCUMENTS_DEFAULT_LABEL_ENABLES = false;
exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = DOCUMENTS_DEFAULT_LABEL_ENABLES;
let DOCUMENTS_LABEL_TEXT_TYPE;
exports.DOCUMENTS_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE;

(function (DOCUMENTS_LABEL_TEXT_TYPE) {
  DOCUMENTS_LABEL_TEXT_TYPE["BY_FIELD"] = "by_field";
  DOCUMENTS_LABEL_TEXT_TYPE["FIXED"] = "fixed";
})(DOCUMENTS_LABEL_TEXT_TYPE || (exports.DOCUMENTS_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE = {}));

const DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE.BY_FIELD;
exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE;
const DOCUMENTS_DEFAULT_LABEL_SIZE = 15;
exports.DOCUMENTS_DEFAULT_LABEL_SIZE = DOCUMENTS_DEFAULT_LABEL_SIZE;
const DOCUMENTS_MIN_LABEL_SIZE = 1;
exports.DOCUMENTS_MIN_LABEL_SIZE = DOCUMENTS_MIN_LABEL_SIZE;
const DOCUMENTS_MAX_LABEL_SIZE = 100;
exports.DOCUMENTS_MAX_LABEL_SIZE = DOCUMENTS_MAX_LABEL_SIZE;
const DOCUMENTS_DEFAULT_LABEL_COLOR = '#000000';
exports.DOCUMENTS_DEFAULT_LABEL_COLOR = DOCUMENTS_DEFAULT_LABEL_COLOR;
const DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = '#FFFFFF';
exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR;
const DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = 20;
exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH;
const DOCUMENTS_NONE_LABEL_BORDER_WIDTH = 0;
exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = DOCUMENTS_NONE_LABEL_BORDER_WIDTH;
const DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = 2;
exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = DOCUMENTS_SMALL_LABEL_BORDER_WIDTH;
const DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = 5;
exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH;
const DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = 10;
exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = DOCUMENTS_LARGE_LABEL_BORDER_WIDTH;
const LAYER_PANEL_HIDE_LAYER_ICON = 'eyeClosed';
exports.LAYER_PANEL_HIDE_LAYER_ICON = LAYER_PANEL_HIDE_LAYER_ICON;
const LAYER_PANEL_SHOW_LAYER_ICON = 'eye';
exports.LAYER_PANEL_SHOW_LAYER_ICON = LAYER_PANEL_SHOW_LAYER_ICON;
const MAP_DATA_LAYER_DEFAULT_OPACITY = 70;
exports.MAP_DATA_LAYER_DEFAULT_OPACITY = MAP_DATA_LAYER_DEFAULT_OPACITY;
const MAP_DEFAULT_MAX_ZOOM = 22;
exports.MAP_DEFAULT_MAX_ZOOM = MAP_DEFAULT_MAX_ZOOM;
const MAP_DEFAULT_MIN_ZOOM = 0;
exports.MAP_DEFAULT_MIN_ZOOM = MAP_DEFAULT_MIN_ZOOM;
const MAP_LAYER_DEFAULT_MAX_OPACITY = 100;
exports.MAP_LAYER_DEFAULT_MAX_OPACITY = MAP_LAYER_DEFAULT_MAX_OPACITY;
const MAP_LAYER_DEFAULT_MIN_OPACITY = 0;
exports.MAP_LAYER_DEFAULT_MIN_OPACITY = MAP_LAYER_DEFAULT_MIN_OPACITY;
const MAP_LAYER_DEFAULT_NAME = 'Default map';
exports.MAP_LAYER_DEFAULT_NAME = MAP_LAYER_DEFAULT_NAME;
const MAP_LAYER_DEFAULT_OPACITY_STEP = 1;
exports.MAP_LAYER_DEFAULT_OPACITY_STEP = MAP_LAYER_DEFAULT_OPACITY_STEP;
const MAP_REFERENCE_LAYER_DEFAULT_OPACITY = 100; // Make this configurable from map settings

exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = MAP_REFERENCE_LAYER_DEFAULT_OPACITY;
const MAX_LAYER_LIMIT = 100;
exports.MAX_LAYER_LIMIT = MAX_LAYER_LIMIT;
const MAX_LAYER_NAME_LIMIT = 35;
exports.MAX_LAYER_NAME_LIMIT = MAX_LAYER_NAME_LIMIT;
const MAX_LONGITUDE = 180;
exports.MAX_LONGITUDE = MAX_LONGITUDE;
const MIN_LONGITUDE = -180;
exports.MIN_LONGITUDE = MIN_LONGITUDE;
const NEW_MAP_LAYER_DEFAULT_PREFIX = 'New layer';
exports.NEW_MAP_LAYER_DEFAULT_PREFIX = NEW_MAP_LAYER_DEFAULT_PREFIX;
const MAP_SAVED_OBJECT_TYPE = 'map'; // TODO: Replace with actual app icon

exports.MAP_SAVED_OBJECT_TYPE = MAP_SAVED_OBJECT_TYPE;
const MAPS_APP_ICON = 'gisApp';
exports.MAPS_APP_ICON = MAPS_APP_ICON;
const MAPS_VISUALIZATION_DESCRIPTION = 'Create map visualization with multiple layers'; // Starting position [lng, lat] and zoom

exports.MAPS_VISUALIZATION_DESCRIPTION = MAPS_VISUALIZATION_DESCRIPTION;
const MAP_INITIAL_STATE = {
  lng: 0,
  lat: 0,
  zoom: 1
};
exports.MAP_INITIAL_STATE = MAP_INITIAL_STATE;
const APP_PATH = {
  LANDING_PAGE_PATH: '/',
  CREATE_MAP: '/create',
  EDIT_MAP: '/:id',
  STATS: '/stats'
};
exports.APP_PATH = APP_PATH;
const APP_API = '/api/maps-dashboards';
exports.APP_API = APP_API;
let DASHBOARDS_MAPS_LAYER_NAME;
exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME;

(function (DASHBOARDS_MAPS_LAYER_NAME) {
  DASHBOARDS_MAPS_LAYER_NAME["OPENSEARCH_MAP"] = "OpenSearch map";
  DASHBOARDS_MAPS_LAYER_NAME["DOCUMENTS"] = "Documents";
  DASHBOARDS_MAPS_LAYER_NAME["CUSTOM_MAP"] = "Custom map";
})(DASHBOARDS_MAPS_LAYER_NAME || (exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME = {}));

let DASHBOARDS_MAPS_LAYER_TYPE;
exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE;

(function (DASHBOARDS_MAPS_LAYER_TYPE) {
  DASHBOARDS_MAPS_LAYER_TYPE["OPENSEARCH_MAP"] = "opensearch_vector_tile_map";
  DASHBOARDS_MAPS_LAYER_TYPE["DOCUMENTS"] = "documents";
  DASHBOARDS_MAPS_LAYER_TYPE["CUSTOM_MAP"] = "custom_map";
})(DASHBOARDS_MAPS_LAYER_TYPE || (exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE = {}));

let DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;
exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;

(function (DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE) {
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["WMS"] = "wms";
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["TMS"] = "tms";
})(DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE || (exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = {}));

let DASHBOARDS_MAPS_LAYER_ICON;
exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON;

(function (DASHBOARDS_MAPS_LAYER_ICON) {
  DASHBOARDS_MAPS_LAYER_ICON["OPENSEARCH_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["DOCUMENTS"] = "document";
  DASHBOARDS_MAPS_LAYER_ICON["CUSTOM_MAP"] = "globe";
})(DASHBOARDS_MAPS_LAYER_ICON || (exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON = {}));

let DASHBOARDS_MAPS_LAYER_DESCRIPTION;
exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION;

(function (DASHBOARDS_MAPS_LAYER_DESCRIPTION) {
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["OPENSEARCH_MAP"] = "Use default OpenSearch basemaps.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["DOCUMENTS"] = "View points, lines, and polygons on the map.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CUSTOM_MAP"] = "Configure maps to use a custom map source.";
})(DASHBOARDS_MAPS_LAYER_DESCRIPTION || (exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION = {}));

const DOCUMENTS = {
  name: DASHBOARDS_MAPS_LAYER_NAME.DOCUMENTS,
  type: DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS,
  icon: DASHBOARDS_MAPS_LAYER_ICON.DOCUMENTS,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.DOCUMENTS
};
exports.DOCUMENTS = DOCUMENTS;
const OPENSEARCH_MAP_LAYER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.OPENSEARCH_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.OPENSEARCH_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.OPENSEARCH_MAP
};
exports.OPENSEARCH_MAP_LAYER = OPENSEARCH_MAP_LAYER;
const CUSTOM_MAP = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CUSTOM_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CUSTOM_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CUSTOM_MAP
};
exports.CUSTOM_MAP = CUSTOM_MAP;
const LAYER_VISIBILITY = {
  NONE: 'none',
  VISIBLE: 'visible'
};
exports.LAYER_VISIBILITY = LAYER_VISIBILITY;
const LAYER_ICON_TYPE_MAP = {
  [DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS]: 'document',
  [DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP]: 'globe'
}; // refer https://github.com/opensearch-project/i18n-plugin/blob/main/DEVELOPER_GUIDE.md#new-locale for OSD supported languages

exports.LAYER_ICON_TYPE_MAP = LAYER_ICON_TYPE_MAP;
const OSD_LANGUAGES = ['en', 'es', 'fr', 'de', 'ja', 'ko', 'zh']; // all these codes are also supported in vector tiles map

exports.OSD_LANGUAGES = OSD_LANGUAGES;
const FALLBACK_LANGUAGE = 'en';
exports.FALLBACK_LANGUAGE = FALLBACK_LANGUAGE;
let TOOLTIP_STATE;
exports.TOOLTIP_STATE = TOOLTIP_STATE;

(function (TOOLTIP_STATE) {
  TOOLTIP_STATE["DISPLAY_FEATURES"] = "DISPLAY_FEATURES";
  TOOLTIP_STATE["FILTER_DRAW_SHAPE"] = "FILTER_DRAW_SHAPE";
})(TOOLTIP_STATE || (exports.TOOLTIP_STATE = TOOLTIP_STATE = {}));

let FILTER_DRAW_MODE;
exports.FILTER_DRAW_MODE = FILTER_DRAW_MODE;

(function (FILTER_DRAW_MODE) {
  FILTER_DRAW_MODE["NONE"] = "none";
  FILTER_DRAW_MODE["POLYGON"] = "polygon";
  FILTER_DRAW_MODE["RECTANGLE"] = "rectangle";
})(FILTER_DRAW_MODE || (exports.FILTER_DRAW_MODE = FILTER_DRAW_MODE = {}));

const MAPBOX_GL_DRAW_CREATE_LISTENER = 'draw.create';
exports.MAPBOX_GL_DRAW_CREATE_LISTENER = MAPBOX_GL_DRAW_CREATE_LISTENER;
let MAPBOX_GL_DRAW_MODES;
exports.MAPBOX_GL_DRAW_MODES = MAPBOX_GL_DRAW_MODES;

(function (MAPBOX_GL_DRAW_MODES) {
  MAPBOX_GL_DRAW_MODES["DRAW_POLYGON"] = "draw_polygon";
  MAPBOX_GL_DRAW_MODES["DRAW_RECTANGLE"] = "draw_rectangle";
  MAPBOX_GL_DRAW_MODES["SIMPLE_SELECT"] = "simple_select";
})(MAPBOX_GL_DRAW_MODES || (exports.MAPBOX_GL_DRAW_MODES = MAPBOX_GL_DRAW_MODES = {}));

const DRAW_FILTER_SHAPE_TITLE = 'DRAW SHAPE';
exports.DRAW_FILTER_SHAPE_TITLE = DRAW_FILTER_SHAPE_TITLE;
const DRAW_FILTER_POLYGON_DEFAULT_LABEL = 'polygon';
exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = DRAW_FILTER_POLYGON_DEFAULT_LABEL;
const DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = 'rectangle';
exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = DRAW_FILTER_RECTANGLE_DEFAULT_LABEL;
const DRAW_FILTER_POLYGON = 'Draw Polygon';
exports.DRAW_FILTER_POLYGON = DRAW_FILTER_POLYGON;
const DRAW_FILTER_CANCEL = 'Cancel';
exports.DRAW_FILTER_CANCEL = DRAW_FILTER_CANCEL;
const DRAW_FILTER_RECTANGLE = 'Draw Rectangle';
exports.DRAW_FILTER_RECTANGLE = DRAW_FILTER_RECTANGLE;
const DRAW_FILTER_SPATIAL_RELATIONS = ['intersects', 'disjoint', 'within'];
exports.DRAW_FILTER_SPATIAL_RELATIONS = DRAW_FILTER_SPATIAL_RELATIONS;
const PER_PAGE_REQUEST_NUMBER = 50;
exports.PER_PAGE_REQUEST_NUMBER = PER_PAGE_REQUEST_NUMBER;
const DEFAULT_VECTOR_TILE_STYLES = {
  BASIC: 'basic',
  DARK: 'dark'
};
exports.DEFAULT_VECTOR_TILE_STYLES = DEFAULT_VECTOR_TILE_STYLES;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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