"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Span = void 0;

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class Span extends _node.PPLNode {
  constructor(name, children, spanExpression, customLabel) {
    super(name, children);
    this.spanExpression = spanExpression;
    this.customLabel = customLabel;
  }

  getTokens() {
    return {
      span_expression: this.spanExpression.getTokens(),
      customLabel: this.customLabel
    };
  }

  toString() {
    return `${this.spanExpression.toString()}${this.customLabel ? ` as ${this.customLabel}` : ''}`;
  }

}

exports.Span = Span;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNwYW4udHMiXSwibmFtZXMiOlsiU3BhbiIsIlBQTE5vZGUiLCJjb25zdHJ1Y3RvciIsIm5hbWUiLCJjaGlsZHJlbiIsInNwYW5FeHByZXNzaW9uIiwiY3VzdG9tTGFiZWwiLCJnZXRUb2tlbnMiLCJzcGFuX2V4cHJlc3Npb24iLCJ0b1N0cmluZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSU8sTUFBTUEsSUFBTixTQUFtQkMsYUFBbkIsQ0FBMkI7QUFDaENDLEVBQUFBLFdBQVcsQ0FDVEMsSUFEUyxFQUVUQyxRQUZTLEVBR0RDLGNBSEMsRUFJREMsV0FKQyxFQUtUO0FBQ0EsVUFBTUgsSUFBTixFQUFZQyxRQUFaO0FBREEsU0FGUUMsY0FFUixHQUZRQSxjQUVSO0FBQUEsU0FEUUMsV0FDUixHQURRQSxXQUNSO0FBRUQ7O0FBRURDLEVBQUFBLFNBQVMsR0FBRztBQUNWLFdBQU87QUFDTEMsTUFBQUEsZUFBZSxFQUFFLEtBQUtILGNBQUwsQ0FBb0JFLFNBQXBCLEVBRFo7QUFFTEQsTUFBQUEsV0FBVyxFQUFFLEtBQUtBO0FBRmIsS0FBUDtBQUlEOztBQUVERyxFQUFBQSxRQUFRLEdBQVc7QUFDakIsV0FBUSxHQUFFLEtBQUtKLGNBQUwsQ0FBb0JJLFFBQXBCLEVBQStCLEdBQUUsS0FBS0gsV0FBTCxHQUFvQixPQUFNLEtBQUtBLFdBQVksRUFBM0MsR0FBK0MsRUFBRyxFQUE3RjtBQUNEOztBQW5CK0IiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IFBQTE5vZGUgfSBmcm9tICcuLi9ub2RlJztcblxuZXhwb3J0IGNsYXNzIFNwYW4gZXh0ZW5kcyBQUExOb2RlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgbmFtZTogc3RyaW5nLFxuICAgIGNoaWxkcmVuOiBQUExOb2RlW10sXG4gICAgcHJpdmF0ZSBzcGFuRXhwcmVzc2lvbjogUFBMTm9kZSxcbiAgICBwcml2YXRlIGN1c3RvbUxhYmVsOiBzdHJpbmdcbiAgKSB7XG4gICAgc3VwZXIobmFtZSwgY2hpbGRyZW4pO1xuICB9XG5cbiAgZ2V0VG9rZW5zKCkge1xuICAgIHJldHVybiB7XG4gICAgICBzcGFuX2V4cHJlc3Npb246IHRoaXMuc3BhbkV4cHJlc3Npb24uZ2V0VG9rZW5zKCksXG4gICAgICBjdXN0b21MYWJlbDogdGhpcy5jdXN0b21MYWJlbCxcbiAgICB9O1xuICB9XG5cbiAgdG9TdHJpbmcoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYCR7dGhpcy5zcGFuRXhwcmVzc2lvbi50b1N0cmluZygpfSR7dGhpcy5jdXN0b21MYWJlbCA/IGAgYXMgJHt0aGlzLmN1c3RvbUxhYmVsfWAgOiAnJ31gO1xuICB9XG59XG4iXX0=