"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;

var _opensearch_observability_plugin = require("./adaptors/opensearch_observability_plugin");

var _ppl_plugin = require("./adaptors/ppl_plugin");

var _index = require("./routes/index");

var _observability_saved_object = require("./saved_objects/observability_saved_object");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class ObservabilityPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const openSearchObservabilityClient = core.opensearch.legacy.createClient('opensearch_observability', {
      plugins: [_ppl_plugin.PPLPlugin, _opensearch_observability_plugin.OpenSearchObservabilityPlugin]
    }); // @ts-ignore

    core.http.registerRouteHandlerContext('observability_plugin', (context, request) => {
      return {
        logger: this.logger,
        observabilityClient: openSearchObservabilityClient
      };
    });
    const obsPanelType = {
      name: 'observability-panel',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          title: {
            type: 'text'
          },
          description: {
            type: 'text'
          }
        }
      },
      management: {
        importableAndExportable: true,

        getInAppUrl() {
          return {
            path: `/app/management/observability/settings`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },

        getTitle(obj) {
          return `Observability Settings [${obj.id}]`;
        }

      },
      migrations: {
        '3.0.0': doc => ({ ...doc,
          description: ''
        }),
        '3.0.1': doc => ({ ...doc,
          description: 'Some Description Text'
        }),
        '3.0.2': doc => ({ ...doc,
          dateCreated: parseInt(doc.dateCreated || '0', 10)
        })
      }
    };
    const integrationInstanceType = {
      name: 'integration-instance',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'text'
          },
          templateName: {
            type: 'text'
          },
          dataSource: {
            type: 'text'
          },
          creationDate: {
            type: 'date'
          },
          assets: {
            type: 'nested'
          }
        }
      }
    };
    core.savedObjects.registerType(obsPanelType);
    core.savedObjects.registerType(integrationInstanceType); // Register server side APIs

    (0, _index.setupRoutes)({
      router,
      client: openSearchObservabilityClient
    });
    core.savedObjects.registerType(_observability_saved_object.visualizationSavedObject);
    core.capabilities.registerProvider(() => ({
      observability: {
        show: true
      }
    }));
    return {};
  }

  start(core) {
    this.logger.debug('Observability: Started');
    return {};
  }

  stop() {}

}

exports.ObservabilityPlugin = ObservabilityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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