"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSqlRoute = registerSqlRoute;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerSqlRoute({
  router,
  facet
}) {
  router.post({
    path: `/api/sql/search`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(req);

    if (queryRes.success) {
      const result = {
        body: { ...queryRes.data
        }
      };
      return res.ok(result);
    }

    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNxbC50cyJdLCJuYW1lcyI6WyJyZWdpc3RlclNxbFJvdXRlIiwicm91dGVyIiwiZmFjZXQiLCJwb3N0IiwicGF0aCIsInZhbGlkYXRlIiwiYm9keSIsInNjaGVtYSIsIm9iamVjdCIsInF1ZXJ5Iiwic3RyaW5nIiwiZm9ybWF0IiwiY29udGV4dCIsInJlcSIsInJlcyIsInF1ZXJ5UmVzIiwiZGVzY3JpYmVRdWVyeSIsInN1Y2Nlc3MiLCJyZXN1bHQiLCJkYXRhIiwib2siLCJjdXN0b20iLCJzdGF0dXNDb2RlIiwic3RhdHVzIiwibWVzc2FnZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBT08sU0FBU0EsZ0JBQVQsQ0FBMEI7QUFBRUMsRUFBQUEsTUFBRjtBQUFVQyxFQUFBQTtBQUFWLENBQTFCLEVBQW1GO0FBQ3hGRCxFQUFBQSxNQUFNLENBQUNFLElBQVAsQ0FDRTtBQUNFQyxJQUFBQSxJQUFJLEVBQUcsaUJBRFQ7QUFFRUMsSUFBQUEsUUFBUSxFQUFFO0FBQ1JDLE1BQUFBLElBQUksRUFBRUMscUJBQU9DLE1BQVAsQ0FBYztBQUNsQkMsUUFBQUEsS0FBSyxFQUFFRixxQkFBT0csTUFBUCxFQURXO0FBRWxCQyxRQUFBQSxNQUFNLEVBQUVKLHFCQUFPRyxNQUFQO0FBRlUsT0FBZDtBQURFO0FBRlosR0FERixFQVVFLE9BQU9FLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUN4RixVQUFNQyxRQUFhLEdBQUcsTUFBTWIsS0FBSyxDQUFDYyxhQUFOLENBQW9CSCxHQUFwQixDQUE1Qjs7QUFDQSxRQUFJRSxRQUFRLENBQUNFLE9BQWIsRUFBc0I7QUFDcEIsWUFBTUMsTUFBVyxHQUFHO0FBQ2xCWixRQUFBQSxJQUFJLEVBQUUsRUFDSixHQUFHUyxRQUFRLENBQUNJO0FBRFI7QUFEWSxPQUFwQjtBQUtBLGFBQU9MLEdBQUcsQ0FBQ00sRUFBSixDQUFPRixNQUFQLENBQVA7QUFDRDs7QUFDRCxXQUFPSixHQUFHLENBQUNPLE1BQUosQ0FBVztBQUNoQkMsTUFBQUEsVUFBVSxFQUFFUCxRQUFRLENBQUNJLElBQVQsQ0FBY0csVUFBZCxJQUE0QlAsUUFBUSxDQUFDSSxJQUFULENBQWNJLE1BQTFDLElBQW9ELEdBRGhEO0FBRWhCakIsTUFBQUEsSUFBSSxFQUFFUyxRQUFRLENBQUNJLElBQVQsQ0FBY2IsSUFBZCxJQUFzQlMsUUFBUSxDQUFDSSxJQUFULENBQWNLLE9BQXBDLElBQStDO0FBRnJDLEtBQVgsQ0FBUDtBQUlELEdBeEJIO0FBMEJEIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgSVJvdXRlciwgSU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2UsIFJlc3BvbnNlRXJyb3IgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IFBQTEZhY2V0IGZyb20gJy4uL3NlcnZpY2VzL2ZhY2V0cy9wcGxfZmFjZXQnO1xuaW1wb3J0IHsgUFBMX0JBU0UsIFBQTF9TRUFSQ0ggfSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzL3NoYXJlZCc7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWdpc3RlclNxbFJvdXRlKHsgcm91dGVyLCBmYWNldCB9OiB7IHJvdXRlcjogSVJvdXRlcjsgZmFjZXQ6IFBQTEZhY2V0IH0pIHtcbiAgcm91dGVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogYC9hcGkvc3FsL3NlYXJjaGAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBxdWVyeTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIGZvcm1hdDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBxdWVyeVJlczogYW55ID0gYXdhaXQgZmFjZXQuZGVzY3JpYmVRdWVyeShyZXEpO1xuICAgICAgaWYgKHF1ZXJ5UmVzLnN1Y2Nlc3MpIHtcbiAgICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgICAgYm9keToge1xuICAgICAgICAgICAgLi4ucXVlcnlSZXMuZGF0YSxcbiAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgICAgICByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG4gICAgICB9XG4gICAgICByZXR1cm4gcmVzLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IHF1ZXJ5UmVzLmRhdGEuc3RhdHVzQ29kZSB8fCBxdWVyeVJlcy5kYXRhLnN0YXR1cyB8fCA1MDAsXG4gICAgICAgIGJvZHk6IHF1ZXJ5UmVzLmRhdGEuYm9keSB8fCBxdWVyeVJlcy5kYXRhLm1lc3NhZ2UgfHwgJycsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG59XG4iXX0=