/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.sqlobject.SQLObject;
import com.google.common.collect.Multimap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;

public class PersisterUtils {
    private PersisterUtils() {
    }

    public static ByteArrayOutputStream convertImageToStreamAsPNG(Image img) {
        BufferedImage image;
        if (img instanceof BufferedImage) {
            image = (BufferedImage)img;
        } else {
            image = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D g = image.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        if (image != null) {
            try {
                ImageIO.write((RenderedImage)image, "PNG", byteStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return byteStream;
    }

    public static String[] splitByDelimiter(String toSplit, int numPieces) {
        String[] pieces = toSplit.split(",");
        if (pieces.length > numPieces) {
            throw new IllegalArgumentException("Cannot convert string \"" + toSplit + "\" with an invalid number of properties.");
        }
        if (pieces.length < numPieces) {
            String[] allPieces = new String[numPieces];
            int i = 0;
            String[] arr$ = pieces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String piece;
                allPieces[i] = piece = arr$[i$];
                ++i;
            }
            while (i < numPieces) {
                allPieces[i] = "";
                ++i;
            }
            return allPieces;
        }
        return pieces;
    }

    public static Set<String> getInterestingPropertyNames(String type) throws SecurityException, IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        return PersisterUtils.getInterestingProperties(type, null, null).keySet();
    }

    public static Map<String, Object> getInterestingProperties(SQLObject object, SessionPersisterSuperConverter converter) throws SecurityException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return PersisterUtils.getInterestingProperties(object.getClass().getName(), object, converter);
    }

    private static Map<String, Object> getInterestingProperties(String type, SQLObject object, SessionPersisterSuperConverter converter) throws SecurityException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        Class<?> objectClass = Class.forName(type, true, PersisterUtils.class.getClassLoader());
        for (Method m : objectClass.getMethods()) {
            String propertyName;
            if (m.getAnnotation(Accessor.class) == null || !m.getAnnotation(Accessor.class).isInteresting()) continue;
            if (m.getName().startsWith("get")) {
                propertyName = m.getName().substring(3);
            } else if (m.getName().startsWith("is")) {
                propertyName = m.getName().substring(2);
            } else {
                throw new RuntimeException("Accessor class with improper prefix");
            }
            String firstCharacter = String.valueOf(propertyName.charAt(0));
            propertyName = propertyName.replaceFirst(firstCharacter, firstCharacter.toLowerCase());
            if (object != null) {
                propertyMap.put(propertyName, converter.convertToBasicType(m.invoke((Object)object, new Object[0]), new Object[0]));
                continue;
            }
            propertyMap.put(propertyName, "");
        }
        return propertyMap;
    }

    public static SPPersister.DataType getDataType(Class<? extends Object> classForDataType) {
        if (classForDataType == null) {
            return SPPersister.DataType.NULL;
        }
        if (Integer.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.INTEGER;
        }
        if (Long.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.LONG;
        }
        if (Short.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.SHORT;
        }
        if (Boolean.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.BOOLEAN;
        }
        if (Double.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.DOUBLE;
        }
        if (Float.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.FLOAT;
        }
        if (String.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.STRING;
        }
        if (Image.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.PNG_IMG;
        }
        if (SPObject.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.REFERENCE;
        }
        if (Void.class.isAssignableFrom(classForDataType)) {
            return SPPersister.DataType.NULL;
        }
        return SPPersister.DataType.STRING;
    }

    public static int[] convertStringToIntArray(String data) {
        String[] s = data.split(",");
        int[] ints = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                ints[i] = Integer.parseInt(s[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ints;
    }

    public static String convertIntArrayToString(int[] data) {
        String s = "";
        for (int i = 0; i < data.length; ++i) {
            s = s + String.valueOf(data[i]);
            if (i == data.length - 1) continue;
            s = s + ",";
        }
        return s;
    }

    public static int getTypePosition(String childClassName, String parentClassName) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Class<?> childType = PersisterUtils.class.getClassLoader().loadClass(childClassName);
        Class<?> parentType = PersisterUtils.class.getClassLoader().loadClass(parentClassName);
        List allowedChildTypes = (List)parentType.getDeclaredField("allowedChildTypes").get(null);
        for (int i = 0; i < allowedChildTypes.size(); ++i) {
            Class allowedType = (Class)allowedChildTypes.get(i);
            if (!allowedType.isAssignableFrom(childType)) continue;
            return i;
        }
        return -1;
    }

    public static Class<? extends SPObject> getParentAllowedChildType(String childClassName, String parentClassName) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        Class<?> childType = PersisterUtils.class.getClassLoader().loadClass(childClassName);
        if (parentClassName == null || parentClassName.trim().length() == 0) {
            return childType;
        }
        Class<?> parentType = PersisterUtils.class.getClassLoader().loadClass(parentClassName);
        List allowedChildTypes = (List)parentType.getDeclaredField("allowedChildTypes").get(null);
        if (allowedChildTypes.contains(childType)) {
            return childType;
        }
        for (int i = 0; i < allowedChildTypes.size(); ++i) {
            Class allowedType = (Class)allowedChildTypes.get(i);
            if (!allowedType.isAssignableFrom(childType)) continue;
            return allowedType;
        }
        return null;
    }

    public static Boolean findPersistedBooleanProperty(Multimap<String, PersistedSPOProperty> persistedProperties, String parentUUID, String propName) {
        Collection properties = persistedProperties.get((Object)parentUUID);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (PersistedSPOProperty property : properties) {
            if (!property.getPropertyName().equals(propName)) continue;
            return (Boolean)property.getNewValue();
        }
        return null;
    }
}

