/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracklink.vcslinks.VCSUtil;
import com.almworks.tracklink.vcslinks.cache.impl.VirtualFileRevision;
import com.almworks.util.Log;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.checkin.DifferenceType;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import com.intellij.util.Icons;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VCSLinkUsage
implements Usage,
UsageInModule,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage {
    private static final DateFormat DATETIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    private static final TextChunk TEXT_SPACE = new TextChunk(null, " ");
    private static final TextChunk TEXT_BY = new TextChunk(null, " by ");
    private static final Map<DifferenceType, TextAttributes> myTextAttributesMap = new HashMap<DifferenceType, TextAttributes>(4);
    private final UsageInfo myUsageInfo;
    private final VirtualFileRevision myRevision;
    private final Project myProject;
    private final VCSLinkUsagePresentation myPresentation;

    private VCSLinkUsage(UsageInfo usageInfo, VirtualFileRevision revision, Project project) {
        this.myUsageInfo = usageInfo;
        this.myRevision = revision;
        this.myProject = project;
        this.myPresentation = new VCSLinkUsagePresentation();
    }

    @Nullable
    public static VCSLinkUsage create(UsageInfo usageInfo, VirtualFileRevision revision, Project project) {
        return new VCSLinkUsage(usageInfo, revision, project);
    }

    public Date getDate() {
        return this.myRevision.getDate();
    }

    @Nullable
    private String getUser() {
        return this.myRevision.getUser();
    }

    private String getDescription() {
        return this.myRevision.getDescription();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(virtualFile);
        if (editor == null) {
            return null;
        }
        PsiElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return new TextEditorLocation(this.myUsageInfo.startOffset + element.getTextRange().getStartOffset(), (TextEditor)editor);
    }

    public void selectInEditor() {
        this.showRevisionPair();
    }

    public void highlightInEditor() {
        this.showRevisionPair();
    }

    public UsagePresentation getPresentation() {
        return this.myPresentation;
    }

    private void showRevisionPair() {
        try {
            Pair<VcsFileRevision, VcsFileRevision> revisionPair = VCSUtil.getAppropriateRevisionPair(this.myProject, this.myRevision.getVirtualFile(), this.getDate(), 60000L);
            if (revisionPair == null) {
                return;
            }
            VCSUtil.showDiffDialog((VcsFileRevision)revisionPair.getFirst(), (VcsFileRevision)revisionPair.getSecond(), this.myProject, this.myRevision.getVirtualFile());
        }
        catch (VcsException e) {
            Log.warn(null, e);
        }
        catch (IOException e) {
            Log.warn(null, e);
        }
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)element.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        return fileIndex.getModuleForFile(virtualFile);
    }

    @Nullable
    public OrderEntry getLibraryEntry() {
        block5: {
            List raw;
            block6: {
                if (!this.isValid()) {
                    return null;
                }
                PsiElement element = this.getElement();
                if (element == null || !element.isValid()) {
                    return null;
                }
                PsiFile psiFile = element.getContainingFile();
                VirtualFile virtualFile = this.getFile();
                if (virtualFile == null) {
                    return null;
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)element.getProject());
                ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
                if (!(psiFile instanceof PsiCompiledElement) && !fileIndex.isInLibrarySource(virtualFile)) break block5;
                raw = fileIndex.getOrderEntriesForFile(psiFile.getVirtualFile());
                if (!(raw instanceof OrderEntry[])) break block6;
                for (OrderEntry order : (OrderEntry[])raw) {
                    if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                    return order;
                }
                break block5;
            }
            if (!(raw instanceof List)) break block5;
            for (OrderEntry order : raw) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return order;
            }
        }
        return null;
    }

    @Nullable
    public VirtualFile getFile() {
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file != null) {
            file.putUserData(VCSUtil.VCS_DIFFERENCE_TYPE, (Object)this.myRevision.getDifferenceType());
            file.putUserData(VCSUtil.VCS_MODIFICATION_DATE, (Object)this.myRevision.getDate());
        }
        return file;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myUsageInfo.getElement();
    }

    public boolean isNonCodeUsage() {
        return false;
    }

    public boolean merge(MergeableUsage mergeableUsage) {
        return false;
    }

    public void reset() {
    }

    private class VCSLinkUsagePresentation
    implements UsagePresentation {
        private VCSLinkUsagePresentation() {
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public TextChunk[] getText() {
            String description;
            ArrayList<TextChunk> result = new ArrayList<TextChunk>();
            DifferenceType differenceType = VCSLinkUsage.this.myRevision.getDifferenceType();
            result.add(new TextChunk(this.getTextAttributes(differenceType), differenceType.getDisplayName()));
            result.add(TEXT_SPACE);
            result.add(new TextChunk(null, DATETIME_FORMAT.format(VCSLinkUsage.this.getDate())));
            String userName = VCSLinkUsage.this.getUser();
            if (userName != null && userName.length() > 0) {
                result.add(TEXT_BY);
                result.add(new TextChunk(null, userName));
            }
            if ((description = VCSLinkUsage.this.getDescription()).length() > 0) {
                result.add(TEXT_SPACE);
                result.add(new TextChunk(null, description));
            }
            return result.toArray(new TextChunk[result.size()]);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getPlainText() {
            String description;
            StringBuilder result = new StringBuilder();
            DifferenceType differenceType = VCSLinkUsage.this.myRevision.getDifferenceType();
            result.append(differenceType.getDisplayName()).append(' ');
            result.append(DATETIME_FORMAT.format(VCSLinkUsage.this.getDate())).append(' ');
            String userName = VCSLinkUsage.this.getUser();
            if (userName != null && userName.length() > 0) {
                result.append(" by ").append(userName);
            }
            if ((description = VCSLinkUsage.this.getDescription()).length() > 0) {
                result.append(' ').append(description);
            }
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/almworks/tracklink/findusages/VCSLinkUsage$VCSLinkUsagePresentation.getPlainText must not return null");
            }
            return string;
        }

        public Icon getIcon() {
            return Icons.SMALL_VCS_CONFIGURABLE;
        }

        public TextAttributes getTextAttributes(DifferenceType differenceType) {
            TextAttributes textAttributes = (TextAttributes)myTextAttributesMap.get(differenceType);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(differenceType.getForegroung(), differenceType.getBackgroung(), null, null, 0);
                myTextAttributesMap.put(differenceType, textAttributes);
            }
            return textAttributes;
        }
    }
}

