"""Generated client library for networkservices version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.networkservices.v1beta1 import networkservices_v1beta1_messages as messages


class NetworkservicesV1beta1(base_api.BaseApiClient):
  """Generated client library for service networkservices version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://networkservices.googleapis.com/'
  MTLS_BASE_URL = 'https://networkservices.mtls.googleapis.com/'

  _PACKAGE = 'networkservices'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1beta1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'NetworkservicesV1beta1'
  _URL_VERSION = 'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new networkservices handle."""
    url = url or self.BASE_URL
    super(NetworkservicesV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_edgeCacheServices = self.ProjectsLocationsEdgeCacheServicesService(self)
    self.projects_locations_endpointPolicies = self.ProjectsLocationsEndpointPoliciesService(self)
    self.projects_locations_gateways = self.ProjectsLocationsGatewaysService(self)
    self.projects_locations_grpcRoutes = self.ProjectsLocationsGrpcRoutesService(self)
    self.projects_locations_httpRoutes = self.ProjectsLocationsHttpRoutesService(self)
    self.projects_locations_lbRouteExtensions = self.ProjectsLocationsLbRouteExtensionsService(self)
    self.projects_locations_lbTrafficExtensions = self.ProjectsLocationsLbTrafficExtensionsService(self)
    self.projects_locations_meshes = self.ProjectsLocationsMeshesService(self)
    self.projects_locations_messagePublishingRoutes = self.ProjectsLocationsMessagePublishingRoutesService(self)
    self.projects_locations_messageSubscriptions = self.ProjectsLocationsMessageSubscriptionsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_serviceBindings = self.ProjectsLocationsServiceBindingsService(self)
    self.projects_locations_serviceLbPolicies = self.ProjectsLocationsServiceLbPoliciesService(self)
    self.projects_locations_tcpRoutes = self.ProjectsLocationsTcpRoutesService(self)
    self.projects_locations_tlsRoutes = self.ProjectsLocationsTlsRoutesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsEdgeCacheServicesService(base_api.BaseApiService):
    """Service class for the projects_locations_edgeCacheServices resource."""

    _NAME = 'projects_locations_edgeCacheServices'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsEdgeCacheServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def InvalidateCache(self, request, global_params=None):
      r"""Sends a cache invalidation request.

      Args:
        request: (NetworkservicesProjectsLocationsEdgeCacheServicesInvalidateCacheRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InvalidateCacheResponse) The response message.
      """
      config = self.GetMethodConfig('InvalidateCache')
      return self._RunMethod(
          config, request, global_params=global_params)

    InvalidateCache.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/edgeCacheServices/{edgeCacheServicesId}:invalidateCache',
        http_method='POST',
        method_id='networkservices.projects.locations.edgeCacheServices.invalidateCache',
        ordered_params=['edgeCacheService'],
        path_params=['edgeCacheService'],
        query_params=[],
        relative_path='v1beta1/{+edgeCacheService}:invalidateCache',
        request_field='invalidateCacheRequest',
        request_type_name='NetworkservicesProjectsLocationsEdgeCacheServicesInvalidateCacheRequest',
        response_type_name='InvalidateCacheResponse',
        supports_download=False,
    )

  class ProjectsLocationsEndpointPoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_endpointPolicies resource."""

    _NAME = 'projects_locations_endpointPolicies'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsEndpointPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new EndpointPolicy in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies',
        http_method='POST',
        method_id='networkservices.projects.locations.endpointPolicies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endpointPolicyId'],
        relative_path='v1beta1/{+parent}/endpointPolicies',
        request_field='endpointPolicy',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single EndpointPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.endpointPolicies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single EndpointPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EndpointPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.endpointPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesGetRequest',
        response_type_name='EndpointPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}:getIamPolicy',
        http_method='GET',
        method_id='networkservices.projects.locations.endpointPolicies.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists EndpointPolicies in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEndpointPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies',
        http_method='GET',
        method_id='networkservices.projects.locations.endpointPolicies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/endpointPolicies',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesListRequest',
        response_type_name='ListEndpointPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single EndpointPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.endpointPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='endpointPolicy',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}:setIamPolicy',
        http_method='POST',
        method_id='networkservices.projects.locations.endpointPolicies.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkservicesProjectsLocationsEndpointPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/endpointPolicies/{endpointPoliciesId}:testIamPermissions',
        http_method='POST',
        method_id='networkservices.projects.locations.endpointPolicies.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkservicesProjectsLocationsEndpointPoliciesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsGatewaysService(base_api.BaseApiService):
    """Service class for the projects_locations_gateways resource."""

    _NAME = 'projects_locations_gateways'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Gateway in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways',
        http_method='POST',
        method_id='networkservices.projects.locations.gateways.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['gatewayId'],
        relative_path='v1beta1/{+parent}/gateways',
        request_field='gateway',
        request_type_name='NetworkservicesProjectsLocationsGatewaysCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Gateway.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.gateways.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGatewaysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Gateway.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Gateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}',
        http_method='GET',
        method_id='networkservices.projects.locations.gateways.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGatewaysGetRequest',
        response_type_name='Gateway',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}:getIamPolicy',
        http_method='GET',
        method_id='networkservices.projects.locations.gateways.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGatewaysGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Gateways in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGatewaysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways',
        http_method='GET',
        method_id='networkservices.projects.locations.gateways.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/gateways',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGatewaysListRequest',
        response_type_name='ListGatewaysResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Gateway.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.gateways.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='gateway',
        request_type_name='NetworkservicesProjectsLocationsGatewaysPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}:setIamPolicy',
        http_method='POST',
        method_id='networkservices.projects.locations.gateways.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkservicesProjectsLocationsGatewaysSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkservicesProjectsLocationsGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/gateways/{gatewaysId}:testIamPermissions',
        http_method='POST',
        method_id='networkservices.projects.locations.gateways.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkservicesProjectsLocationsGatewaysTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsGrpcRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_grpcRoutes resource."""

    _NAME = 'projects_locations_grpcRoutes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsGrpcRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new GrpcRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsGrpcRoutesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/grpcRoutes',
        http_method='POST',
        method_id='networkservices.projects.locations.grpcRoutes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['grpcRouteId'],
        relative_path='v1beta1/{+parent}/grpcRoutes',
        request_field='grpcRoute',
        request_type_name='NetworkservicesProjectsLocationsGrpcRoutesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single GrpcRoute.

      Args:
        request: (NetworkservicesProjectsLocationsGrpcRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/grpcRoutes/{grpcRoutesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.grpcRoutes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGrpcRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single GrpcRoute.

      Args:
        request: (NetworkservicesProjectsLocationsGrpcRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GrpcRoute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/grpcRoutes/{grpcRoutesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.grpcRoutes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGrpcRoutesGetRequest',
        response_type_name='GrpcRoute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists GrpcRoutes in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsGrpcRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGrpcRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/grpcRoutes',
        http_method='GET',
        method_id='networkservices.projects.locations.grpcRoutes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/grpcRoutes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGrpcRoutesListRequest',
        response_type_name='ListGrpcRoutesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single GrpcRoute.

      Args:
        request: (NetworkservicesProjectsLocationsGrpcRoutesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/grpcRoutes/{grpcRoutesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.grpcRoutes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='grpcRoute',
        request_type_name='NetworkservicesProjectsLocationsGrpcRoutesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsHttpRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_httpRoutes resource."""

    _NAME = 'projects_locations_httpRoutes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsHttpRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new HttpRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsHttpRoutesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/httpRoutes',
        http_method='POST',
        method_id='networkservices.projects.locations.httpRoutes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['httpRouteId'],
        relative_path='v1beta1/{+parent}/httpRoutes',
        request_field='httpRoute',
        request_type_name='NetworkservicesProjectsLocationsHttpRoutesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single HttpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsHttpRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/httpRoutes/{httpRoutesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.httpRoutes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsHttpRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single HttpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsHttpRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpRoute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/httpRoutes/{httpRoutesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.httpRoutes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsHttpRoutesGetRequest',
        response_type_name='HttpRoute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists HttpRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsHttpRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHttpRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/httpRoutes',
        http_method='GET',
        method_id='networkservices.projects.locations.httpRoutes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/httpRoutes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsHttpRoutesListRequest',
        response_type_name='ListHttpRoutesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single HttpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsHttpRoutesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/httpRoutes/{httpRoutesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.httpRoutes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='httpRoute',
        request_type_name='NetworkservicesProjectsLocationsHttpRoutesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsLbRouteExtensionsService(base_api.BaseApiService):
    """Service class for the projects_locations_lbRouteExtensions resource."""

    _NAME = 'projects_locations_lbRouteExtensions'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsLbRouteExtensionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `LbRouteExtension` resource in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsLbRouteExtensionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbRouteExtensions',
        http_method='POST',
        method_id='networkservices.projects.locations.lbRouteExtensions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['lbRouteExtensionId', 'requestId'],
        relative_path='v1beta1/{+parent}/lbRouteExtensions',
        request_field='lbRouteExtension',
        request_type_name='NetworkservicesProjectsLocationsLbRouteExtensionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified `LbRouteExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbRouteExtensionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbRouteExtensions/{lbRouteExtensionsId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.lbRouteExtensions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbRouteExtensionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of the specified `LbRouteExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbRouteExtensionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LbRouteExtension) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbRouteExtensions/{lbRouteExtensionsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.lbRouteExtensions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbRouteExtensionsGetRequest',
        response_type_name='LbRouteExtension',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists `LbRouteExtension` resources in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsLbRouteExtensionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLbRouteExtensionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbRouteExtensions',
        http_method='GET',
        method_id='networkservices.projects.locations.lbRouteExtensions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/lbRouteExtensions',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbRouteExtensionsListRequest',
        response_type_name='ListLbRouteExtensionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of the specified `LbRouteExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbRouteExtensionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbRouteExtensions/{lbRouteExtensionsId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.lbRouteExtensions.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='lbRouteExtension',
        request_type_name='NetworkservicesProjectsLocationsLbRouteExtensionsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsLbTrafficExtensionsService(base_api.BaseApiService):
    """Service class for the projects_locations_lbTrafficExtensions resource."""

    _NAME = 'projects_locations_lbTrafficExtensions'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsLbTrafficExtensionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new `LbTrafficExtension` resource in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsLbTrafficExtensionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbTrafficExtensions',
        http_method='POST',
        method_id='networkservices.projects.locations.lbTrafficExtensions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['lbTrafficExtensionId', 'requestId'],
        relative_path='v1beta1/{+parent}/lbTrafficExtensions',
        request_field='lbTrafficExtension',
        request_type_name='NetworkservicesProjectsLocationsLbTrafficExtensionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified `LbTrafficExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbTrafficExtensionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbTrafficExtensions/{lbTrafficExtensionsId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.lbTrafficExtensions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbTrafficExtensionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of the specified `LbTrafficExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbTrafficExtensionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LbTrafficExtension) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbTrafficExtensions/{lbTrafficExtensionsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.lbTrafficExtensions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbTrafficExtensionsGetRequest',
        response_type_name='LbTrafficExtension',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists `LbTrafficExtension` resources in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsLbTrafficExtensionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLbTrafficExtensionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbTrafficExtensions',
        http_method='GET',
        method_id='networkservices.projects.locations.lbTrafficExtensions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/lbTrafficExtensions',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsLbTrafficExtensionsListRequest',
        response_type_name='ListLbTrafficExtensionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of the specified `LbTrafficExtension` resource.

      Args:
        request: (NetworkservicesProjectsLocationsLbTrafficExtensionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/lbTrafficExtensions/{lbTrafficExtensionsId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.lbTrafficExtensions.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='lbTrafficExtension',
        request_type_name='NetworkservicesProjectsLocationsLbTrafficExtensionsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMeshesService(base_api.BaseApiService):
    """Service class for the projects_locations_meshes resource."""

    _NAME = 'projects_locations_meshes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsMeshesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Mesh in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes',
        http_method='POST',
        method_id='networkservices.projects.locations.meshes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['meshId'],
        relative_path='v1beta1/{+parent}/meshes',
        request_field='mesh',
        request_type_name='NetworkservicesProjectsLocationsMeshesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Mesh.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.meshes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMeshesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Mesh.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Mesh) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.meshes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMeshesGetRequest',
        response_type_name='Mesh',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}:getIamPolicy',
        http_method='GET',
        method_id='networkservices.projects.locations.meshes.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMeshesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Meshes in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMeshesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes',
        http_method='GET',
        method_id='networkservices.projects.locations.meshes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/meshes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMeshesListRequest',
        response_type_name='ListMeshesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Mesh.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.meshes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='mesh',
        request_type_name='NetworkservicesProjectsLocationsMeshesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}:setIamPolicy',
        http_method='POST',
        method_id='networkservices.projects.locations.meshes.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkservicesProjectsLocationsMeshesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkservicesProjectsLocationsMeshesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/meshes/{meshesId}:testIamPermissions',
        http_method='POST',
        method_id='networkservices.projects.locations.meshes.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkservicesProjectsLocationsMeshesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsMessagePublishingRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_messagePublishingRoutes resource."""

    _NAME = 'projects_locations_messagePublishingRoutes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsMessagePublishingRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new MessagePublishingRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMessagePublishingRoutesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messagePublishingRoutes',
        http_method='POST',
        method_id='networkservices.projects.locations.messagePublishingRoutes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['messagePublishingRouteId'],
        relative_path='v1beta1/{+parent}/messagePublishingRoutes',
        request_field='messagePublishingRoute',
        request_type_name='NetworkservicesProjectsLocationsMessagePublishingRoutesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single MessagePublishingRoute.

      Args:
        request: (NetworkservicesProjectsLocationsMessagePublishingRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messagePublishingRoutes/{messagePublishingRoutesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.messagePublishingRoutes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessagePublishingRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single MessagePublishingRoute.

      Args:
        request: (NetworkservicesProjectsLocationsMessagePublishingRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MessagePublishingRoute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messagePublishingRoutes/{messagePublishingRoutesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.messagePublishingRoutes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessagePublishingRoutesGetRequest',
        response_type_name='MessagePublishingRoute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MessagePublishingRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMessagePublishingRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMessagePublishingRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messagePublishingRoutes',
        http_method='GET',
        method_id='networkservices.projects.locations.messagePublishingRoutes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/messagePublishingRoutes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessagePublishingRoutesListRequest',
        response_type_name='ListMessagePublishingRoutesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single MessagePublishingRoute.

      Args:
        request: (NetworkservicesProjectsLocationsMessagePublishingRoutesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messagePublishingRoutes/{messagePublishingRoutesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.messagePublishingRoutes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='messagePublishingRoute',
        request_type_name='NetworkservicesProjectsLocationsMessagePublishingRoutesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMessageSubscriptionsService(base_api.BaseApiService):
    """Service class for the projects_locations_messageSubscriptions resource."""

    _NAME = 'projects_locations_messageSubscriptions'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsMessageSubscriptionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new MessageSubscription in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMessageSubscriptionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messageSubscriptions',
        http_method='POST',
        method_id='networkservices.projects.locations.messageSubscriptions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['messageSubscriptionId'],
        relative_path='v1beta1/{+parent}/messageSubscriptions',
        request_field='messageSubscription',
        request_type_name='NetworkservicesProjectsLocationsMessageSubscriptionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single MessageSubscription.

      Args:
        request: (NetworkservicesProjectsLocationsMessageSubscriptionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messageSubscriptions/{messageSubscriptionsId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.messageSubscriptions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessageSubscriptionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single MessageSubscription.

      Args:
        request: (NetworkservicesProjectsLocationsMessageSubscriptionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MessageSubscription) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messageSubscriptions/{messageSubscriptionsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.messageSubscriptions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessageSubscriptionsGetRequest',
        response_type_name='MessageSubscription',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MessageSubscription in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsMessageSubscriptionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMessageSubscriptionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messageSubscriptions',
        http_method='GET',
        method_id='networkservices.projects.locations.messageSubscriptions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/messageSubscriptions',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsMessageSubscriptionsListRequest',
        response_type_name='ListMessageSubscriptionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single MessageSubscription.

      Args:
        request: (NetworkservicesProjectsLocationsMessageSubscriptionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/messageSubscriptions/{messageSubscriptionsId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.messageSubscriptions.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='messageSubscription',
        request_type_name='NetworkservicesProjectsLocationsMessageSubscriptionsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (NetworkservicesProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='networkservices.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='NetworkservicesProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (NetworkservicesProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (NetworkservicesProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (NetworkservicesProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='networkservices.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}/operations',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsServiceBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_serviceBindings resource."""

    _NAME = 'projects_locations_serviceBindings'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsServiceBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ServiceBinding in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['serviceBindingId'],
        relative_path='v1beta1/{+parent}/serviceBindings',
        request_field='serviceBinding',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ServiceBinding.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.serviceBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ServiceBinding.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsGetRequest',
        response_type_name='ServiceBinding',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}:getIamPolicy',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceBindings.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceBinding in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/serviceBindings',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsListRequest',
        response_type_name='ListServiceBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single ServiceBinding.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.serviceBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='serviceBinding',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}:setIamPolicy',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceBindings.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkservicesProjectsLocationsServiceBindingsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceBindings/{serviceBindingsId}:testIamPermissions',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceBindings.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkservicesProjectsLocationsServiceBindingsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsServiceLbPoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_serviceLbPolicies resource."""

    _NAME = 'projects_locations_serviceLbPolicies'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsServiceLbPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ServiceLbPolicy in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceLbPolicies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['serviceLbPolicyId'],
        relative_path='v1beta1/{+parent}/serviceLbPolicies',
        request_field='serviceLbPolicy',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ServiceLbPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.serviceLbPolicies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ServiceLbPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceLbPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceLbPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesGetRequest',
        response_type_name='ServiceLbPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}:getIamPolicy',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceLbPolicies.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1beta1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceLbPolicies in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceLbPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies',
        http_method='GET',
        method_id='networkservices.projects.locations.serviceLbPolicies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/serviceLbPolicies',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesListRequest',
        response_type_name='ListServiceLbPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single ServiceLbPolicy.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.serviceLbPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='serviceLbPolicy',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}:setIamPolicy',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceLbPolicies.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkservicesProjectsLocationsServiceLbPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/serviceLbPolicies/{serviceLbPoliciesId}:testIamPermissions',
        http_method='POST',
        method_id='networkservices.projects.locations.serviceLbPolicies.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1beta1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkservicesProjectsLocationsServiceLbPoliciesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsTcpRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_tcpRoutes resource."""

    _NAME = 'projects_locations_tcpRoutes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsTcpRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new TcpRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsTcpRoutesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tcpRoutes',
        http_method='POST',
        method_id='networkservices.projects.locations.tcpRoutes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tcpRouteId'],
        relative_path='v1beta1/{+parent}/tcpRoutes',
        request_field='tcpRoute',
        request_type_name='NetworkservicesProjectsLocationsTcpRoutesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single TcpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTcpRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tcpRoutes/{tcpRoutesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.tcpRoutes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTcpRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single TcpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTcpRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TcpRoute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tcpRoutes/{tcpRoutesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.tcpRoutes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTcpRoutesGetRequest',
        response_type_name='TcpRoute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists TcpRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsTcpRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTcpRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tcpRoutes',
        http_method='GET',
        method_id='networkservices.projects.locations.tcpRoutes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/tcpRoutes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTcpRoutesListRequest',
        response_type_name='ListTcpRoutesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single TcpRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTcpRoutesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tcpRoutes/{tcpRoutesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.tcpRoutes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='tcpRoute',
        request_type_name='NetworkservicesProjectsLocationsTcpRoutesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsTlsRoutesService(base_api.BaseApiService):
    """Service class for the projects_locations_tlsRoutes resource."""

    _NAME = 'projects_locations_tlsRoutes'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsTlsRoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new TlsRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsTlsRoutesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tlsRoutes',
        http_method='POST',
        method_id='networkservices.projects.locations.tlsRoutes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['tlsRouteId'],
        relative_path='v1beta1/{+parent}/tlsRoutes',
        request_field='tlsRoute',
        request_type_name='NetworkservicesProjectsLocationsTlsRoutesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single TlsRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTlsRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tlsRoutes/{tlsRoutesId}',
        http_method='DELETE',
        method_id='networkservices.projects.locations.tlsRoutes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTlsRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single TlsRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTlsRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TlsRoute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tlsRoutes/{tlsRoutesId}',
        http_method='GET',
        method_id='networkservices.projects.locations.tlsRoutes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTlsRoutesGetRequest',
        response_type_name='TlsRoute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists TlsRoute in a given project and location.

      Args:
        request: (NetworkservicesProjectsLocationsTlsRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTlsRoutesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tlsRoutes',
        http_method='GET',
        method_id='networkservices.projects.locations.tlsRoutes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1beta1/{+parent}/tlsRoutes',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsTlsRoutesListRequest',
        response_type_name='ListTlsRoutesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single TlsRoute.

      Args:
        request: (NetworkservicesProjectsLocationsTlsRoutesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}/tlsRoutes/{tlsRoutesId}',
        http_method='PATCH',
        method_id='networkservices.projects.locations.tlsRoutes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta1/{+name}',
        request_field='tlsRoute',
        request_type_name='NetworkservicesProjectsLocationsTlsRoutesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (NetworkservicesProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='networkservices.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta1/{+name}',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (NetworkservicesProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='networkservices.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'includeUnrevealedLocations', 'pageSize', 'pageToken'],
        relative_path='v1beta1/{+name}/locations',
        request_field='',
        request_type_name='NetworkservicesProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(NetworkservicesV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
