/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBResourceBundle;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CBIntText {
    static Locale locale = null;
    static MessageFormat messageFormatter = null;
    static Hashtable translations;
    private static boolean errorGiven;
    private static Logger log;
    private static boolean english;

    public static void init(String bundleLocation, ClassLoader customLoader) {
        locale = Locale.getDefault();
        Locale def = Locale.getDefault();
        log.info("Default Locale is: " + def.getDisplayName());
        log.info("Using Locale: " + locale.getDisplayName() + " for " + locale.getDisplayCountry());
        log.info("language, localized for default locale is: " + def.getDisplayLanguage(locale));
        log.info("country name, localized for default locale: " + def.getDisplayCountry(locale));
        log.info("Default language, localized for your locale is: " + locale.getDisplayLanguage(def));
        log.info("Default country name, localized for your locale is: " + locale.getDisplayCountry(def));
        translations = new Hashtable(500);
        CBIntText.addBundle(bundleLocation, customLoader);
        if (!def.getLanguage().equals("en")) {
            english = false;
        }
        messageFormatter = new MessageFormat("");
        messageFormatter.setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBundle(String bundleLocation, ClassLoader customLoader) {
        log.fine("adding resource bundle: " + bundleLocation + " using loader: " + customLoader.toString());
        int startSize = translations.size();
        if (locale == null) {
            log.warning(" ERROR: - CBIntText.addBundle() has been called before CBIntText was initialised! - ignoring call.");
            return;
        }
        try {
            CBResourceBundle bundle = new CBResourceBundle(bundleLocation, locale);
            String name = bundle.getString("name");
            log.info(" added language localizaton set: " + (name == null ? "(not named)" : name));
            Enumeration keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (translations.containsKey(key)) continue;
                log.fine("adding key: " + key + " trans: " + bundle.getString((String)key));
                translations.put(key, bundle.getString((String)key));
            }
        }
        catch (MissingResourceException e) {
            log.log(Level.WARNING, "unable to load resource bundle for " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale), e);
        }
        finally {
            if (startSize < translations.size()) {
                log.info(" locale language is " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale));
            } else {
                log.info("Unable to load language resource bundle (couldn't even find default 'JX.properties' file)!");
            }
        }
    }

    public static String get(String key) {
        if (key == null) {
            return "null key";
        }
        if (translations == null || translations.size() == 0) {
            if (!errorGiven) {
                if (!english) {
                    log.info("Unable to translate (" + key + ") - can't find language resource bundle.");
                }
                errorGiven = true;
            }
            return key;
        }
        try {
            String val = (String)translations.get(key);
            if (val == null) {
                if (!english) {
                    log.fine("Can't find translation for (" + key + ") - returning unchanged.");
                }
                return key;
            }
            return val;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String get(String key, Object[] args) {
        if (key == null) {
            return "null key";
        }
        String val = key;
        if (translations == null || translations.size() == 0) {
            if (!errorGiven) {
                if (!english) {
                    log.info("Unable to translate (" + key + ") - can't find language resource bundle.");
                }
                errorGiven = true;
            }
        } else {
            try {
                val = (String)translations.get(key);
                if (val == null) {
                    if (!english) {
                        log.fine("Can't find translation for (" + key + ") - returning unchanged.");
                    }
                    val = key;
                }
            }
            catch (MissingResourceException e) {
                val = key;
            }
        }
        return MessageFormat.format(key, args);
    }

    static {
        errorGiven = false;
        log = Logger.getLogger(CBIntText.class.getName());
        english = true;
    }
}

