/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.MainMenu;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ButtonBar
extends JToolBar
implements ActionListener {
    JXplorer jxplorer;
    MainMenu menu;
    JButton connect;
    JButton disconnect;
    JButton print;
    JButton cut;
    JButton copy;
    JButton paste;
    JButton del;
    JButton newEntry;
    JButton rename;
    JButton refresh;
    JButton stop;
    JButton pasteAlias;
    JButton copyDN;
    ButtonRegister br = null;
    private static Logger log = Logger.getLogger(ButtonBar.class.getName());

    public ButtonBar(JXplorer jxplorer) {
        this.jxplorer = jxplorer;
        this.setFloatable(false);
        this.menu = jxplorer.mainMenu;
        this.setSize(750, 20);
        String dir = JXplorer.getProperty("dir.images");
        String dirIcons = JXplorer.getProperty("dir.icons");
        this.connect = new JButton(new ImageIcon(dir + "connect.gif"));
        this.add(this.connect);
        this.disconnect = new JButton(new ImageIcon(dir + "disconnect.gif"));
        this.add(this.disconnect);
        this.print = new JButton(new ImageIcon(dir + "print.gif"));
        this.add(this.print);
        this.addSeparator();
        this.cut = new JButton(new ImageIcon(dir + "cut.gif"));
        this.add(this.cut);
        this.copyDN = new JButton(new ImageIcon(dir + "copy_dn.gif"));
        this.add(this.copyDN);
        this.copy = new JButton(new ImageIcon(dir + "copy.gif"));
        this.add(this.copy);
        this.paste = new JButton(new ImageIcon(dir + "paste.gif"));
        this.add(this.paste);
        this.pasteAlias = new JButton(new ImageIcon(dirIcons + "alias.gif"));
        this.add(this.pasteAlias);
        this.addSeparator();
        this.del = new JButton(new ImageIcon(dir + "delete.gif"));
        this.add(this.del);
        this.addSeparator();
        this.newEntry = new JButton(new ImageIcon(dir + "new.gif"));
        this.add(this.newEntry);
        this.rename = new JButton(new ImageIcon(dir + "rename.gif"));
        this.add(this.rename);
        this.addSeparator();
        this.refresh = new JButton(new ImageIcon(dir + "refresh.gif"));
        this.add(this.refresh);
        this.addSeparator();
        this.stop = new JButton(new ImageIcon(dir + "stop.gif"));
        this.add(this.stop);
        this.connect.setRolloverIcon(new ImageIcon(dir + "connect_rollover.gif"));
        this.disconnect.setRolloverIcon(new ImageIcon(dir + "disconnect_rollover.gif"));
        this.print.setRolloverIcon(new ImageIcon(dir + "print_rollover.gif"));
        this.cut.setRolloverIcon(new ImageIcon(dir + "cut_rollover.gif"));
        this.copy.setRolloverIcon(new ImageIcon(dir + "copy_rollover.gif"));
        this.copyDN.setRolloverIcon(new ImageIcon(dir + "copy_dn_rollover.gif"));
        this.paste.setRolloverIcon(new ImageIcon(dir + "paste_rollover.gif"));
        this.pasteAlias.setRolloverIcon(new ImageIcon(dir + "alias_rollover.gif"));
        this.del.setRolloverIcon(new ImageIcon(dir + "delete_rollover.gif"));
        this.newEntry.setRolloverIcon(new ImageIcon(dir + "new_rollover.gif"));
        this.rename.setRolloverIcon(new ImageIcon(dir + "rename_rollover.gif"));
        this.refresh.setRolloverIcon(new ImageIcon(dir + "refresh_rollover.gif"));
        this.stop.setRolloverIcon(new ImageIcon(dir + "stop_rollover.gif"));
        Component[] buttons = this.getComponents();
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            JButton temp = (JButton)buttons[i];
            temp.addActionListener(this);
            temp.setRolloverEnabled(true);
            temp.setSize(16, 16);
        }
        this.connect.setToolTipText(CBIntText.get("Connect to a DSA."));
        this.disconnect.setToolTipText(CBIntText.get("Disconnect from a DSA."));
        this.print.setToolTipText(CBIntText.get("Print out the current entry."));
        this.cut.setToolTipText(CBIntText.get("Select a subtree to move."));
        this.copy.setToolTipText(CBIntText.get("Select a subtree to copy."));
        this.copyDN.setToolTipText(CBIntText.get("Copy the Distinguished Name of an entry to the clipboard."));
        this.paste.setToolTipText(CBIntText.get("Paste a previously selected subtree."));
        this.pasteAlias.setToolTipText(CBIntText.get("Paste an Alias."));
        this.del.setToolTipText(CBIntText.get("Delete an entry."));
        this.newEntry.setToolTipText(CBIntText.get("Create a new entry."));
        this.rename.setToolTipText(CBIntText.get("Rename an entry."));
        this.refresh.setToolTipText(CBIntText.get("Refresh an entry."));
        this.stop.setToolTipText(CBIntText.get("Cancel queries."));
        this.br = JXplorer.getButtonRegister();
        this.br.registerItem(this.br.PASTE, this.paste);
        this.br.registerItem(this.br.PASTE_ALIAS, this.pasteAlias);
        this.br.registerItem(this.br.COPY, this.copy);
        this.br.registerItem(this.br.COPY_DN, this.copyDN);
        this.br.registerItem(this.br.CUT, this.cut);
        this.br.registerItem(this.br.CONNECT, this.connect);
        this.br.registerItem(this.br.DISCONNECT, this.disconnect);
        this.br.registerItem(this.br.PRINT, this.print);
        this.br.registerItem(this.br.DELETE, this.del);
        this.br.registerItem(this.br.NEW, this.newEntry);
        this.br.registerItem(this.br.RENAME, this.rename);
        this.br.registerItem(this.br.REFRESH, this.refresh);
        this.br.registerItem(this.br.STOP, this.stop);
        this.br.setItemEnabled(this.br.STOP, false);
        jxplorer.getStopMonitor().addWatcher(this.stop);
        this.setDisconnected();
        this.setMargin(new Insets(2, 0, 2, 0));
        this.doLayout();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connect) {
            this.menu.connect();
        } else if (e.getSource() == this.disconnect) {
            this.menu.disconnect();
        } else if (e.getSource() == this.print) {
            this.menu.print();
        } else if (e.getSource() == this.cut) {
            this.jxplorer.getActiveTree().getPopupTool().cut();
        } else if (e.getSource() == this.copy) {
            this.jxplorer.getActiveTree().getPopupTool().copy();
        } else if (e.getSource() == this.copyDN) {
            this.jxplorer.getActiveTree().getPopupTool().copyDN();
        } else if (e.getSource() == this.paste) {
            this.jxplorer.getActiveTree().getPopupTool().paste();
        } else if (e.getSource() == this.pasteAlias) {
            this.jxplorer.getActiveTree().getPopupTool().pasteAlias();
        } else if (e.getSource() == this.del) {
            this.jxplorer.getActiveTree().getPopupTool().delete();
        } else if (e.getSource() == this.newEntry) {
            this.jxplorer.getActiveTree().getPopupTool().newEntry();
        } else if (e.getSource() == this.rename) {
            this.jxplorer.getActiveTree().getPopupTool().rename();
        } else if (e.getSource() == this.refresh) {
            this.jxplorer.getActiveTree().getPopupTool().refresh();
        } else if (e.getSource() == this.stop) {
            this.jxplorer.getStopMonitor().show();
        } else {
            log.warning("error - unknown option in ButtonBar: " + e.getSource().toString());
        }
    }

    public void setConnected() {
        this.br.setConnectedState();
    }

    public void setDisconnected() {
        this.br.setDisconnectState();
    }
}

