/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssAlignContent;
import org.w3c.css.properties.css3.CssJustifyContent;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssPlaceContent
extends org.w3c.css.properties.css.CssPlaceContent {
    private CssAlignContent alignContent;
    private CssJustifyContent justifyContent;

    public CssPlaceContent() {
        this.value = initial;
        this.alignContent = new CssAlignContent();
        this.justifyContent = new CssJustifyContent();
    }

    public CssPlaceContent(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        this.alignContent = new CssAlignContent();
        this.justifyContent = new CssJustifyContent();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValue val = CssAlignContent.parseAlignContent(ac, expression, this);
        if (expression.end()) {
            this.value = val;
            this.alignContent.value = val;
            this.justifyContent.value = val;
        } else {
            char op = expression.getOperator();
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            values.add(val);
            this.alignContent.value = val;
            val = CssJustifyContent.parseJustifyContent(ac, expression, this);
            if (!expression.end()) {
                throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
            }
            values.add(val);
            this.justifyContent.value = val;
            this.value = new CssValueList(values);
        }
    }

    public CssPlaceContent(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.alignContent.addToStyle(ac, style);
        this.justifyContent.addToStyle(ac, style);
    }
}

