/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.quickconnect.QuickConnectionGroup;
import org.apache.guacamole.auth.quickconnect.conf.ConfigurationService;
import org.apache.guacamole.auth.quickconnect.utility.QCParser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.simple.SimpleConnection;
import org.apache.guacamole.net.auth.simple.SimpleDirectory;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class QuickConnectDirectory
extends SimpleDirectory<Connection> {
    @Inject
    private ConfigurationService confService;
    private final Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private QuickConnectionGroup rootGroup;
    private AtomicInteger connectionId;

    public void init(ConnectionGroup rootGroup) {
        this.rootGroup = (QuickConnectionGroup)rootGroup;
        this.connectionId = new AtomicInteger();
        super.setObjects(this.connections);
    }

    private int getNextConnectionID() {
        return this.connectionId.getAndIncrement();
    }

    public void add(Connection connection) throws GuacamoleException {
        this.connections.put(connection.getIdentifier(), connection);
    }

    public String create(String uri) throws GuacamoleException {
        String newConnectionId = Integer.toString(this.getNextConnectionID());
        QCParser parser = new QCParser(this.confService.getAllowedParameters(), this.confService.getDeniedParameters());
        GuacamoleConfiguration config = parser.getConfiguration(uri);
        String name = parser.getName(config);
        SimpleConnection connection = new SimpleConnection(name, newConnectionId, config, true);
        connection.setParentIdentifier("ROOT");
        this.add((Connection)connection);
        this.rootGroup.addConnectionIdentifier(newConnectionId);
        return newConnectionId;
    }
}

