/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.util.SystemVersion;

public class SecureFileOutputStream
extends FileOutputStream {
    private static final boolean oneDotSix = SystemVersion.isJava6();

    public SecureFileOutputStream(String file) throws FileNotFoundException {
        super(file);
        SecureFileOutputStream.setPerms(new File(file));
    }

    public SecureFileOutputStream(String file, boolean append) throws FileNotFoundException {
        super(file, append);
        SecureFileOutputStream.setPerms(new File(file));
    }

    public SecureFileOutputStream(File file) throws FileNotFoundException {
        super(file);
        SecureFileOutputStream.setPerms(file);
    }

    public SecureFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
        SecureFileOutputStream.setPerms(file);
    }

    static boolean canSetPerms() {
        if (!oneDotSix) {
            return false;
        }
        I2PAppContext ctx = I2PAppContext.getCurrentContext();
        if (ctx == null) {
            return true;
        }
        return !ctx.getBooleanProperty("i2p.insecureFiles");
    }

    public static void setPerms(File f) {
        if (!SecureFileOutputStream.canSetPerms()) {
            return;
        }
        try {
            f.setReadable(false, false);
            f.setReadable(true, true);
            f.setWritable(false, false);
            f.setWritable(true, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

