/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.action.search.SearchProgressListener;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.SearchService;
import org.opensearch.tasks.SearchBackpressureTask;
import org.opensearch.wlm.QueryGroupTask;

@PublicApi(since="1.0.0")
public class SearchTask
extends QueryGroupTask
implements SearchBackpressureTask {
    private final Supplier<String> descriptionSupplier;
    private SearchProgressListener progressListener = SearchProgressListener.NOOP;

    public SearchTask(long id, String type, String action, Supplier<String> descriptionSupplier, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, descriptionSupplier, parentTaskId, headers, SearchService.NO_TIMEOUT);
    }

    public SearchTask(long id, String type, String action, Supplier<String> descriptionSupplier, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        super(id, type, action, null, parentTaskId, headers, cancelAfterTimeInterval);
        this.descriptionSupplier = descriptionSupplier;
    }

    @Override
    public final String getDescription() {
        return this.descriptionSupplier.get();
    }

    @Override
    public boolean supportsResourceTracking() {
        return true;
    }

    public final void setProgressListener(SearchProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public final SearchProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }
}

