/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import java.util.List;
import java.util.Optional;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ad.ExecuteADResultResponseRecorder;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADProfileAction;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultRequest;
import org.opensearch.ad.transport.StopDetectorAction;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.rest.handler.IndexJobActionHandler;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.transport.ResultRequest;
import org.opensearch.transport.TransportService;

public class ADIndexJobActionHandler
extends IndexJobActionHandler<ADIndex, ADIndexManagement, ADTaskCacheManager, ADTaskType, ADTask, ADTaskManager, AnomalyResult, ADProfileAction, ExecuteADResultResponseRecorder> {
    public ADIndexJobActionHandler(Client client, ADIndexManagement indexManagement, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager, ExecuteADResultResponseRecorder recorder, NodeStateManager nodeStateManager, Settings settings) {
        super(client, indexManagement, xContentRegistry, adTaskManager, recorder, AnomalyResultAction.INSTANCE, AnalysisType.AD, ".opendistro-anomaly-detection-state", StopDetectorAction.INSTANCE, nodeStateManager, settings, AnomalyDetectorSettings.AD_REQUEST_TIMEOUT);
    }

    @Override
    protected ResultRequest createResultRequest(String configID, long start, long end) {
        return new AnomalyResultRequest(configID, start, end);
    }

    @Override
    protected List<ADTaskType> getBatchConfigTaskTypes() {
        return ADTaskType.HISTORICAL_DETECTOR_TASK_TYPES;
    }

    @Override
    public void stopConfig(String configId, boolean historical, User user, TransportService transportService, ActionListener<JobResponse> listener) {
        this.nodeStateManager.getConfig(configId, AnalysisType.AD, config -> {
            if (!config.isPresent()) {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            if (historical) {
                ((ADTaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(configId, this.getBatchConfigTaskTypes(), task -> ((ADTaskManager)this.taskManager).stopHistoricalAnalysis(configId, (Optional<ADTask>)task, user, listener), transportService, true, listener);
            } else {
                this.stopJob(configId, transportService, listener);
            }
        }, listener);
    }
}

