/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.forecast.settings.ForecastNumericSetting;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.rest.BaseRestHandler;

public abstract class AbstractForecasterAction
extends BaseRestHandler {
    protected volatile TimeValue requestTimeout;
    protected volatile TimeValue forecastInterval;
    protected volatile TimeValue forecastWindowDelay;
    protected volatile Integer maxSingleStreamForecasters;
    protected volatile Integer maxHCForecasters;
    protected volatile Integer maxForecastFeatures;
    protected volatile Integer maxCategoricalFields;

    public AbstractForecasterAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)ForecastSettings.FORECAST_REQUEST_TIMEOUT.get(settings);
        this.forecastInterval = (TimeValue)ForecastSettings.FORECAST_INTERVAL.get(settings);
        this.forecastWindowDelay = (TimeValue)ForecastSettings.FORECAST_WINDOW_DELAY.get(settings);
        this.maxSingleStreamForecasters = (Integer)ForecastSettings.MAX_SINGLE_STREAM_FORECASTERS.get(settings);
        this.maxHCForecasters = (Integer)ForecastSettings.MAX_HC_FORECASTERS.get(settings);
        this.maxForecastFeatures = 1;
        this.maxCategoricalFields = ForecastNumericSetting.maxCategoricalFields();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_INTERVAL, it -> {
            this.forecastInterval = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.FORECAST_WINDOW_DELAY, it -> {
            this.forecastWindowDelay = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.MAX_SINGLE_STREAM_FORECASTERS, it -> {
            this.maxSingleStreamForecasters = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ForecastSettings.MAX_HC_FORECASTERS, it -> {
            this.maxHCForecasters = it;
        });
    }
}

