/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.SearchForecasterInfoAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.SearchConfigInfoRequest;
import org.owasp.encoder.Encode;

public class RestSearchForecasterInfoAction
extends BaseRestHandler {
    public static final String SEARCH_FORECASTER_INFO_ACTION = "search_forecaster_info";

    public String getName() {
        return SEARCH_FORECASTER_INFO_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterName = request.param("name", null);
            String rawPath = request.rawPath();
            SearchConfigInfoRequest searchForecasterInfoRequest = new SearchConfigInfoRequest(forecasterName, rawPath);
            return channel -> client.execute((ActionType)SearchForecasterInfoAction.INSTANCE, (ActionRequest)searchForecasterInfoRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_forecast/forecasters", "count")), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/%s", "/_plugins/_forecast/forecasters", "match")));
    }
}

