/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLAgentGetRequest;
import org.opensearch.ml.common.transport.agent.MLAgentGetResponse;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetAgentTransportAction
extends HandledTransportAction<ActionRequest, MLAgentGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetAgentTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, ClusterService clusterService, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/agents/get", transportService, actionFilters, MLAgentGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLAgentGetResponse> actionListener) {
        MLAgentGetRequest mlAgentGetRequest = MLAgentGetRequest.fromActionRequest((ActionRequest)request);
        String agentId = mlAgentGetRequest.getAgentId();
        String tenantId = mlAgentGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block18: {
                    context.restore();
                    log.debug("Completed Get Agent Request, Agent id:{}", (Object)agentId);
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)throwable, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.error("Failed to get Agent index", (Throwable)cause);
                            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML Agent {}", (Object)agentId, (Object)cause);
                            actionListener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (gr != null && gr.isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                                    if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlAgent.getTenantId(), actionListener)) {
                                        if (mlAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                                            actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this agent", RestStatus.FORBIDDEN, new Object[0]));
                                        } else {
                                            actionListener.onResponse((Object)MLAgentGetResponse.builder().mlAgent(mlAgent).build());
                                        }
                                    }
                                    break block18;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse ml agent {}", (Object)agentId, (Object)e);
                                    actionListener.onFailure(e);
                                }
                                break block18;
                            }
                            actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find agent with the provided agent id: " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            actionListener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get ML agent {}", (Object)agentId, (Object)e);
            actionListener.onFailure(e);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

