/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.transport.connector.MLConnectorGetRequest;
import org.opensearch.ml.common.transport.connector.MLConnectorGetResponse;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetConnectorTransportAction
extends HandledTransportAction<ActionRequest, MLConnectorGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetConnectorTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/connectors/get", transportService, actionFilters, MLConnectorGetRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLConnectorGetResponse> actionListener) {
        MLConnectorGetRequest mlConnectorGetRequest = MLConnectorGetRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorGetRequest.getConnectorId();
        String tenantId = mlConnectorGetRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlConnectorGetRequest.isReturnContent());
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(connectorId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.connectorAccessControlHelper.getConnector(this.sdkClient, this.client, context, getDataObjectRequest, connectorId, (ActionListener<Connector>)ActionListener.wrap(connector -> this.handleConnectorAccessValidation(user, tenantId, (Connector)connector, actionListener), e -> this.handleConnectorAccessValidationFailure(connectorId, (Exception)e, actionListener)));
        }
        catch (Exception e2) {
            log.error("Failed to get ML connector {}", (Object)connectorId, (Object)e2);
            actionListener.onFailure(e2);
        }
    }

    private void handleConnectorAccessValidation(User user, String tenantId, Connector mlConnector, ActionListener<MLConnectorGetResponse> actionListener) {
        if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, mlConnector.getTenantId(), actionListener)) {
            if (this.connectorAccessControlHelper.hasPermission(user, mlConnector)) {
                actionListener.onResponse((Object)MLConnectorGetResponse.builder().mlConnector(mlConnector).build());
            } else {
                actionListener.onFailure((Exception)new OpenSearchStatusException("You don't have permission to access this connector", RestStatus.FORBIDDEN, new Object[0]));
            }
        }
    }

    private void handleConnectorAccessValidationFailure(String connectorId, Exception e, ActionListener<MLConnectorGetResponse> actionListener) {
        log.error("Failed to get ML connector: {}", (Object)connectorId, (Object)e);
        actionListener.onFailure(e);
    }
}

