/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.profile;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.env.Environment;
import org.opensearch.ml.action.profile.MLProfileAction;
import org.opensearch.ml.action.profile.MLProfileNodeRequest;
import org.opensearch.ml.action.profile.MLProfileNodeResponse;
import org.opensearch.ml.action.profile.MLProfileRequest;
import org.opensearch.ml.action.profile.MLProfileResponse;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.profile.MLModelProfile;
import org.opensearch.ml.profile.MLProfileInput;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class MLProfileTransportAction
extends TransportNodesAction<MLProfileRequest, MLProfileResponse, MLProfileNodeRequest, MLProfileNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(MLProfileTransportAction.class);
    private MLTaskManager mlTaskManager;
    private final JvmService jvmService;
    private final MLModelManager mlModelManager;
    private final Client client;

    @Inject
    public MLProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLTaskManager mlTaskManager, Environment environment, MLModelManager mlModelManager, Client client) {
        super(MLProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, MLProfileRequest::new, MLProfileNodeRequest::new, "management", MLProfileNodeResponse.class);
        this.mlTaskManager = mlTaskManager;
        this.jvmService = new JvmService(environment.settings());
        this.mlModelManager = mlModelManager;
        this.client = client;
    }

    protected MLProfileResponse newResponse(MLProfileRequest request, List<MLProfileNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLProfileResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLProfileNodeRequest newNodeRequest(MLProfileRequest request) {
        return new MLProfileNodeRequest(request);
    }

    protected MLProfileNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLProfileNodeResponse(in);
    }

    protected MLProfileNodeResponse nodeOperation(MLProfileNodeRequest request) {
        return this.createMLProfileNodeResponse(request.getMlProfileRequest());
    }

    private MLProfileNodeResponse createMLProfileNodeResponse(MLProfileRequest mlProfileRequest) {
        MLProfileInput profileInput = mlProfileRequest.getMlProfileInput();
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        Set<String> hiddenModels = Optional.ofNullable(mlProfileRequest.getHiddenModelIds()).orElse(Collections.emptySet());
        Map<String, MLTask> tasks = this.getTasks(profileInput, isSuperAdmin, hiddenModels);
        Map<String, MLModelProfile> models = this.getModels(profileInput, isSuperAdmin, hiddenModels);
        return new MLProfileNodeResponse(this.clusterService.localNode(), tasks, models);
    }

    private Map<String, MLTask> getTasks(MLProfileInput profileInput, boolean isSuperAdmin, Set<String> hiddenModels) {
        HashMap<String, MLTask> tasks = new HashMap<String, MLTask>();
        Arrays.stream(this.mlTaskManager.getAllTaskIds()).forEach(taskId -> {
            MLTask task = this.mlTaskManager.getMLTask((String)taskId);
            if (task != null && (isSuperAdmin || !hiddenModels.contains(task.getModelId())) && (profileInput.isReturnAllTasks() || profileInput.getTaskIds().contains(taskId))) {
                tasks.put((String)taskId, task);
            }
        });
        return tasks;
    }

    private Map<String, MLModelProfile> getModels(MLProfileInput profileInput, boolean isSuperAdmin, Set<String> hiddenModels) {
        HashMap<String, MLModelProfile> models = new HashMap<String, MLModelProfile>();
        Arrays.stream(this.mlModelManager.getAllModelIds()).forEach(modelId -> {
            MLModelProfile modelProfile;
            if ((isSuperAdmin || !hiddenModels.contains(modelId)) && (profileInput.isReturnAllModels() || profileInput.getModelIds().contains(modelId)) && (modelProfile = this.mlModelManager.getModelProfile((String)modelId)) != null) {
                modelProfile.setIsHidden(hiddenModels.contains(modelId));
                models.put((String)modelId, modelProfile);
            }
        });
        return models;
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

