/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.connector.MLConnectorGetAction;
import org.opensearch.ml.common.transport.connector.MLConnectorGetRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetConnectorAction
extends BaseRestHandler {
    private static final String ML_GET_CONNECTOR_ACTION = "ml_get_connector_action";
    private ClusterService clusterService;
    private Settings settings;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetConnectorAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/connectors/{%s}", "/_plugins/_ml", "connector_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLConnectorGetRequest mlConnectorGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLConnectorGetAction.INSTANCE, (ActionRequest)mlConnectorGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLConnectorGetRequest getRequest(RestRequest request) throws IOException {
        String connectorId = RestActionUtils.getParameterId(request, "connector_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        return new MLConnectorGetRequest(connectorId, tenantId, returnContent);
    }
}

