/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class NumberRangeRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_NUMBER_RANGE";
    protected boolean reportAllFailures;
    private final int lowerRange;
    private final int upperRange;
    private final MatchBehavior matchBehavior;

    public NumberRangeRule(int lower, int upper) {
        this(lower, upper, MatchBehavior.Contains, true);
    }

    public NumberRangeRule(int lower, int upper, boolean reportAll) {
        this(lower, upper, MatchBehavior.Contains, reportAll);
    }

    public NumberRangeRule(int lower, int upper, MatchBehavior behavior) {
        this(lower, upper, behavior, true);
    }

    public NumberRangeRule(int lower, int upper, MatchBehavior behavior, boolean reportAll) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower must be less than upper");
        }
        this.lowerRange = lower;
        this.upperRange = upper;
        this.matchBehavior = behavior;
        this.reportAllFailures = reportAll;
    }

    public int getLowerRange() {
        return this.lowerRange;
    }

    public int getUpperRange() {
        return this.upperRange;
    }

    public MatchBehavior getMatchBehavior() {
        return this.matchBehavior;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        String text = passwordData.getPassword();
        for (int i = this.lowerRange; i < this.upperRange; ++i) {
            if (!this.matchBehavior.match(text, Integer.toString(i))) continue;
            String[] codes = new String[]{"ILLEGAL_NUMBER_RANGE." + this.matchBehavior.upperSnakeName(), ERROR_CODE};
            result.addError(codes, this.createRuleResultDetailParameters(i));
            if (!this.reportAllFailures) break;
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(int number) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("number", number);
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::lowerRange=%s,upperRange=%s,matchBehavior=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.lowerRange, this.upperRange, this.matchBehavior});
    }
}

