/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.common.model.notification;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.rest.RestStatus;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"VALID_RESPONSE_STATUS", "", "", "validateResponseStatus", "", "restStatus", "Lorg/opensearch/core/rest/RestStatus;", "responseContent", "", "opensearch-index-management"})
@JvmName(name="NotificationUtils")
public final class NotificationUtils {
    @NotNull
    private static final Set<Integer> VALID_RESPONSE_STATUS;

    public static final void validateResponseStatus(@NotNull RestStatus restStatus, @NotNull String responseContent) throws OpenSearchStatusException {
        Intrinsics.checkNotNullParameter((Object)restStatus, (String)"restStatus");
        Intrinsics.checkNotNullParameter((Object)responseContent, (String)"responseContent");
        if (!VALID_RESPONSE_STATUS.contains(restStatus.getStatus())) {
            throw new OpenSearchStatusException("Failed: " + responseContent, restStatus, new Object[0]);
        }
    }

    static {
        Object[] objectArray = new Integer[]{RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus()};
        VALID_RESPONSE_STATUS = SetsKt.setOf((Object[])objectArray);
    }
}

