/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.action;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverAction;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.ActionParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverActionParser;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/ActionParser;", "()V", "fromStreamInput", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "fromXContent", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "index", "", "getActionType", "", "opensearch-index-management"})
public final class RolloverActionParser
extends ActionParser {
    public RolloverActionParser() {
        super(false, 1, null);
    }

    @NotNull
    public Action fromStreamInput(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        ByteSizeValue minSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        Long minDocs = sin.readOptionalLong();
        TimeValue minAge = sin.readOptionalTimeValue();
        ByteSizeValue minPrimaryShardSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        boolean copyAlias2 = sin.readBoolean();
        int index2 = sin.readInt();
        return new RolloverAction(minSize, minDocs, minAge, minPrimaryShardSize, copyAlias2, index2);
    }

    @NotNull
    public Action fromXContent(@NotNull XContentParser xcp, int index2) {
        Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
        ByteSizeValue minSize = null;
        Long minDocs = null;
        TimeValue minAge = null;
        ByteSizeValue minPrimaryShardSize = null;
        boolean copyAlias2 = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName;
            block20: {
                fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) break block20;
                int n = -1;
                switch (string.hashCode()) {
                    case 1092215084: {
                        if (string.equals("min_primary_shard_size")) {
                            n = 1;
                        }
                        break;
                    }
                    case -586253050: {
                        if (string.equals("copy_alias")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1368123954: {
                        if (string.equals("min_size")) {
                            n = 3;
                        }
                        break;
                    }
                    case 655325797: {
                        if (string.equals("min_index_age")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1767297435: {
                        if (string.equals("min_doc_count")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        minSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"min_size");
                        continue block14;
                    }
                    case 5: {
                        minDocs = xcp.longValue();
                        continue block14;
                    }
                    case 4: {
                        minAge = TimeValue.parseTimeValue((String)xcp.text(), (String)"min_index_age");
                        continue block14;
                    }
                    case 1: {
                        minPrimaryShardSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"min_primary_shard_size");
                        continue block14;
                    }
                    case 2: {
                        copyAlias2 = xcp.booleanValue();
                        continue block14;
                    }
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in RolloverAction.");
        }
        return new RolloverAction(minSize, minDocs, minAge, minPrimaryShardSize, copyAlias2, index2);
    }

    @NotNull
    public String getActionType() {
        return "rollover";
    }
}

