/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.request;

import java.util.Map;
import java.util.Optional;
import org.opensearch.sql.legacy.executor.Format;

public class SqlRequestParam {
    public static final String QUERY_PARAMS_FORMAT = "format";
    public static final String QUERY_PARAMS_PRETTY = "pretty";
    public static final String QUERY_PARAMS_ESCAPE = "escape";
    private static final String DEFAULT_RESPONSE_FORMAT = "jdbc";

    public static boolean isPrettyFormat(Map<String, String> requestParams) {
        return requestParams.containsKey(QUERY_PARAMS_PRETTY) && ("".equals(requestParams.get(QUERY_PARAMS_PRETTY)) || "true".equals(requestParams.get(QUERY_PARAMS_PRETTY)));
    }

    public static Format getFormat(Map<String, String> requestParams) {
        String formatName = requestParams.containsKey(QUERY_PARAMS_FORMAT) ? requestParams.get(QUERY_PARAMS_FORMAT).toLowerCase() : DEFAULT_RESPONSE_FORMAT;
        Optional<Format> optionalFormat = Format.of(formatName);
        if (optionalFormat.isPresent()) {
            return optionalFormat.get();
        }
        throw new IllegalArgumentException("Failed to create executor due to unknown response format: " + formatName);
    }

    public static boolean getEscapeOption(Map<String, String> requestParams) {
        if (requestParams.containsKey(QUERY_PARAMS_ESCAPE)) {
            return Boolean.parseBoolean(requestParams.get(QUERY_PARAMS_ESCAPE));
        }
        return false;
    }
}

