/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.lucene.search.CollectorManager;
import org.opensearch.neuralsearch.search.query.HybridCollectorManager;
import org.opensearch.neuralsearch.util.HybridQueryUtil;
import org.opensearch.search.aggregations.AggregationInitializationException;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;

public class HybridAggregationProcessor
implements AggregationProcessor {
    private final AggregationProcessor delegateAggsProcessor;

    public void preProcess(SearchContext context) {
        this.delegateAggsProcessor.preProcess(context);
        if (HybridQueryUtil.isHybridQuery(context.query(), context)) {
            CollectorManager collectorManager;
            try {
                collectorManager = HybridCollectorManager.createHybridCollectorManager(context);
            }
            catch (IOException exception) {
                throw new AggregationInitializationException("could not initialize hybrid aggregation processor", (Throwable)exception);
            }
            context.queryCollectorManagers().put(HybridCollectorManager.class, collectorManager);
        }
    }

    public void postProcess(SearchContext context) {
        if (HybridQueryUtil.isHybridQuery(context.query(), context)) {
            if (!context.shouldUseConcurrentSearch()) {
                this.reduceCollectorResults(context);
            }
            this.updateQueryResult(context.queryResult(), context);
        }
        this.delegateAggsProcessor.postProcess(context);
    }

    private void reduceCollectorResults(SearchContext context) {
        CollectorManager collectorManager = (CollectorManager)context.queryCollectorManagers().get(HybridCollectorManager.class);
        try {
            ((ReduceableSearchResult)collectorManager.reduce(List.of())).reduce(context.queryResult());
        }
        catch (IOException e) {
            throw new QueryPhaseExecutionException(context.shardTarget(), "failed to execute hybrid query aggregation processor", (Throwable)e);
        }
    }

    private void updateQueryResult(QuerySearchResult queryResult, SearchContext searchContext) {
        boolean isSingleShard;
        boolean bl = isSingleShard = searchContext.numberOfShards() == 1;
        if (isSingleShard) {
            searchContext.size(queryResult.queryResult().topDocs().topDocs.scoreDocs.length);
        }
    }

    @Generated
    public HybridAggregationProcessor(AggregationProcessor delegateAggsProcessor) {
        this.delegateAggsProcessor = delegateAggsProcessor;
    }
}

