/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.reportsscheduler.action.CreateReportDefinitionAction;
import org.opensearch.reportsscheduler.action.DeleteReportDefinitionAction;
import org.opensearch.reportsscheduler.action.GetAllReportDefinitionsAction;
import org.opensearch.reportsscheduler.action.GetAllReportInstancesAction;
import org.opensearch.reportsscheduler.action.GetReportDefinitionAction;
import org.opensearch.reportsscheduler.action.GetReportInstanceAction;
import org.opensearch.reportsscheduler.action.InContextReportCreateAction;
import org.opensearch.reportsscheduler.action.OnDemandReportCreateAction;
import org.opensearch.reportsscheduler.action.UpdateReportDefinitionAction;
import org.opensearch.reportsscheduler.action.UpdateReportInstanceStatusAction;
import org.opensearch.reportsscheduler.index.ReportDefinitionsIndex;
import org.opensearch.reportsscheduler.index.ReportInstancesIndex;
import org.opensearch.reportsscheduler.resthandler.OnDemandReportRestHandler;
import org.opensearch.reportsscheduler.resthandler.ReportDefinitionListRestHandler;
import org.opensearch.reportsscheduler.resthandler.ReportDefinitionRestHandler;
import org.opensearch.reportsscheduler.resthandler.ReportInstanceListRestHandler;
import org.opensearch.reportsscheduler.resthandler.ReportInstanceRestHandler;
import org.opensearch.reportsscheduler.resthandler.ReportStatsRestHandler;
import org.opensearch.reportsscheduler.scheduler.ReportDefinitionJobParser;
import org.opensearch.reportsscheduler.scheduler.ReportDefinitionJobRunner;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 >2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0005Jl\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u001e\u0010 \u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020#\u0012\u0006\b\u0001\u0012\u00020$0\"0!H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020&H\u0016JL\u0010,\u001a\b\u0012\u0004\u0012\u00020-0!2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u001eH\u0016J\u0012\u0010:\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030;0!H\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u00072\u0006\u0010.\u001a\u00020/H\u0016\u00a8\u0006?"}, d2={"Lorg/opensearch/reportsscheduler/ReportsSchedulerPlugin;", "Lorg/opensearch/plugins/Plugin;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/SystemIndexPlugin;", "Lorg/opensearch/jobscheduler/spi/JobSchedulerExtension;", "()V", "createComponents", "", "", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "repositoriesServiceSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "getActions", "", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getJobIndex", "", "getJobParser", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParser;", "getJobRunner", "Lorg/opensearch/jobscheduler/spi/ScheduledJobRunner;", "getJobType", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "nodesInCluster", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "getSystemIndexDescriptors", "Lorg/opensearch/indices/SystemIndexDescriptor;", "Companion", "opensearch-reports-scheduler"})
public final class ReportsSchedulerPlugin
extends Plugin
implements ActionPlugin,
SystemIndexPlugin,
JobSchedulerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PLUGIN_NAME = "opensearch-reports-scheduler";
    @NotNull
    public static final String LOG_PREFIX = "reports";
    @NotNull
    public static final String BASE_REPORTS_URI = "/_plugins/_reports";
    @NotNull
    public static final String LEGACY_BASE_REPORTS_URI = "/_opendistro/_reports";

    @NotNull
    public List<Setting<?>> getSettings() {
        ArrayList settingList = new ArrayList();
        settingList.addAll(PluginSettings.INSTANCE.getAllSettings());
        return settingList;
    }

    @NotNull
    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object[] objectArray = new SystemIndexDescriptor[]{new SystemIndexDescriptor(".opendistro-reports-definitions", "Reports Scheduler Plugin Definitions index"), new SystemIndexDescriptor(".opendistro-reports-instances", "Reports Scheduler Plugin Instances index")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesServiceSupplier, (String)"repositoriesServiceSupplier");
        PluginSettings.INSTANCE.addSettingsUpdateConsumer(clusterService);
        ReportDefinitionsIndex.INSTANCE.initialize(client, clusterService);
        ReportInstancesIndex.INSTANCE.initialize(client, clusterService);
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getJobType() {
        return "reports-scheduler";
    }

    @NotNull
    public String getJobIndex() {
        return ".opendistro-reports-definitions";
    }

    @NotNull
    public ScheduledJobRunner getJobRunner() {
        return ReportDefinitionJobRunner.INSTANCE;
    }

    @NotNull
    public ScheduledJobParser getJobParser() {
        return ReportDefinitionJobParser.INSTANCE;
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @NotNull ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @NotNull SettingsFilter settingsFilter, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)settingsFilter, (String)"settingsFilter");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        Object[] objectArray = new BaseRestHandler[]{new ReportDefinitionRestHandler(), new ReportDefinitionListRestHandler(), new ReportInstanceRestHandler(), new ReportInstanceListRestHandler(), new OnDemandReportRestHandler(), new ReportStatsRestHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler(CreateReportDefinitionAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), CreateReportDefinitionAction.class, new Class[0]), new ActionPlugin.ActionHandler(DeleteReportDefinitionAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), DeleteReportDefinitionAction.class, new Class[0]), new ActionPlugin.ActionHandler(GetAllReportDefinitionsAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), GetAllReportDefinitionsAction.class, new Class[0]), new ActionPlugin.ActionHandler(GetAllReportInstancesAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), GetAllReportInstancesAction.class, new Class[0]), new ActionPlugin.ActionHandler(GetReportDefinitionAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), GetReportDefinitionAction.class, new Class[0]), new ActionPlugin.ActionHandler(GetReportInstanceAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), GetReportInstanceAction.class, new Class[0]), new ActionPlugin.ActionHandler(InContextReportCreateAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), InContextReportCreateAction.class, new Class[0]), new ActionPlugin.ActionHandler(OnDemandReportCreateAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), OnDemandReportCreateAction.class, new Class[0]), new ActionPlugin.ActionHandler(UpdateReportDefinitionAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), UpdateReportDefinitionAction.class, new Class[0]), new ActionPlugin.ActionHandler(UpdateReportInstanceStatusAction.Companion.getACTION_TYPE$opensearch_reports_scheduler(), UpdateReportInstanceStatusAction.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/reportsscheduler/ReportsSchedulerPlugin$Companion;", "", "()V", "BASE_REPORTS_URI", "", "LEGACY_BASE_REPORTS_URI", "LOG_PREFIX", "PLUGIN_NAME", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

